/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.device;

import com.google.common.collect.ImmutableList;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableConversion;
import com.tibbo.aggregate.common.datatable.DataTableException;
import com.tibbo.aggregate.common.device.DeviceEntities;
import com.tibbo.aggregate.common.device.DeviceEntityDescriptor;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeviceEntityDescriptorList
implements DeviceEntities {
    public static final DeviceEntityDescriptorList EMPTY = new DeviceEntityDescriptorList((List<DeviceEntityDescriptor>)ImmutableList.of());
    private final Map<String, DeviceEntityDescriptor> entities = new LinkedHashMap<String, DeviceEntityDescriptor>();

    public DeviceEntityDescriptorList(List<DeviceEntityDescriptor> entities) {
        for (DeviceEntityDescriptor descr : entities) {
            this.entities.put(descr.getName(), descr);
        }
    }

    public DeviceEntityDescriptorList() {
    }

    public static DeviceEntityDescriptorList difference(DeviceEntityDescriptorList left, DeviceEntityDescriptorList right) {
        DeviceEntityDescriptorList list = new DeviceEntityDescriptorList();
        for (Map.Entry<String, DeviceEntityDescriptor> entry : left.getDescriptors().entrySet()) {
            if (!right.getDescriptors().containsKey(entry.getKey())) {
                list.getDescriptors().put(entry.getKey(), entry.getValue());
                continue;
            }
            if (right.getDescriptors().get(entry.getKey()).equals(entry.getValue())) continue;
            list.getDescriptors().put(entry.getKey(), entry.getValue());
        }
        return list;
    }

    public DataTable toDataTable() {
        try {
            return DataTableConversion.beansToTable(this.entities.values(), DeviceEntityDescriptor.FORMAT, true);
        }
        catch (DataTableException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    private boolean contains(String entity) {
        return this.entities.containsKey(entity);
    }

    @Override
    public boolean isActive(String entity) {
        if (this.entities.containsKey(entity)) {
            return this.entities.get(entity).getActive();
        }
        return true;
    }

    public void merge(DeviceEntityDescriptorList other, Set<String> defaultActiveEntities) {
        for (Map.Entry<String, DeviceEntityDescriptor> e : this.entities.entrySet()) {
            if (other.contains(e.getKey())) {
                e.getValue().setActive(other.isActive(e.getKey()));
                continue;
            }
            if (e.getValue().getActive().booleanValue() || defaultActiveEntities == null || !defaultActiveEntities.contains(e.getKey())) continue;
            e.getValue().setActive(true);
        }
    }

    @Override
    public Map<String, DeviceEntityDescriptor> getDescriptors() {
        return this.entities;
    }

    @Override
    public boolean hasSpecificEntities() {
        return this != EMPTY;
    }
}

