/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.device;

import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.EventDefinition;
import com.tibbo.aggregate.common.context.FunctionDefinition;
import com.tibbo.aggregate.common.context.VariableDefinition;
import com.tibbo.aggregate.common.context.VariableStatus;
import com.tibbo.aggregate.common.data.Event;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.device.DeviceAssetDefinition;
import com.tibbo.aggregate.common.device.DeviceContext;
import com.tibbo.aggregate.common.device.DeviceEntities;
import com.tibbo.aggregate.common.device.DeviceEntityDescriptor;
import com.tibbo.aggregate.common.device.DeviceException;
import com.tibbo.aggregate.common.device.DisconnectionException;
import com.tibbo.aggregate.common.device.sync.SynchronizationParameters;
import com.tibbo.aggregate.common.discovery.DiscoveryProvider;
import com.tibbo.aggregate.common.event.Acknowledgement;
import com.tibbo.aggregate.common.expression.Expression;
import com.tibbo.aggregate.common.plugin.AggreGatePlugin;
import java.util.Date;
import java.util.List;
import java.util.Set;

public interface DeviceDriver
extends AggreGatePlugin {
    public TableFormat createConnectionPropertiesFormat();

    public void setupDeviceContext(DeviceContext var1) throws ContextException;

    public void configureDeviceAccount(DeviceContext var1, CallerController var2) throws ContextException;

    public void accessSettingUpdated(String var1);

    public DiscoveryProvider createDiscoveryProvider();

    public boolean shouldSynchronize(SynchronizationParameters var1) throws ContextException;

    public void startSynchronization() throws DeviceException;

    public boolean isUsesConnections();

    public boolean isConnected();

    public void connect() throws DeviceException;

    public void disconnect() throws DeviceException;

    public boolean isUsesAssets();

    public void readBufferedData() throws ContextException, DeviceException, DisconnectionException;

    public List<DeviceAssetDefinition> readAssets() throws ContextException, DeviceException, DisconnectionException;

    public List<DeviceEntityDescriptor> readVariableDescriptors(List<DeviceAssetDefinition> var1) throws ContextException, DeviceException, DisconnectionException;

    public List<DeviceEntityDescriptor> readFunctionDescriptors(List<DeviceAssetDefinition> var1) throws ContextException, DeviceException, DisconnectionException;

    public List<DeviceEntityDescriptor> readEventDescriptors(List<DeviceAssetDefinition> var1) throws ContextException, DeviceException, DisconnectionException;

    public boolean isUseDeviceSideValuesCache();

    public List<VariableDefinition> readVariableDefinitions(DeviceEntities var1) throws ContextException, DeviceException, DisconnectionException;

    public List<VariableDefinition> readVariableDefinitions(List<DeviceAssetDefinition> var1, DeviceEntities var2) throws ContextException, DeviceException, DisconnectionException;

    public List<FunctionDefinition> readFunctionDefinitions(DeviceEntities var1) throws ContextException, DeviceException, DisconnectionException;

    public List<FunctionDefinition> readFunctionDefinitions(List<DeviceAssetDefinition> var1, DeviceEntities var2) throws ContextException, DeviceException, DisconnectionException;

    public List<EventDefinition> readEventDefinitions(DeviceEntities var1) throws ContextException, DeviceException, DisconnectionException;

    public List<EventDefinition> readEventDefinitions(List<DeviceAssetDefinition> var1, DeviceEntities var2) throws ContextException, DeviceException, DisconnectionException;

    public DataTable readVariableValue(VariableDefinition var1, CallerController var2) throws ContextException, DeviceException, DisconnectionException;

    public void writeVariableValue(VariableDefinition var1, CallerController var2, DataTable var3, DataTable var4) throws ContextException, DeviceException, DisconnectionException;

    public DataTable executeFunction(FunctionDefinition var1, CallerController var2, DataTable var3) throws ContextException, DeviceException, DisconnectionException;

    public Date getVariableModificationTime(String var1) throws DeviceException, DisconnectionException;

    public void updateVariableModificationTime(String var1, Date var2) throws DeviceException, DisconnectionException;

    public VariableStatus getCustomVariableStatus(String var1) throws DeviceException, DisconnectionException;

    public void finishSynchronization() throws DeviceException, DisconnectionException;

    public String getPrimaryAddress();

    public Set<String> getAddresses();

    public String getProtocol();

    public String getStatus();

    public List<Expression> getStatusExpressions(CallerController var1);

    public boolean runFullSynchronizationOnStartup();

    public VariableDefinition discoverVariable(String var1, Object var2);

    public FunctionDefinition discoverFunction(String var1, Object var2);

    public EventDefinition discoverEvent(String var1, Object var2);

    public void acklowledgeEvent(Event var1, Acknowledgement var2) throws ContextException, DeviceException;

    public void deviceDestroyed(boolean var1);

    public void deviceMoved(Context var1, String var2) throws ContextException;

    default public Context createDeviceContext(DeviceDriver driver, Context userContext, String cname) {
        return null;
    }
}

