/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.device;

import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.EventDefinition;
import com.tibbo.aggregate.common.context.FunctionDefinition;
import com.tibbo.aggregate.common.context.VariableDefinition;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.device.AccessSettingReinizializer;
import com.tibbo.aggregate.common.device.DeviceAssetDefinition;
import com.tibbo.aggregate.common.device.DeviceDriver;
import com.tibbo.aggregate.common.device.DeviceException;
import com.tibbo.aggregate.common.device.DeviceSettingStatus;
import com.tibbo.aggregate.common.device.DisconnectionException;
import com.tibbo.aggregate.common.device.sync.SettingSynchronizationOptions;
import com.tibbo.aggregate.common.device.sync.SynchronizationHandler;
import com.tibbo.aggregate.common.device.sync.SynchronizationParameters;
import com.tibbo.aggregate.common.device.sync.SynchronizationResult;
import com.tibbo.aggregate.common.server.ServerContext;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public interface DeviceContext<C extends ServerContext>
extends ServerContext<C> {
    public static final int CONNECTION_STATUS_OFFLINE = 0;
    public static final int CONNECTION_STATUS_ONLINE = 1;
    public static final int CONNECTION_STATUS_SUSPENDED = 2;
    public static final int CONNECTION_STATUS_UNKNOWN = 3;
    public static final int CONNECTION_STATUS_MAINTENANCE = 4;
    public static final int SYNC_STATUS_OK = 20;
    public static final int SYNC_STATUS_WAITING = 30;
    public static final int SYNC_STATUS_ERROR = 40;
    public static final int SYNC_STATUS_UNDEFINED = 50;
    public static final int SYNC_STATUS_CONNECTING = 70;
    public static final int SYNC_STATUS_READING_METADATA = 80;
    public static final int SYNC_STATUS_SYNCHRONIZING_SETTINGS = 90;
    public static final int CURRENT_SYNC_STATUS_CONNECTING = 0;
    public static final int CURRENT_SYNC_STATUS_READING_METADATA = 1;
    public static final int CURRENT_SYNC_STATUS_SYNCHRONIZING_PROPERTIES = 2;
    public static final int SYNC_MODE_NORMAL = 0;
    public static final int SYNC_MODE_DISABLED = 1;
    public static final int SYNC_MODE_DIRECT_ACCESS = 2;
    public static final int SYNC_MODE_MASTER_VALUE = 3;
    public static final int SYNC_MODE_IGNORE_MODIFICATION_TIME = 4;
    public static final int SYNC_MODE_READ_ONLY = 5;
    public static final int SYNC_MODE_DIRECT_WRITE = 6;
    public static final int SYNC_MODE_CUSTOM = 100;
    public static final int DIRECTION_NONE = -1;
    public static final int DIRECTION_AUTO = 0;
    public static final int DIRECTION_DEVICE_TO_SERVER = 1;
    public static final int DIRECTION_SERVER_TO_DEVICE = 2;
    public static final int HISTORY_RATE_UNCHANGED = 0;
    public static final int HISTORY_RATE_NORMAL = -1;
    public static final int HISTORY_RATE_ERROR = -3;
    public static final int HISTORY_RATE_UNCHANGED_OFFLINE = -4;
    public static final int HISTORY_RATE_UNCHANGED_ERROR = -5;
    public static final int HISTORY_RATE_OFFLINE_ERROR = -6;
    public static final int HISTORY_RATE_UNCHANGED_OFFLINE_ERROR = -7;
    public static final int CHANGE_EVENT_TIMESTAMP_DRIVER = 0;
    public static final int CHANGE_EVENT_TIMESTAMP_SERVER = 1;

    public CallerController getCallerController();

    public DeviceDriver getDriver();

    public String getAddress();

    public List<DeviceAssetDefinition> getAssets();

    public SettingSynchronizationOptions getSynchronizationOptions(String var1);

    public DeviceSettingStatus getSettingStatus(String var1);

    public boolean isOnline();

    public void setDefaultSynchronizationPeriod(long var1);

    public void setDefaultStatusExpression(String var1);

    public void setDefaultColorExpression(String var1);

    public void setDefaultLatitudeExpression(String var1);

    public void setDefaultLongitudeExpression(String var1);

    public void setDefaultCacheMode(int var1);

    public void setDefaultEventStoragePeriod(long var1);

    public void setDefaultSynchronizationOptions(String var1, SettingSynchronizationOptions var2);

    public void setDefaultSynchronizationOptions(String var1, boolean var2, SettingSynchronizationOptions var3);

    public void setCustomSynchronizationHandler(String var1, SynchronizationHandler var2, boolean var3);

    public void removeCustomSynchronizationHandler(String var1);

    public void setDeviceType(String var1) throws ContextException;

    public void setAccessSettingReinitializer(String var1, AccessSettingReinizializer var2);

    public void requestReconnection();

    public void requestSynchronization();

    public void requestSynchronization(boolean var1);

    public void requestSynchronization(SynchronizationParameters var1);

    public void requestAssetsUpdate();

    public void asyncVariableUpdate(String var1, DataTable var2) throws DisconnectionException, ContextException, DeviceException;

    public void processHistoricalValue(String var1, Date var2, DataTable var3) throws ContextException;

    public ReentrantLock getSynchronizationLock();

    public SynchronizationResult executeSynchronization(SynchronizationParameters var1);

    public void setOnline(boolean var1);

    public VariableDefinition discoverDeviceVariable(String var1, int var2, Object var3) throws ContextException;

    public FunctionDefinition discoverDeviceFunction(String var1, int var2, Object var3) throws ContextException;

    public EventDefinition discoverDeviceEvent(String var1, int var2, Object var3) throws ContextException;

    public void setUsePredefinedQualityCodes(boolean var1);
}

