/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.validator;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.ValidationException;
import com.tibbo.aggregate.common.datatable.validator.AbstractTableValidator;
import com.tibbo.aggregate.common.util.StringUtils;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;

public class TableKeyFieldsValidator
extends AbstractTableValidator {
    public TableKeyFieldsValidator() {
    }

    public TableKeyFieldsValidator(String source) {
    }

    @Override
    public String encode() {
        return "";
    }

    @Override
    public Character getType() {
        return Character.valueOf('K');
    }

    @Override
    public void validate(DataTable table) throws ValidationException {
        List<String> keyFields = table.getFormat().getKeyFields();
        if (keyFields.size() == 0) {
            return;
        }
        HashSet<String> uniqueSet = new HashSet<String>();
        for (DataRecord record : table) {
            int oldSize = uniqueSet.size();
            StringBuilder keys = new StringBuilder();
            for (String keyField : keyFields) {
                Object value = record.getValue(keyField);
                keys.append(value);
            }
            uniqueSet.add(keys.toString());
            if (oldSize != uniqueSet.size()) continue;
            throw new ValidationException(MessageFormat.format(Cres.get().getString("dtKeyFieldViolation"), keys, StringUtils.print(keyFields)));
        }
    }
}

