/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.validator;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.datatable.ValidationException;
import com.tibbo.aggregate.common.datatable.validator.AbstractFieldValidator;
import java.text.MessageFormat;
import java.util.regex.PatternSyntaxException;

public class RegexValidator
extends AbstractFieldValidator {
    private static final String SEPARATOR = "^^";
    private static final String SEPARATOR_REGEX = "\\^\\^";
    private String regex;
    private String message;

    public RegexValidator(String source) {
        String[] parts = source.split(SEPARATOR_REGEX);
        this.regex = parts[0];
        if (parts.length > 1) {
            this.message = parts[1];
        }
    }

    public RegexValidator(String regex, String message) {
        this.regex = regex;
        this.message = message;
    }

    @Override
    public boolean shouldEncode() {
        return true;
    }

    @Override
    public String encode() {
        return this.regex + (this.message != null ? SEPARATOR + this.message : "");
    }

    @Override
    public Character getType() {
        return Character.valueOf('R');
    }

    public Object validate(Context context, ContextManager contextManager, CallerController caller, Object value) throws ValidationException {
        try {
            if (value != null && !value.toString().matches(this.regex)) {
                throw new ValidationException(this.message != null ? this.message : MessageFormat.format(Cres.get().getString("dtValueDoesNotMatchPattern"), value, this.regex));
            }
        }
        catch (PatternSyntaxException ex) {
            throw new ValidationException(ex.getMessage(), ex);
        }
        return value;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.regex == null ? 0 : this.regex.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegexValidator other = (RegexValidator)obj;
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return !(this.regex == null ? other.regex != null : !this.regex.equals(other.regex));
    }
}

