/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.validator;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.data.Data;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.ValidationException;
import com.tibbo.aggregate.common.datatable.validator.AbstractFieldValidator;
import com.tibbo.aggregate.common.util.StringUtils;
import java.text.MessageFormat;
import java.util.List;

public class LimitsValidator
extends AbstractFieldValidator {
    private static final char MIN_MAX_SEPARATOR = ' ';
    private Comparable min;
    private Comparable max;

    public LimitsValidator(FieldFormat fieldFormat, String source) {
        List<String> minMax = StringUtils.split(source, ' ');
        if (fieldFormat.getType() == 'A' || fieldFormat.getType() == 'S') {
            if (minMax.size() > 1) {
                this.min = new Integer(minMax.get(0));
                this.max = new Integer(minMax.get(1));
            } else {
                this.max = new Integer(minMax.get(0));
            }
        } else if (minMax.size() > 1) {
            this.min = (Comparable)fieldFormat.valueFromString(minMax.get(0));
            this.max = (Comparable)fieldFormat.valueFromString(minMax.get(1));
        } else {
            this.max = (Comparable)fieldFormat.valueFromString(minMax.get(0));
        }
    }

    public LimitsValidator(Comparable min, Comparable max) {
        this.setLimits(min, max);
    }

    protected void setLimits(Comparable min, Comparable max) {
        if (min != null && max != null && !min.getClass().equals(max.getClass())) {
            Log.DATATABLE.error((Object)"'min' and 'max' Limits Validator parameters should be the same type", new Throwable());
        }
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean shouldEncode() {
        return true;
    }

    @Override
    public Character getType() {
        return Character.valueOf('L');
    }

    public Comparable getMin() {
        return this.min;
    }

    public Comparable getMax() {
        return this.max;
    }

    @Override
    public String encode() {
        return this.min != null ? this.min.toString() + (this.max != null ? ' ' + this.max.toString() : "") : (this.max != null ? this.max.toString() : "");
    }

    public Object validate(Context context, ContextManager contextManager, CallerController caller, Object value) throws ValidationException {
        if (value == null) {
            return value;
        }
        if (value instanceof Data) {
            Data data = (Data)value;
            if (data.getData() != null) {
                Integer size = data.getData().length;
                this.compare(size, null, null);
            }
        } else if (value instanceof String) {
            this.compare(Integer.valueOf(value.toString().length()), Cres.get().getString("dtValueTooShort"), Cres.get().getString("dtValueTooLong"));
        } else {
            if (!(value instanceof Comparable)) {
                throw new ValidationException("Value not comparable: " + value);
            }
            Comparable cv = (Comparable)value;
            this.compare(cv, null, null);
        }
        return value;
    }

    private void compare(Comparable cv, String smallMessage, String bigMessage) throws ValidationException {
        if (this.min != null && cv.compareTo(this.min) < 0) {
            throw new ValidationException(MessageFormat.format(smallMessage != null ? smallMessage : Cres.get().getString("dtValueTooSmall"), cv, this.min));
        }
        if (cv.compareTo(this.max) > 0) {
            throw new ValidationException(MessageFormat.format(bigMessage != null ? bigMessage : Cres.get().getString("dtValueTooBig"), cv, this.max));
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.max == null ? 0 : this.max.hashCode());
        result = 31 * result + (this.min == null ? 0 : this.min.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LimitsValidator other = (LimitsValidator)obj;
        if (this.max == null ? other.max != null : !this.max.equals(other.max)) {
            return false;
        }
        return !(this.min == null ? other.min != null : !this.min.equals(other.min));
    }
}

