/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.validator;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableQuery;
import com.tibbo.aggregate.common.datatable.QueryCondition;
import com.tibbo.aggregate.common.datatable.ValidationException;
import com.tibbo.aggregate.common.datatable.validator.AbstractRecordValidator;
import com.tibbo.aggregate.common.util.StringUtils;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;

public class KeyFieldsValidator
extends AbstractRecordValidator {
    public KeyFieldsValidator() {
    }

    public KeyFieldsValidator(String source) {
    }

    @Override
    public String encode() {
        return "";
    }

    @Override
    public Character getType() {
        return Character.valueOf('K');
    }

    @Override
    public void validate(DataTable table, DataRecord record) throws ValidationException {
        List<String> keyFields = table.getFormat().getKeyFields();
        if (keyFields.size() == 0) {
            return;
        }
        DataTableQuery query = new DataTableQuery(new QueryCondition[0]);
        LinkedList<Object> key = new LinkedList<Object>();
        for (String keyField : keyFields) {
            Object value = record.getValue(keyField);
            key.add(value);
            query.addCondition(new QueryCondition(keyField, value));
        }
        DataRecord rec = table.select(query);
        if (rec != null && rec != record) {
            throw new ValidationException(MessageFormat.format(Cres.get().getString("dtKeyFieldViolation"), key, StringUtils.print(keyFields)));
        }
    }
}

