/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.validator;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.datatable.ValidationException;
import com.tibbo.aggregate.common.datatable.validator.AbstractFieldValidator;
import com.tibbo.aggregate.common.expression.EvaluationException;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.expression.Expression;
import com.tibbo.aggregate.common.util.SyntaxErrorException;
import java.text.MessageFormat;
import java.util.regex.PatternSyntaxException;

public class ExpressionValidator
extends AbstractFieldValidator {
    private static final String SEPARATOR = "^^";
    private static final String SEPARATOR_REGEX = "\\^\\^";
    private String expression;
    private String message;

    public ExpressionValidator(String source) {
        String[] parts = source.split(SEPARATOR_REGEX);
        this.expression = parts[0];
        if (parts.length > 1) {
            this.message = parts[1];
        }
    }

    public ExpressionValidator(String expression, String message) {
        this.expression = expression;
        this.message = message;
    }

    @Override
    public boolean shouldEncode() {
        return true;
    }

    @Override
    public String encode() {
        return this.expression + (this.message != null ? SEPARATOR + this.message : "");
    }

    @Override
    public Character getType() {
        return Character.valueOf('E');
    }

    public Boolean evaluateExpression(Context context, ContextManager contextManager, CallerController caller, Object value) throws ValidationException {
        Boolean result = false;
        Evaluator evaluator = new Evaluator(contextManager, context, null, caller);
        evaluator.getEnvironmentResolver().getEnvironment().put("value", value);
        if (this.expression != null && !this.expression.isEmpty()) {
            try {
                result = evaluator.evaluateToBooleanOrNull(new Expression(this.expression));
                if (result == null) {
                    result = false;
                }
            }
            catch (SyntaxErrorException ex) {
                throw new ValidationException(ex.getMessage(), ex);
            }
            catch (EvaluationException ex) {
                throw new ValidationException(ex.getMessage(), ex);
            }
        }
        return result;
    }

    public Object validate(Context context, ContextManager contextManager, CallerController caller, Object value) throws ValidationException {
        Boolean evaluationResult = false;
        try {
            evaluationResult = this.evaluateExpression(context, contextManager, caller, value);
            if (!evaluationResult.booleanValue()) {
                throw new ValidationException(this.message != null ? this.message : MessageFormat.format(Cres.get().getString("dtValueDoesNotMatchExpression"), value, this.expression));
            }
        }
        catch (PatternSyntaxException ex) {
            throw new ValidationException(ex.getMessage(), ex);
        }
        return value;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionValidator other = (ExpressionValidator)obj;
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return !(this.expression == null ? other.expression != null : !this.expression.equals(other.expression));
    }
}

