/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.field;

import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.ValidationException;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.util.Util;
import java.util.Arrays;
import java.util.List;

public class LongFieldFormat
extends FieldFormat<Long> {
    public static final String EDITOR_PERIOD = "period";

    public LongFieldFormat(String name) {
        super(name);
    }

    @Override
    public char getType() {
        return 'L';
    }

    @Override
    public Class<Long> getFieldClass() {
        return Long.TYPE;
    }

    @Override
    public Class<Long> getFieldWrappedClass() {
        return Long.class;
    }

    @Override
    public Long getNotNullDefault() {
        return 0L;
    }

    @Override
    protected Object convertValue(Object value) throws ValidationException {
        if (value != null && !(value instanceof Long)) {
            value = Util.convertToNumber(value, true, false).longValue();
        }
        return value;
    }

    @Override
    public Long valueFromString(String value, ClassicEncodingSettings settings, boolean validate) {
        try {
            return new Long(value);
        }
        catch (NumberFormatException ex) {
            return Util.convertToNumber(value, validate, false).longValue();
        }
    }

    @Override
    public String valueToString(Long value, ClassicEncodingSettings settings) {
        return value == null ? null : value.toString();
    }

    @Override
    public List<String> getSuitableEditors() {
        return Arrays.asList("list", EDITOR_PERIOD, "bar", "bytes", "instance", "foreignInstance", "formatString");
    }

    public static String encodePeriodEditorOptions(int minUnit, int maxUnit) {
        return minUnit + " " + String.valueOf(maxUnit);
    }
}

