/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.field;

import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.ValidationException;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.util.Util;
import java.util.Arrays;
import java.util.List;

public class FloatFieldFormat
extends FieldFormat<Float> {
    public FloatFieldFormat(String name) {
        super(name);
    }

    @Override
    public char getType() {
        return 'F';
    }

    @Override
    public Class<Float> getFieldClass() {
        return Float.TYPE;
    }

    @Override
    public Class<Float> getFieldWrappedClass() {
        return Float.class;
    }

    @Override
    public Float getNotNullDefault() {
        return Float.valueOf(0.0f);
    }

    @Override
    protected Object convertValue(Object value) throws ValidationException {
        if (value != null && !(value instanceof Float)) {
            value = Float.valueOf(Util.convertToNumber(value, true, false).floatValue());
        }
        return value;
    }

    @Override
    public Float valueFromString(String value, ClassicEncodingSettings settings, boolean validate) {
        if (value.length() == 0) {
            return Float.valueOf(0.0f);
        }
        try {
            return new Float(value);
        }
        catch (NumberFormatException ex) {
            return Float.valueOf(Util.convertToNumber(value, validate, false).floatValue());
        }
    }

    @Override
    public String valueToString(Float value, ClassicEncodingSettings settings) {
        return value == null ? null : value.toString();
    }

    @Override
    public List<String> getSuitableEditors() {
        return Arrays.asList("list", "bar", "bytes", "instance", "formatString");
    }
}

