/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.field;

import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.ValidationException;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.util.Util;
import java.util.Arrays;
import java.util.List;

public class DoubleFieldFormat
extends FieldFormat<Double> {
    public DoubleFieldFormat(String name) {
        super(name);
    }

    @Override
    public char getType() {
        return 'E';
    }

    @Override
    public Class<Double> getFieldClass() {
        return Double.TYPE;
    }

    @Override
    public Class<Double> getFieldWrappedClass() {
        return Double.class;
    }

    @Override
    public Double getNotNullDefault() {
        return 0.0;
    }

    @Override
    protected Object convertValue(Object value) throws ValidationException {
        if (value != null && !(value instanceof Double)) {
            value = Util.convertToNumber(value, true, false).doubleValue();
        }
        return value;
    }

    @Override
    public Double valueFromString(String value, ClassicEncodingSettings settings, boolean validate) {
        if (value.length() == 0) {
            return 0.0;
        }
        try {
            return new Double(value);
        }
        catch (NumberFormatException ex) {
            return Util.convertToNumber(value, validate, false).doubleValue();
        }
    }

    @Override
    public String valueToString(Double value, ClassicEncodingSettings settings) {
        return value == null ? null : value.toString();
    }

    @Override
    public List<String> getSuitableEditors() {
        return Arrays.asList("list", "bar", "instance", "formatString");
    }
}

