/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.field;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.ValidationException;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.util.DateUtils;
import com.tibbo.aggregate.common.util.Util;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class DateFieldFormat
extends FieldFormat<Date> {
    public static final String EDITOR_TIME = "time";
    public static final String EDITOR_DATE = "date";
    private static Date DEFAULT_DATE;
    private static String DATE_PATTERN;
    private static ThreadLocal<GregorianCalendar> CALENDAR_THREAD_LOCAL;

    public DateFieldFormat(String name) {
        super(name);
    }

    @Override
    public char getType() {
        return 'D';
    }

    @Override
    public Class getFieldClass() {
        return Date.class;
    }

    @Override
    public Class getFieldWrappedClass() {
        return Date.class;
    }

    @Override
    public Date getNotNullDefault() {
        return DEFAULT_DATE;
    }

    private static GregorianCalendar getCalendar() {
        GregorianCalendar gc = CALENDAR_THREAD_LOCAL.get();
        if (gc == null) {
            gc = new GregorianCalendar(DateUtils.UTC_TIME_ZONE);
            CALENDAR_THREAD_LOCAL.set(gc);
        }
        return gc;
    }

    @Override
    public Date valueFromString(String value, ClassicEncodingSettings settings, boolean validate) {
        try {
            return DateFieldFormat.dateFromString(value);
        }
        catch (Exception ex) {
            try {
                return Util.convertToDate(value, true, true);
            }
            catch (Exception ex1) {
                throw new IllegalArgumentException("Error parsing date from string '" + value + "': " + ex.getMessage(), ex);
            }
        }
    }

    @Override
    public String valueToString(Date value, ClassicEncodingSettings settings) {
        try {
            if (value == null) {
                return null;
            }
            return DateFieldFormat.dateToString(value);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error converting date " + value + " to string: " + ex.getMessage(), ex);
        }
    }

    public static Date dateFromString(String value) {
        if (!value.matches(DATE_PATTERN)) {
            throw new IllegalStateException("Illegal value format");
        }
        String[] splitValue = value.split("\\D");
        GregorianCalendar gc = DateFieldFormat.getCalendar();
        gc.set(1, Integer.parseInt(splitValue[0]));
        gc.set(2, Integer.parseInt(splitValue[1]) - 1);
        gc.set(5, Integer.parseInt(splitValue[2]));
        gc.set(11, Integer.parseInt(splitValue[3]));
        gc.set(12, Integer.parseInt(splitValue[4]));
        gc.set(13, Integer.parseInt(splitValue[5]));
        gc.set(14, Integer.parseInt(splitValue[6]));
        return gc.getTime();
    }

    public static String dateToString(Date value) {
        GregorianCalendar gc = DateFieldFormat.getCalendar();
        gc.setTime(value);
        StringBuilder sb = new StringBuilder();
        int year = gc.get(1);
        if (year < 1000) {
            sb.append("0");
        }
        if (year < 100) {
            sb.append("0");
        }
        if (year < 10) {
            sb.append("0");
        }
        sb.append(year);
        sb.append("-");
        int month = gc.get(2) + 1;
        if (month < 10) {
            sb.append("0");
        }
        sb.append(month);
        sb.append("-");
        int day = gc.get(5);
        if (day < 10) {
            sb.append("0");
        }
        sb.append(day);
        sb.append(" ");
        int hour = gc.get(11);
        if (hour < 10) {
            sb.append("0");
        }
        sb.append(hour);
        sb.append(":");
        int minute = gc.get(12);
        if (minute < 10) {
            sb.append("0");
        }
        sb.append(minute);
        sb.append(":");
        int second = gc.get(13);
        if (second < 10) {
            sb.append("0");
        }
        sb.append(second);
        sb.append(".");
        int millisecond = gc.get(14);
        if (millisecond < 100) {
            sb.append("0");
        }
        if (millisecond < 10) {
            sb.append("0");
        }
        sb.append(millisecond);
        return sb.toString();
    }

    @Override
    protected Object convertValue(Object value) throws ValidationException {
        if (value instanceof String) {
            value = this.valueFromString((String)value, null, false);
        } else if (value != null && !(value instanceof Date)) {
            value = Util.convertToDate(value, true, false);
        }
        return value;
    }

    @Override
    public List<String> getSuitableEditors() {
        return Arrays.asList("list", EDITOR_DATE, EDITOR_TIME);
    }

    static {
        DATE_PATTERN = "^\\d{4,5}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}.\\d{3}$";
        try {
            GregorianCalendar gc = new GregorianCalendar(DateUtils.UTC_TIME_ZONE);
            gc.clear();
            gc.set(2000, 1, 1, 12, 0, 0);
            DEFAULT_DATE = gc.getTime();
        }
        catch (Exception ex) {
            Log.DATATABLE.error((Object)"Error initializing default date", (Throwable)ex);
        }
        CALENDAR_THREAD_LOCAL = new ThreadLocal();
    }
}

