/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.field;

import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableReplication;
import com.tibbo.aggregate.common.datatable.DataTableUtils;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.ProxyDataTable;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.ValidationException;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.datatable.encoding.TransferEncodingHelper;
import com.tibbo.aggregate.common.datatable.validator.AbstractFieldValidator;
import com.tibbo.aggregate.common.expression.ExpressionUtils;
import com.tibbo.aggregate.common.protocol.ProtocolVersion;
import com.tibbo.aggregate.common.util.Element;
import com.tibbo.aggregate.common.util.ElementList;
import com.tibbo.aggregate.common.util.StringUtils;
import com.tibbo.aggregate.common.util.Util;
import java.util.Arrays;
import java.util.List;

public class DataTableFieldFormat
extends FieldFormat<DataTable> {
    public static final String EDITOR_DATE_RANGE = "dateRange";

    public DataTableFieldFormat(String name) {
        super(name);
        this.addValidator(new AbstractFieldValidator(){

            public Object validate(Context context, ContextManager contextManager, CallerController caller, Object value) throws ValidationException {
                DataTable def = (DataTable)DataTableFieldFormat.this.getDefaultValue();
                if (def == null || def.getFieldCount() == 0) {
                    return value;
                }
                DataTable dt = (DataTable)value;
                if (dt == null) {
                    return null;
                }
                String msg = dt.getFormat().extendMessage(def.getFormat());
                if (msg != null) {
                    DataTable newValue = def.clone();
                    DataTableReplication.copy(dt, newValue, true, true, true);
                    value = newValue;
                }
                return value;
            }
        });
    }

    @Override
    public char getType() {
        return 'T';
    }

    @Override
    public Class getFieldClass() {
        return DataTable.class;
    }

    @Override
    public Class getFieldWrappedClass() {
        return DataTable.class;
    }

    @Override
    public DataTable getNotNullDefault() {
        return new SimpleDataTable();
    }

    @Override
    protected void makeImmutable() {
        super.makeImmutable();
        DataTable defaultValue = (DataTable)this.getDefaultValue();
        if (defaultValue != null) {
            defaultValue.makeImmutable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTable valueFromString(String value, ClassicEncodingSettings settings, boolean validate) {
        DataTable dataTable;
        Boolean tempEncodeFieldNames;
        DataTable defaultValue = (DataTable)this.getDefaultValue();
        TableFormat oldFormat = null;
        if (settings != null) {
            oldFormat = settings.getFormat();
            if (defaultValue != null) {
                settings.setFormat(defaultValue.getFormat());
            }
            tempEncodeFieldNames = settings.isEncodeFieldNames();
        } else {
            settings = new ClassicEncodingSettings(ExpressionUtils.useVisibleSeparators(value));
            tempEncodeFieldNames = false;
        }
        try {
            DataTable res = null;
            if (value != null) {
                ElementList elements = StringUtils.elements(value, settings.isUseVisibleSeparators());
                boolean containsID = elements.stream().map(Element::getName).anyMatch("C"::equals);
                DataTable dataTable2 = res = containsID ? new ProxyDataTable(elements, settings, validate, null) : new SimpleDataTable(elements, settings, validate);
            }
            if (!(defaultValue == null || defaultValue.getFieldCount() <= 0 || res != null && res.getFormat().extend(defaultValue.getFormat()))) {
                DataTable newRes = ((DataTable)this.getDefaultValue()).clone();
                DataTableReplication.copy(res, newRes, true, true, true);
                res = newRes;
            }
            if (res != null && validate) {
                res.validate(null, null, null);
            }
            dataTable = res;
        }
        catch (Throwable throwable) {
            try {
                settings.setFormat(oldFormat);
                if (tempEncodeFieldNames.booleanValue()) {
                    settings.setEncodeFieldNames(true);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Error constructing value of field '" + this.toString() + "': " + ex.getMessage(), ex);
            }
        }
        settings.setFormat(oldFormat);
        if (tempEncodeFieldNames.booleanValue()) {
            settings.setEncodeFieldNames(true);
        }
        return dataTable;
    }

    @Override
    public DataTable valueFromEncodedString(String source, ClassicEncodingSettings settings, boolean validate) {
        boolean compatibilityTransferEncode;
        String nullElement = settings.isUseVisibleSeparators() ? "<NULL>" : DataTableUtils.DATA_TABLE_NULL;
        boolean sourceIsNull = source.equals(nullElement);
        boolean bl = compatibilityTransferEncode = ProtocolVersion.V3.equals((Object)settings.getProtocolVersion()) || ProtocolVersion.V2.equals((Object)settings.getProtocolVersion());
        return sourceIsNull ? null : this.valueFromString(compatibilityTransferEncode ? DataTableUtils.transferDecode(source, settings) : source, settings, validate);
    }

    @Override
    public StringBuilder valueToEncodedString(DataTable value, ClassicEncodingSettings settings, StringBuilder sb, Integer encodeLevel) {
        String strVal = this.valueToString(value, settings);
        if (strVal == null) {
            return sb.append(settings == null || !settings.isUseVisibleSeparators() ? DataTableUtils.DATA_TABLE_NULL : "<NULL>");
        }
        if (settings != null) {
            boolean compatibilityTransferEncode;
            boolean bl = compatibilityTransferEncode = ProtocolVersion.V3.equals((Object)settings.getProtocolVersion()) || ProtocolVersion.V2.equals((Object)settings.getProtocolVersion());
            if (compatibilityTransferEncode) {
                return TransferEncodingHelper.encode(strVal, sb, encodeLevel);
            }
        }
        return sb.append(strVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String valueToString(DataTable value, ClassicEncodingSettings settings) {
        if (value == null) {
            return null;
        }
        Boolean oldEncodeFormat = settings != null ? Boolean.valueOf(settings.isEncodeFormat()) : null;
        try {
            if (!(settings == null || this.getDefaultValue() != null && ((DataTable)this.getDefaultValue()).getFieldCount() != 0 && Util.equals(((DataTable)this.getDefaultValue()).getFormat(), value.getFormat()))) {
                settings.setEncodeFormat(true);
            }
            String string = value.encode(settings);
            return string;
        }
        finally {
            if (oldEncodeFormat != null) {
                settings.setEncodeFormat(oldEncodeFormat);
            }
        }
    }

    @Override
    public List<String> getSuitableEditors() {
        return Arrays.asList("list", EDITOR_DATE_RANGE);
    }

    public static String encodeEditorOptions(boolean showTableData) {
        return showTableData ? "1" : "0";
    }
}

