/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.field;

import com.tibbo.aggregate.common.data.Data;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import java.util.Arrays;
import java.util.List;

public class DataFieldFormat
extends FieldFormat<Data> {
    public static final String EDITOR_TEXT = "dtext";
    public static final String EDITOR_IMAGE = "image";
    public static final String EDITOR_SOUND = "sound";
    public static final String EDITOR_HEX = "hex";
    public static final String EDITOR_REPORT = "report";
    public static final String EDITOR_REFERENCE = "reference";
    public static final String EXTENSIONS_DESCR_FIELD = "extensionsDescr";
    public static final String MODE_FIELD = "mode";
    public static final String EXTENSIONS_FIELD = "extensions";
    public static final String EXTENSION_FIELD = "extensionsFolder";
    public static final String FOLDER_FIELD = "folder";
    public static TableFormat EXTENSIONS_FORMAT = new TableFormat();
    public static TableFormat DATA_EDITOR_OPTIONS_FORMAT = new TableFormat(1, 1);

    public DataFieldFormat(String name) {
        super(name);
        this.setTransferEncode(true);
    }

    @Override
    public char getType() {
        return 'A';
    }

    @Override
    public Class getFieldClass() {
        return Data.class;
    }

    @Override
    public Class getFieldWrappedClass() {
        return Data.class;
    }

    @Override
    public Data getNotNullDefault() {
        Data data = new Data();
        data.setShallowCopy(this.isShallow());
        return data;
    }

    @Override
    public Data valueFromString(String value, ClassicEncodingSettings settings, boolean validate) {
        try {
            Data data = new Data(value);
            data.setShallowCopy(this.isShallow());
            return data;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid data block: " + ex.getMessage(), ex);
        }
    }

    @Override
    public String valueToString(Data value, ClassicEncodingSettings settings) {
        if (value == null) {
            return null;
        }
        return value.encode();
    }

    @Override
    public StringBuilder valueToEncodedString(Data value, ClassicEncodingSettings settings, StringBuilder sb, Integer encodeLevel) {
        if (value != null) {
            value.encode(sb, settings, this.isTransferEncode(), encodeLevel);
            return sb;
        }
        return super.valueToEncodedString(value, settings, sb, encodeLevel);
    }

    @Override
    public List<String> getSuitableEditors() {
        return Arrays.asList("list", EDITOR_TEXT, EDITOR_IMAGE, EDITOR_SOUND, EDITOR_HEX, EDITOR_REPORT);
    }

    public static String encodeTextEditorOptions(String mode) {
        return DataFieldFormat.encodeTextEditorOptions(mode, null, null, null);
    }

    public static String encodeTextEditorOptions(String extensionsDescription, String folder, List<String> extensions) {
        return DataFieldFormat.encodeTextEditorOptions(null, extensionsDescription, folder, extensions);
    }

    public static String encodeTextEditorOptions(String mode, String extensionsDescription, String folder, List<String> extensions) {
        SimpleDataTable esdt = null;
        if (extensions != null) {
            esdt = new SimpleDataTable(EXTENSIONS_FORMAT);
            for (String ext : extensions) {
                DataRecord dr = esdt.addRecord();
                dr.setValue(EXTENSION_FIELD, (Object)ext);
            }
        }
        SimpleDataTable eodt = new SimpleDataTable(DATA_EDITOR_OPTIONS_FORMAT);
        DataRecord dr = eodt.addRecord();
        dr.setValue(MODE_FIELD, (Object)mode);
        dr.setValue(FOLDER_FIELD, (Object)folder);
        dr.setValue(EXTENSIONS_DESCR_FIELD, (Object)extensionsDescription);
        dr.setValue(EXTENSIONS_FIELD, (Object)esdt);
        return eodt.encode();
    }

    static {
        FieldFormat modeF = FieldFormat.create(MODE_FIELD, 'S');
        modeF.setNullable(true);
        FieldFormat edF = FieldFormat.create(EXTENSIONS_DESCR_FIELD, 'S');
        edF.setNullable(true);
        FieldFormat extF = FieldFormat.create(EXTENSION_FIELD, 'S');
        EXTENSIONS_FORMAT.addField(extF);
        SimpleDataTable dt = new SimpleDataTable(EXTENSIONS_FORMAT);
        FieldFormat extsF = FieldFormat.create(EXTENSIONS_FIELD, 'T');
        extsF.setDefault(dt);
        extsF.setNullable(true);
        FieldFormat folderF = FieldFormat.create(FOLDER_FIELD, 'S');
        folderF.setNullable(true);
        DATA_EDITOR_OPTIONS_FORMAT.addField(modeF);
        DATA_EDITOR_OPTIONS_FORMAT.addField(edF);
        DATA_EDITOR_OPTIONS_FORMAT.addField(extsF);
        DATA_EDITOR_OPTIONS_FORMAT.addField(folderF);
    }
}

