/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.field;

import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.ValidationException;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.util.Util;

public class BooleanFieldFormat
extends FieldFormat<Boolean> {
    public BooleanFieldFormat(String name) {
        super(name);
    }

    @Override
    public char getType() {
        return 'B';
    }

    @Override
    public Class getFieldClass() {
        return Boolean.TYPE;
    }

    @Override
    public Class getFieldWrappedClass() {
        return Boolean.class;
    }

    @Override
    public Boolean getNotNullDefault() {
        return false;
    }

    @Override
    protected Object convertValue(Object value) throws ValidationException {
        if (value != null && !(value instanceof Boolean)) {
            value = Util.convertToBoolean(value, true, false);
        }
        return value;
    }

    @Override
    public Boolean valueFromString(String value, ClassicEncodingSettings settings, boolean validate) {
        return value.equals("1") || value.equalsIgnoreCase("true") ? Boolean.valueOf(true) : Boolean.valueOf(false);
    }

    @Override
    public String valueToString(Boolean value, ClassicEncodingSettings settings) {
        return value == null ? null : (value != false ? "1" : "0");
    }
}

