/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.encoding;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.binding.Binding;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.data.Data;
import com.tibbo.aggregate.common.datatable.AbstractDataTable;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.datatable.encoding.TransferEncodingHelper;
import com.tibbo.aggregate.common.datatable.encoding.XMLEncodingSettings;
import com.tibbo.aggregate.common.datatable.validator.FieldValidator;
import com.tibbo.aggregate.common.expression.ExpressionUtils;
import com.tibbo.aggregate.common.util.StringUtils;
import com.tibbo.aggregate.common.util.SyntaxErrorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.xml.utils.XMLChar;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public class XMLEncodingHelper {
    public static final String CONTENT_TYPE = "contentType";
    public static final String CONTENT_TYPE_BASE64 = "base64";
    public static final String ELEMENT_DATA_TABLE = "table";
    public static final String ELEMENT_FORMAT = "format";
    public static final String ELEMENT_FIELDS = "fields";
    public static final String ELEMENT_BINDING = "binding";
    public static final String ELEMENT_BINDINGS = "bindings";
    public static final String ELEMENT_REFERENCE = "reference";
    public static final String ELEMENT_EXPRESSION = "expression";
    public static final String ELEMENT_FIELD = "field";
    public static final String ELEMENT_SELECTION_VALUES = "selectionValues";
    public static final String ELEMENT_HELP = "help";
    public static final String ELEMENT_GROUP = "group";
    public static final String ELEMENT_OPTION = "option";
    public static final String ELEMENT_RECORDS = "records";
    public static final String ELEMENT_RECORD = "record";
    public static final String ELEMENT_DEFAULT_VALUE = "defaultValue";
    public static final String ELEMENT_DATA = "data";
    public static final String ELEMENT_NULL_VALUE = "nullValue";
    public static final String ELEMENT_PREVIEW = "preview";
    public static final String ELEMENT_FIELD_VALUE = "value";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_MINIMUM_RECORDS = "minRecords";
    public static final String ATTRIBUTE_MAXIMUM_RECORDS = "maxRecords";
    public static final String ATTRIBUTE_REORDERABLE = "reorderable";
    public static final String ATTRIBUTE_UNRESIZABLE = "unresizable";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String ATTRIBUTE_DESCRIPTION = "description";
    public static final String ATTRIBUTE_NULLABLE = "nullable";
    public static final String ATTRIBUTE_OPTIONAL = "optional";
    public static final String ATTRIBUTE_ICON = "icon";
    public static final String ATTRIBUTE_EXTENDABLE_SELECTION_VALUES = "extendableSelectionValues";
    public static final String ATTRIBUTE_READONLY = "readonly";
    public static final String ATTRIBUTE_NOT_REPLICATED = "notReplicated";
    public static final String ATTRIBUTE_HIDDEN = "hidden";
    public static final String ATTRIBUTE_INLINE = "inline";
    public static final String ATTRIBUTE_ADVANCED = "advanced";
    public static final String ATTRIBUTE_KEY_FIELD = "keyfield";
    public static final String ATTRIBUTE_EDITOR = "editor";
    public static final String ELEMENT_EDITOR_OPTIONS = "editorOptions";
    public static final String ELEMENT_VALIDATORS = "validators";
    public static final Pattern RESOURCE_PATTERN = Pattern.compile("\\$R\\{[\\w_]*\\}");
    public static final String ATTRIBUTE_EDITOR_OPTIONS = "editorOptions";
    private static final ClassicEncodingSettings ENCODE_VALIDATORS_SETTINGS = new ClassicEncodingSettings(false);

    public static void encodeToXML(DataTable dt, CallerController cc, ContextManager cm, XMLEncodingSettings settings, Writer writer) throws ParserConfigurationException, IOException, ContextException, DOMException {
        Document doc = XMLEncodingHelper.encodeToDocument(dt, cc, cm, settings);
        DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)doc.getImplementation());
        LSOutput lsOutput = domImplLS.createLSOutput();
        lsOutput.setEncoding(StandardCharsets.UTF_8.name());
        lsOutput.setCharacterStream(writer);
        LSSerializer serializer = domImplLS.createLSSerializer();
        serializer.getDomConfig().setParameter("format-pretty-print", true);
        serializer.write(doc, lsOutput);
    }

    public static Document encodeToDocument(DataTable dt, CallerController cc, ContextManager cm, XMLEncodingSettings settings) throws ParserConfigurationException, IOException, ContextException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        doc.appendChild(XMLEncodingHelper.createDataTableNode(dt, doc, cc, cm, settings));
        return doc;
    }

    public static DataTable decodeFromXML(String from, String encoding, TableFormat givenFormat) throws IllegalArgumentException, IOException, SAXException, ParserConfigurationException {
        return XMLEncodingHelper.decodeFromXML(new ByteArrayInputStream(from.getBytes(encoding)), givenFormat);
    }

    public static DataTable decodeFromXML(InputStream from, TableFormat givenFormat) throws IllegalArgumentException, IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setCoalescing(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(from);
        return XMLEncodingHelper.decodeFromDocument(doc, givenFormat);
    }

    public static DataTable decodeFromDocument(Document doc, TableFormat givenFormat) throws IOException {
        Element root = doc.getDocumentElement();
        if (!root.getNodeName().equals(ELEMENT_DATA_TABLE)) {
            throw new IOException("Incorrect data table document format. It must have single instance of 'table' element.");
        }
        return XMLEncodingHelper.readDataTableFromNode(root, new XMLEncodingSettings(false, givenFormat, false, null));
    }

    private static FieldFormat readFieldFormatFromNode(Node fn) throws IOException {
        NamedNodeMap fAttrs = fn.getAttributes();
        String name = null;
        String type = null;
        for (int i = 0; i < fAttrs.getLength(); ++i) {
            if (fAttrs.item(i).getNodeName().equals(ATTRIBUTE_NAME)) {
                name = fAttrs.item(i).getNodeValue();
                continue;
            }
            if (!fAttrs.item(i).getNodeName().equals(ATTRIBUTE_TYPE)) continue;
            type = fAttrs.item(i).getNodeValue();
        }
        if (name == null || type == null) {
            throw new IOException("Incorrect data table document format. Field element should have 'name' attribute and 'type' attribute.");
        }
        FieldFormat ff = FieldFormat.create(name, type.charAt(0));
        String editorOptions = ff.getEditorOptions();
        for (int i = 0; i < fAttrs.getLength(); ++i) {
            String nodeName = fAttrs.item(i).getNodeName();
            String nodeValue = fAttrs.item(i).getNodeValue();
            if (nodeName.equals(ATTRIBUTE_DESCRIPTION)) {
                ff.setDescription(nodeValue);
                continue;
            }
            if (nodeName.equals(ATTRIBUTE_NULLABLE)) {
                ff.setNullable(Boolean.parseBoolean(nodeValue));
                continue;
            }
            if (nodeName.equals(ATTRIBUTE_OPTIONAL)) {
                ff.setOptional(Boolean.parseBoolean(nodeValue));
                continue;
            }
            if (nodeName.equals(ATTRIBUTE_ICON)) {
                ff.setIcon(nodeValue);
                continue;
            }
            if (nodeName.equals(ATTRIBUTE_EXTENDABLE_SELECTION_VALUES)) {
                ff.setExtendableSelectionValues(Boolean.parseBoolean(nodeValue));
                continue;
            }
            if (nodeName.equals(ATTRIBUTE_READONLY)) {
                ff.setReadonly(Boolean.parseBoolean(nodeValue));
                continue;
            }
            if (nodeName.equals(ATTRIBUTE_NOT_REPLICATED)) {
                ff.setNotReplicated(Boolean.parseBoolean(nodeValue));
                continue;
            }
            if (nodeName.equals(ATTRIBUTE_HIDDEN)) {
                ff.setHidden(Boolean.parseBoolean(nodeValue));
                continue;
            }
            if (nodeName.equals(ATTRIBUTE_INLINE)) {
                ff.setInlineData(Boolean.parseBoolean(nodeValue));
                continue;
            }
            if (nodeName.equals(ATTRIBUTE_ADVANCED)) {
                ff.setAdvanced(Boolean.parseBoolean(nodeValue));
                continue;
            }
            if (nodeName.equals(ATTRIBUTE_KEY_FIELD)) {
                ff.setKeyField(Boolean.parseBoolean(nodeValue));
                continue;
            }
            if (nodeName.equals(ATTRIBUTE_EDITOR)) {
                ff.setEditor(nodeValue);
                continue;
            }
            if (!nodeName.equals("editorOptions")) continue;
            editorOptions = nodeValue;
        }
        NodeList fnc = fn.getChildNodes();
        for (int i = 0; i < fnc.getLength(); ++i) {
            Node item = fnc.item(i);
            if (item.getNodeName().equals(ELEMENT_DEFAULT_VALUE)) {
                Object defaultVal = XMLEncodingHelper.decodeFieldValueFromXML(ff, item, null);
                XMLEncodingHelper.setDefaultValueIfPossible(defaultVal, ff);
                continue;
            }
            if (item.getNodeName().equals(ELEMENT_SELECTION_VALUES)) {
                HashMap<Object, String> selVals = new HashMap<Object, String>();
                NodeList sVals = item.getChildNodes();
                for (int j = 0; j < sVals.getLength(); ++j) {
                    if (!ELEMENT_OPTION.equals(sVals.item(j).getNodeName())) continue;
                    NamedNodeMap attrs = sVals.item(j).getAttributes();
                    String description = null;
                    for (int k = 0; k < sVals.getLength(); ++k) {
                        Node attrItem = attrs.item(k);
                        if (!ATTRIBUTE_DESCRIPTION.equals(attrItem.getNodeName())) continue;
                        description = attrItem.getNodeValue();
                        break;
                    }
                    if (description == null) {
                        throw new IOException("Incorrect selection values format. Each 'option' ' element should have 'description' attribute.");
                    }
                    selVals.put(XMLEncodingHelper.decodeFieldValueFromXML(ff, sVals.item(j), null), description);
                }
                ff.setSelectionValues(selVals);
                continue;
            }
            if (ELEMENT_HELP.equals(item.getNodeName())) {
                ff.setHelp(item.getTextContent());
                continue;
            }
            if (ELEMENT_GROUP.equals(item.getNodeName())) {
                ff.setGroup(item.getTextContent());
                continue;
            }
            if ("editorOptions".equals(item.getNodeName()) && editorOptions == null) {
                editorOptions = XMLEncodingHelper.getElementContentWithUnsafetyText(item, null, false);
                continue;
            }
            if (!ELEMENT_VALIDATORS.equals(item.getNodeName())) continue;
            String vals = XMLEncodingHelper.getElementContentWithUnsafetyText(item, null, false);
            try {
                ff.createValidators(vals, new ClassicEncodingSettings(ExpressionUtils.useVisibleSeparators(vals)));
                continue;
            }
            catch (SyntaxErrorException syntaxErrorException) {
                // empty catch block
            }
        }
        ff.setEditorOptions(editorOptions);
        return ff;
    }

    private static void setDefaultValueIfPossible(Object defaultValue, FieldFormat ff) {
        if (ff.isNullable() || !ff.getNotNullDefault().equals(defaultValue)) {
            if (defaultValue == null) {
                List<FieldValidator> validators = ff.getValidators();
                for (FieldValidator validator : validators) {
                    if (validator.getType() == null || !validator.getType().equals(Character.valueOf('N'))) continue;
                    return;
                }
            }
            ff.setDefault(defaultValue);
        }
    }

    private static void setElementContentWithUnsafetyText(Element el, byte[] content) {
        el.setAttribute(CONTENT_TYPE, CONTENT_TYPE_BASE64);
        el.setTextContent(Base64.getEncoder().encodeToString(content));
    }

    public static void setElementContentWithUnsafetyText(Element el, String content) {
        boolean valid = true;
        for (int i = 0; i < content.length(); ++i) {
            if (XMLChar.isValid((int)content.charAt(i))) continue;
            valid = false;
            break;
        }
        if (valid) {
            el.setTextContent(content);
        } else {
            el.setAttribute(CONTENT_TYPE, CONTENT_TYPE_BASE64);
            el.setTextContent(Base64.getEncoder().encodeToString(content.getBytes(StringUtils.UTF8_CHARSET)));
        }
    }

    private static byte[] getBinaryElementContentWithUnsafetyText(Node el) {
        String cType;
        if (el == null) {
            return null;
        }
        if (el.getAttributes().getNamedItem(CONTENT_TYPE) != null && (cType = el.getAttributes().getNamedItem(CONTENT_TYPE).getTextContent()) != null && cType.equals(CONTENT_TYPE_BASE64)) {
            return Base64.getDecoder().decode(XMLEncodingHelper.getOwnTextContent(el));
        }
        return el.getTextContent().getBytes();
    }

    private static String getOwnTextContent(Node node) {
        Node clone = node.cloneNode(true);
        NodeList children = clone.getChildNodes();
        LinkedList<Node> toRemove = new LinkedList<Node>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 3) continue;
            toRemove.add(child);
        }
        for (Node removed : toRemove) {
            clone.removeChild(removed);
        }
        return clone.getTextContent();
    }

    public static String getElementContentWithUnsafetyText(Node el, ResourceBundle bundle, boolean transferEncode) {
        String cType;
        if (el == null) {
            return null;
        }
        String value = null;
        if (el.getAttributes().getNamedItem(CONTENT_TYPE) != null && (cType = el.getAttributes().getNamedItem(CONTENT_TYPE).getTextContent()) != null && cType.equals(CONTENT_TYPE_BASE64)) {
            value = new String(Base64.getDecoder().decode(el.getTextContent()), StringUtils.UTF8_CHARSET);
        }
        if (value == null) {
            value = el.getTextContent();
        }
        if (bundle != null) {
            value = XMLEncodingHelper.parseBundles(value, bundle, transferEncode);
        }
        return value;
    }

    public static String parseBundles(String value, ResourceBundle bundle, boolean transferEncode) {
        Matcher matcher = RESOURCE_PATTERN.matcher(value);
        while (matcher.find()) {
            try {
                String resourceName = matcher.group().substring(3, matcher.group().length() - 1);
                String resourceString = bundle.getString(resourceName);
                String replacement = transferEncode ? TransferEncodingHelper.encode(resourceString) : resourceString;
                replacement = replacement.replace("\\", "\\\\").replace("$", "\\$");
                value = matcher.replaceFirst(replacement);
                matcher.reset(value);
            }
            catch (Exception ex) {
                Log.WIDGETS.error((Object)("Error processing string constant for i18n: " + value), (Throwable)ex);
            }
        }
        return value;
    }

    private static void encodeFieldValueToXML(FieldFormat ff, Object value, Document doc, Element targetNode, CallerController cc, ContextManager cm, XMLEncodingSettings settings) throws IOException, ParserConfigurationException, ContextException {
        if (value == null) {
            Element nve = doc.createElement(ELEMENT_NULL_VALUE);
            targetNode.appendChild(nve);
            return;
        }
        switch (ff.getType()) {
            case 'T': {
                settings.setFieldFormat(ff);
                targetNode.appendChild(XMLEncodingHelper.createDataTableNode((DataTable)value, doc, cc, cm, settings));
                return;
            }
            case 'A': {
                byte[] bts;
                Element dataNode = doc.createElement(ELEMENT_DATA);
                Data iData = (Data)value;
                if (iData.getName() != null) {
                    dataNode.setAttribute(ATTRIBUTE_NAME, iData.getName());
                }
                if ((bts = iData.getData()) == null && cm != null) {
                    bts = iData.fetchData(cm, cc);
                }
                if (bts != null) {
                    Element data = doc.createElement(ELEMENT_DATA);
                    XMLEncodingHelper.setElementContentWithUnsafetyText(data, bts);
                    dataNode.appendChild(data);
                } else {
                    dataNode.appendChild(doc.createElement(ELEMENT_NULL_VALUE));
                }
                targetNode.appendChild(dataNode);
                bts = iData.getPreview();
                if (bts != null) {
                    Element prev = doc.createElement(ELEMENT_PREVIEW);
                    XMLEncodingHelper.setElementContentWithUnsafetyText(prev, bts);
                    dataNode.appendChild(prev);
                }
                if (iData.getId() != null) {
                    dataNode.setAttribute(ATTRIBUTE_ID, iData.getId().toString());
                }
                return;
            }
        }
        XMLEncodingHelper.setElementContentWithUnsafetyText(targetNode, ff.valueToString(value));
    }

    private static Object decodeFieldValueFromXML(FieldFormat ff, Node valueNode, ResourceBundle bundle) throws IOException {
        Node nve = XMLEncodingHelper.getNamedNodeChild(valueNode, ELEMENT_NULL_VALUE);
        if (nve != null) {
            return null;
        }
        switch (ff.getType()) {
            case 'T': {
                Node dtNode = XMLEncodingHelper.getNamedNodeChild(valueNode, ELEMENT_DATA_TABLE);
                if (dtNode == null) {
                    throw new IOException("Incorrect field value node. It has data table type and must have single instance of 'table' element.");
                }
                return XMLEncodingHelper.readDataTableFromNode(dtNode, new XMLEncodingSettings(false, null, true, ff, bundle));
            }
            case 'A': {
                Node data;
                Node dataNode = XMLEncodingHelper.getNamedNodeChild(valueNode, ELEMENT_DATA);
                if (dataNode == null) {
                    throw new IOException("Incorrect field value node. It has data type and must have single instance of 'data' element.");
                }
                Data d = new Data();
                NamedNodeMap attrs = dataNode.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String attrName = attrs.item(i).getNodeName();
                    String attrVal = attrs.item(i).getNodeValue();
                    if (attrName.equals(ATTRIBUTE_NAME)) {
                        d.setName(attrVal);
                        continue;
                    }
                    if (!attrName.equals(ATTRIBUTE_ID)) continue;
                    d.setId(Long.parseLong(attrVal));
                }
                Node prev = XMLEncodingHelper.getNamedNodeChild(dataNode, ELEMENT_PREVIEW);
                if (prev != null) {
                    d.setPreview(XMLEncodingHelper.getBinaryElementContentWithUnsafetyText(prev));
                }
                if ((data = XMLEncodingHelper.getNamedNodeChild(dataNode, ELEMENT_DATA)) == null || XMLEncodingHelper.getNamedNodeChild(data, ELEMENT_NULL_VALUE) != null) {
                    d.setData(null);
                } else {
                    d.setData(XMLEncodingHelper.getBinaryElementContentWithUnsafetyText(data));
                }
                return d;
            }
        }
        return ff.valueFromString(XMLEncodingHelper.getElementContentWithUnsafetyText(valueNode, bundle, false));
    }

    public static Node createDataTableNode(DataTable dt, Document doc, CallerController cc, ContextManager cm, XMLEncodingSettings settings) throws ParserConfigurationException, IOException, ContextException {
        TableFormat rf;
        if (!dt.isSimple()) {
            dt = dt.clone();
        }
        Element dtNode = doc.createElement(ELEMENT_DATA_TABLE);
        if (dt.getId() != null) {
            dtNode.setAttribute(ATTRIBUTE_ID, dt.getId().toString());
        }
        if ((rf = dt.getFormat()) != null) {
            if (settings.isEncodeFormat() || settings.isGetFormatFromDefaultValue() && settings.getFieldFormat() != null && settings.getFieldFormat().getDefaultValue() == null) {
                String validators;
                Element format = doc.createElement(ELEMENT_FORMAT);
                if (rf.getMinRecords() != 0) {
                    format.setAttribute(ATTRIBUTE_MINIMUM_RECORDS, Integer.toString(rf.getMinRecords()));
                }
                if (rf.getMinRecords() != Integer.MAX_VALUE) {
                    format.setAttribute(ATTRIBUTE_MAXIMUM_RECORDS, Integer.toString(rf.getMaxRecords()));
                }
                if (rf.isReorderable()) {
                    format.setAttribute(ATTRIBUTE_REORDERABLE, Boolean.toString(rf.isReorderable()));
                }
                if (rf.isUnresizable()) {
                    format.setAttribute(ATTRIBUTE_UNRESIZABLE, Boolean.toString(rf.isUnresizable()));
                }
                if (rf.getFields().size() > 0) {
                    Element fields = doc.createElement(ELEMENT_FIELDS);
                    for (FieldFormat ff : rf.getFields()) {
                        Map sv;
                        String vals;
                        Element field = doc.createElement(ELEMENT_FIELD);
                        field.setAttribute(ATTRIBUTE_NAME, ff.getName());
                        field.setAttribute(ATTRIBUTE_TYPE, String.valueOf(ff.getType()));
                        if (ff.hasDescription()) {
                            field.setAttribute(ATTRIBUTE_DESCRIPTION, ff.getDescription());
                        }
                        if (ff.isNullable()) {
                            field.setAttribute(ATTRIBUTE_NULLABLE, Boolean.toString(ff.isNullable()));
                        }
                        if (ff.isOptional()) {
                            field.setAttribute(ATTRIBUTE_OPTIONAL, Boolean.toString(ff.isOptional()));
                        }
                        if (ff.getIcon() != null) {
                            field.setAttribute(ATTRIBUTE_ICON, ff.getIcon());
                        }
                        if (ff.isExtendableSelectionValues()) {
                            field.setAttribute(ATTRIBUTE_EXTENDABLE_SELECTION_VALUES, Boolean.toString(ff.isExtendableSelectionValues()));
                        }
                        if (ff.isReadonly()) {
                            field.setAttribute(ATTRIBUTE_READONLY, Boolean.toString(ff.isReadonly()));
                        }
                        if (ff.isNotReplicated()) {
                            field.setAttribute(ATTRIBUTE_NOT_REPLICATED, Boolean.toString(ff.isNotReplicated()));
                        }
                        if (ff.isHidden()) {
                            field.setAttribute(ATTRIBUTE_HIDDEN, Boolean.toString(ff.isHidden()));
                        }
                        if (ff.isInlineData()) {
                            field.setAttribute(ATTRIBUTE_INLINE, Boolean.toString(ff.isInlineData()));
                        }
                        if (ff.isAdvanced()) {
                            field.setAttribute(ATTRIBUTE_ADVANCED, Boolean.toString(ff.isAdvanced()));
                        }
                        if (ff.isKeyField()) {
                            field.setAttribute(ATTRIBUTE_KEY_FIELD, Boolean.toString(ff.isKeyField()));
                        }
                        if (ff.getEditor() != null) {
                            field.setAttribute(ATTRIBUTE_EDITOR, ff.getEditor());
                        }
                        if (ff.getEditorOptions() != null) {
                            Element eo = doc.createElement("editorOptions");
                            XMLEncodingHelper.setElementContentWithUnsafetyText(eo, ff.getEditorOptions());
                            field.appendChild(eo);
                        }
                        if ((vals = ff.getEncodedValidators(ENCODE_VALIDATORS_SETTINGS)) != null) {
                            Element valsNode = doc.createElement(ELEMENT_VALIDATORS);
                            XMLEncodingHelper.setElementContentWithUnsafetyText(valsNode, vals);
                            field.appendChild(valsNode);
                        }
                        if ((sv = ff.getSelectionValues()) != null && sv.size() > 0) {
                            Element selVals = doc.createElement(ELEMENT_SELECTION_VALUES);
                            for (Object key : sv.keySet()) {
                                Element val = doc.createElement(ELEMENT_OPTION);
                                val.setAttribute(ATTRIBUTE_DESCRIPTION, sv.get(key));
                                XMLEncodingHelper.encodeFieldValueToXML(ff, key, doc, val, cc, cm, settings);
                                selVals.appendChild(val);
                            }
                            field.appendChild(selVals);
                        }
                        if (ff.getHelp() != null) {
                            Element help = doc.createElement(ELEMENT_HELP);
                            help.setTextContent(ff.getHelp());
                            field.appendChild(help);
                        }
                        if (ff.getGroup() != null) {
                            Element group = doc.createElement(ELEMENT_GROUP);
                            group.setTextContent(ff.getGroup());
                            field.appendChild(group);
                        }
                        Element dv = doc.createElement(ELEMENT_DEFAULT_VALUE);
                        if (ff.getType() == 'T' && ff.getDefaultValue() != null && !AbstractDataTable.DEFAULT_FORMAT.equals(((DataTable)ff.getDefaultValue()).getFormat())) {
                            XMLEncodingHelper.encodeFieldValueToXML(ff, ff.getDefaultValue(), doc, dv, cc, cm, new XMLEncodingSettings(true, settings.getFormat(), settings.isGetFormatFromDefaultValue(), settings.getFieldFormat()));
                        } else {
                            XMLEncodingHelper.encodeFieldValueToXML(ff, ff.getDefaultValue(), doc, dv, cc, cm, settings);
                        }
                        field.appendChild(dv);
                        fields.appendChild(field);
                    }
                    format.appendChild(fields);
                }
                if (!rf.getBindings().isEmpty()) {
                    Element bindings = XMLEncodingHelper.createAndAppendChild(format, ELEMENT_BINDINGS);
                    for (Binding b : rf.getBindings()) {
                        Element binding = XMLEncodingHelper.createAndAppendChild(bindings, ELEMENT_BINDING);
                        Element reference = XMLEncodingHelper.createAndAppendChild(binding, ELEMENT_REFERENCE);
                        XMLEncodingHelper.setElementContentWithUnsafetyText(reference, b.getTarget().toString());
                        Element expression = XMLEncodingHelper.createAndAppendChild(binding, ELEMENT_EXPRESSION);
                        XMLEncodingHelper.setElementContentWithUnsafetyText(expression, b.getExpression().toString());
                    }
                }
                if (!StringUtils.isEmpty(validators = rf.getEncodedTableValidators(ENCODE_VALIDATORS_SETTINGS))) {
                    Element validatorsNode = XMLEncodingHelper.createAndAppendChild(format, ELEMENT_VALIDATORS);
                    XMLEncodingHelper.setElementContentWithUnsafetyText(validatorsNode, validators);
                }
                dtNode.appendChild(format);
            }
            if (dt.getRecordCount() > 0) {
                Element recs = doc.createElement(ELEMENT_RECORDS);
                for (DataRecord dr : dt) {
                    Element rec = doc.createElement(ELEMENT_RECORD);
                    for (FieldFormat ff : rf.getFields()) {
                        Object fValue = dr.getValue(ff.getName());
                        if (ff.getDefaultValue() == null && fValue == null && !settings.isAllFields() || !settings.isAllFields() && ff.getDefaultValue() != null && ff.getDefaultValue().equals(fValue)) continue;
                        Element field = doc.createElement(ELEMENT_FIELD_VALUE);
                        field.setAttribute(ATTRIBUTE_NAME, ff.getName());
                        if (ff.getType() == 'T' && (ff.getDefaultValue() == null || AbstractDataTable.DEFAULT_FORMAT.equals(((DataTable)ff.getDefaultValue()).getFormat()))) {
                            XMLEncodingSettings newSettings = new XMLEncodingSettings(true, settings.getFormat(), settings.isGetFormatFromDefaultValue(), settings.getFieldFormat(), settings.getBundle());
                            XMLEncodingHelper.encodeFieldValueToXML(ff, fValue, doc, field, cc, cm, newSettings);
                        } else {
                            XMLEncodingHelper.encodeFieldValueToXML(ff, fValue, doc, field, cc, cm, settings);
                        }
                        rec.appendChild(field);
                    }
                    recs.appendChild(rec);
                }
                dtNode.appendChild(recs);
            }
        }
        return dtNode;
    }

    private static Element createAndAppendChild(Element parentElement, String elementName) {
        Element reference = parentElement.getOwnerDocument().createElement(elementName);
        parentElement.appendChild(reference);
        return reference;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DataTable readDataTableFromNode(Node dtNode, XMLEncodingSettings settings) throws IOException {
        TableFormat rf;
        NodeList children = dtNode.getChildNodes();
        Node format = null;
        Node records = null;
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeName().equals(ELEMENT_FORMAT)) {
                format = children.item(i);
                continue;
            }
            if (!children.item(i).getNodeName().equals(ELEMENT_RECORDS)) continue;
            records = children.item(i);
        }
        if (format == null) {
            if (settings.getFormat() == null) {
                if (!settings.isGetFormatFromDefaultValue() || settings.getFieldFormat() == null || settings.getFieldFormat().getDefaultValue() == null) throw new IOException("Cannot obtain format for this DataTable");
                rf = ((DataTable)settings.getFieldFormat().getDefaultValue()).getFormat();
            } else {
                rf = settings.getFormat();
            }
        } else {
            Node fields;
            Node validators;
            rf = new TableFormat();
            NamedNodeMap formatAttr = format.getAttributes();
            for (int i = 0; i < formatAttr.getLength(); ++i) {
                Node attr = formatAttr.item(i);
                if (attr.getNodeName().equals(ATTRIBUTE_MINIMUM_RECORDS)) {
                    rf.setMinRecords(Integer.valueOf(attr.getNodeValue()));
                    continue;
                }
                if (attr.getNodeName().equals(ATTRIBUTE_MAXIMUM_RECORDS)) {
                    rf.setMaxRecords(Integer.valueOf(attr.getNodeValue()));
                    continue;
                }
                if (attr.getNodeName().equals(ATTRIBUTE_REORDERABLE)) {
                    rf.setReorderable(Boolean.valueOf(attr.getNodeValue()));
                    continue;
                }
                if (!attr.getNodeName().equals(ATTRIBUTE_UNRESIZABLE)) continue;
                rf.setUnresizable(Boolean.valueOf(attr.getNodeValue()));
            }
            Node bindings = XMLEncodingHelper.getNamedNodeChild(format, ELEMENT_BINDINGS);
            if (bindings != null) {
                NodeList bindingNodes = ((Element)bindings).getElementsByTagName(ELEMENT_BINDING);
                for (int i = 0; i < bindingNodes.getLength(); ++i) {
                    Element bindingElement = (Element)bindingNodes.item(i);
                    Node referenceNode = XMLEncodingHelper.getNamedNodeChild(bindingElement, ELEMENT_REFERENCE);
                    Node expressionNode = XMLEncodingHelper.getNamedNodeChild(bindingElement, ELEMENT_EXPRESSION);
                    rf.addBinding(referenceNode.getTextContent(), expressionNode.getTextContent());
                }
            }
            if ((validators = XMLEncodingHelper.getNamedNodeChild(format, ELEMENT_VALIDATORS)) != null) {
                String vals = XMLEncodingHelper.getElementContentWithUnsafetyText(validators, null, false);
                try {
                    rf.createTableValidators(vals, new ClassicEncodingSettings(ExpressionUtils.useVisibleSeparators(vals)));
                }
                catch (SyntaxErrorException bindingElement) {
                    // empty catch block
                }
            }
            if ((fields = XMLEncodingHelper.getNamedNodeChild(format, ELEMENT_FIELDS)) != null) {
                NodeList fs = fields.getChildNodes();
                for (int i = 0; i < fs.getLength(); ++i) {
                    if (!fs.item(i).getNodeName().equals(ELEMENT_FIELD)) continue;
                    rf.addField(XMLEncodingHelper.readFieldFormatFromNode(fs.item(i)));
                }
            }
        }
        SimpleDataTable dt = new SimpleDataTable(rf);
        Node id = dtNode.getAttributes().getNamedItem(ATTRIBUTE_ID);
        if (id != null) {
            dt.setId(Long.valueOf(id.getNodeValue()));
        }
        if (records == null) return dt;
        NodeList recs = records.getChildNodes();
        for (int i = 0; i < recs.getLength(); ++i) {
            if (!recs.item(i).getNodeName().equals(ELEMENT_RECORD)) continue;
            DataRecord dr = dt.addRecord();
            NodeList rFieldValues = recs.item(i).getChildNodes();
            for (int j = 0; j < rFieldValues.getLength(); ++j) {
                FieldFormat cff;
                Node fName;
                Node f = rFieldValues.item(j);
                if (!f.getNodeName().equals(ELEMENT_FIELD_VALUE) || (fName = f.getAttributes().getNamedItem(ATTRIBUTE_NAME)) == null || (cff = rf.getField(fName.getTextContent())) == null) continue;
                dr.setValue(cff.getName(), XMLEncodingHelper.decodeFieldValueFromXML(cff, f, settings.getBundle()));
            }
        }
        return dt;
    }

    private static Node getNamedNodeChild(Node node, String child) {
        NodeList children = node.getChildNodes();
        Node childNode = null;
        for (int i = 0; i < children.getLength(); ++i) {
            if (!children.item(i).getNodeName().equals(child)) continue;
            childNode = children.item(i);
            break;
        }
        return childNode;
    }

    public static Document createNewDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.newDocument();
    }

    public static Object evaluateXPathExpression(Document doc, String expression, QName resultType) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        XPathExpression expr = xpath.compile(expression);
        return expr.evaluate(doc, resultType);
    }
}

