/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.encoding;

import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.protocol.ProtocolCommandBuilder;
import com.tibbo.aggregate.common.util.StringWrapper;
import java.util.HashMap;
import java.util.Map;

public class TransferEncodingHelper {
    public static final char ESCAPE_CHAR = '%';
    public static final char SEPARATOR_CHAR = '/';
    public static final char START_CHAR = '^';
    public static final char END_CHAR = '$';
    public static final int KILO = 1024;
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    public static final int GB = 0x40000000;
    public static final long TB = 0x10000000000L;
    public static final int LARGE_DATA_SIZE = 0x3200000;
    private static final Map<Character, Character> DIRECT = new HashMap<Character, Character>();
    private static final Map<Character, Character> REVERSE = new HashMap<Character, Character>();
    private static final Map<Character, Character> REVERSE_VISIBLE = new HashMap<Character, Character>();

    public static void encodeChar(char c, StringBuilder sb) {
        TransferEncodingHelper.encodeChar(DIRECT, c, sb, 0);
    }

    private static void encodeChar(Map<Character, Character> mapping, char c, StringBuilder sb, Integer encodeLevel) {
        if (mapping.containsKey(Character.valueOf(c))) {
            double recalcedEncode = c == '%' ? Math.pow(2.0, encodeLevel.intValue()) - 1.0 : Math.pow(2.0, encodeLevel - 1);
            int i = 0;
            while ((double)i < recalcedEncode) {
                sb.append('%');
                ++i;
            }
            sb.append(mapping.get(Character.valueOf(c)));
        } else {
            sb.append(c);
        }
    }

    public static String encode(String strVal) {
        return TransferEncodingHelper.encode(strVal, DIRECT, (Integer)1);
    }

    public static String encode(String strVal, Integer encodeLevel) {
        return TransferEncodingHelper.encode(strVal, DIRECT, encodeLevel);
    }

    public static StringBuilder encode(String strFrom, StringBuilder strTo, Integer encodeLevel) {
        return TransferEncodingHelper.encode(strFrom, strTo, DIRECT, encodeLevel);
    }

    public static String decode(String s, ClassicEncodingSettings settings) {
        return TransferEncodingHelper.decode(s, settings != null && settings.isUseVisibleSeparators() ? REVERSE_VISIBLE : REVERSE);
    }

    public static String decode(StringWrapper s) {
        return TransferEncodingHelper.decode(s != null ? s.getString() : null, REVERSE);
    }

    private static String encode(String s, Map<Character, Character> mapping, Integer encodeLevel) {
        if (s == null) {
            return null;
        }
        return new String(TransferEncodingHelper.encode(s, null, mapping, encodeLevel));
    }

    private static StringBuilder encode(String source, StringBuilder result, Map<Character, Character> mapping, Integer encodeLevel) {
        if (source == null) {
            return null;
        }
        if (result == null) {
            result = new StringBuilder();
        }
        for (int i = 0; i < source.length(); ++i) {
            TransferEncodingHelper.encodeChar(mapping, source.charAt(i), result, encodeLevel);
        }
        return result;
    }

    private static String decode(String s, Map<Character, Character> mapping) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        StringBuilder out = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '%' && i < len - 1) {
                char next = s.charAt(i + 1);
                Character orig = mapping.get(Character.valueOf(next));
                if (orig != null) {
                    out.append(orig.charValue());
                    ++i;
                    continue;
                }
                out.append(c);
                out.append(next);
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    static {
        DIRECT.put(Character.valueOf('%'), Character.valueOf('%'));
        DIRECT.put(Character.valueOf(ProtocolCommandBuilder.CLIENT_COMMAND_SEPARATOR.charAt(0)), Character.valueOf('/'));
        DIRECT.put(Character.valueOf('\u001c'), Character.valueOf('<'));
        DIRECT.put(Character.valueOf('\u001d'), Character.valueOf('>'));
        DIRECT.put(Character.valueOf('\u001e'), Character.valueOf('='));
        DIRECT.put(Character.valueOf('\u0002'), Character.valueOf('^'));
        DIRECT.put(Character.valueOf('\r'), Character.valueOf('$'));
        REVERSE.put(Character.valueOf('%'), Character.valueOf('%'));
        REVERSE.put(Character.valueOf('/'), Character.valueOf(ProtocolCommandBuilder.CLIENT_COMMAND_SEPARATOR.charAt(0)));
        REVERSE.put(Character.valueOf('<'), Character.valueOf('\u001c'));
        REVERSE.put(Character.valueOf('>'), Character.valueOf('\u001d'));
        REVERSE.put(Character.valueOf('='), Character.valueOf('\u001e'));
        REVERSE.put(Character.valueOf('^'), Character.valueOf('\u0002'));
        REVERSE.put(Character.valueOf('$'), Character.valueOf('\r'));
        REVERSE_VISIBLE.put(Character.valueOf('%'), Character.valueOf('%'));
        REVERSE_VISIBLE.put(Character.valueOf('/'), Character.valueOf('/'));
        REVERSE_VISIBLE.put(Character.valueOf('<'), Character.valueOf('<'));
        REVERSE_VISIBLE.put(Character.valueOf('>'), Character.valueOf('>'));
        REVERSE_VISIBLE.put(Character.valueOf('='), Character.valueOf('='));
        REVERSE_VISIBLE.put(Character.valueOf('^'), Character.valueOf('^'));
        REVERSE_VISIBLE.put(Character.valueOf('$'), Character.valueOf('$'));
    }
}

