/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.encoding;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.DefaultContextManager;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.encoding.AbstractFormatCache;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.protocol.AbstractAggreGateDeviceController;
import com.tibbo.aggregate.common.server.CommonServerFormats;

public class RemoteFormatCache
extends AbstractFormatCache {
    private final AbstractAggreGateDeviceController controller;

    public RemoteFormatCache(AbstractAggreGateDeviceController controller, String name) {
        super(name);
        this.controller = controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableFormat get(int id) {
        TableFormat result = super.get(id);
        if (result != null) {
            return result;
        }
        if (this.controller == null) {
            throw new IllegalStateException("Format requesting is not available since controller is null");
        }
        try {
            DataTable output;
            ContextManager cm;
            Context rootContext;
            if (Log.PROTOCOL_CACHING.isDebugEnabled()) {
                Log.PROTOCOL_CACHING.debug((Object)("Requesting remote format #" + id));
            }
            Context context = rootContext = (cm = this.controller.getContextManager()) != null ? (Context)((DefaultContextManager)cm).get("", ((DefaultContextManager)cm).getCallerController()) : null;
            if (rootContext != null && rootContext.getFunctionDefinition("getFormat") != null) {
                output = rootContext.callFunction("getFormat", id);
            } else {
                DataTable input = new DataRecord(CommonServerFormats.FIFT_GET_FORMAT, id).wrap();
                output = this.controller.callRemoteFunction("", "getFormat", CommonServerFormats.FOFT_GET_FORMAT, input, null);
            }
            String formatData = output.rec().getString("data");
            result = new TableFormat(formatData, new ClassicEncodingSettings(false));
            if (Log.PROTOCOL_CACHING.isDebugEnabled()) {
                Log.PROTOCOL_CACHING.debug((Object)("Received explicitly requested remote format #" + id + ": " + result));
            }
            this.cacheLock.writeLock().lock();
            try {
                this.addImpl(result, id);
            }
            finally {
                this.cacheLock.writeLock().unlock();
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error obtaining format #" + id, ex);
        }
        return result;
    }

    @Override
    protected Integer add(TableFormat tableFormat) {
        throw new UnsupportedOperationException("Cannot add format: '" + tableFormat + "' without defined index to the remote cache");
    }
}

