/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.encoding;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class KnownFormatCollector {
    private final Map<Integer, Boolean> formatIds;

    public KnownFormatCollector() {
        this.formatIds = new ConcurrentHashMap<Integer, Boolean>();
    }

    public KnownFormatCollector(Map<Integer, Boolean> formatIds) {
        this.formatIds = new ConcurrentHashMap<Integer, Boolean>(formatIds);
    }

    public Map<Integer, Boolean> getFormatIds() {
        return new HashMap<Integer, Boolean>(this.formatIds);
    }

    public boolean isKnown(int formatId) {
        return this.formatIds.containsKey(formatId);
    }

    public boolean isMarked(int formatId) {
        Boolean marked = this.formatIds.get(formatId);
        return marked != null ? marked : false;
    }

    public void makeKnown(int formatId, boolean mark) {
        this.formatIds.put(formatId, mark);
    }

    public void markAll() {
        LinkedHashSet<Integer> idsToMark = new LinkedHashSet<Integer>();
        for (Map.Entry<Integer, Boolean> entry : this.formatIds.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            idsToMark.add(entry.getKey());
        }
        if (idsToMark.size() == 0) {
            return;
        }
        for (Integer id : idsToMark) {
            this.formatIds.put(id, true);
        }
    }
}

