/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.encoding;

import com.tibbo.aggregate.common.data.Data;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.encoding.FieldFormatDefiner;
import com.tibbo.aggregate.common.datatable.field.DataTableFieldFormat;
import com.tibbo.aggregate.common.datatable.field.DateFieldFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.text.translate.AggregateTranslator;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.commons.lang3.text.translate.LookupTranslator;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class JsonEncodingHelper {
    private static final String WRAPPER_FIELD = "wrapper";
    public static final String VALUE_FIELD = "value";

    public static String tableToJson(DataTable payload) {
        return JsonEncodingHelper.tableToJson(payload, false);
    }

    public static String tableToJson(DataTable payload, boolean convertLongToString) {
        return JsonEncodingHelper.encodeToJson(payload, convertLongToString).toString();
    }

    private static JSONArray encodeToJson(DataTable payload, boolean convertLongToString) {
        JSONArray records = new JSONArray();
        if (payload == null) {
            return records;
        }
        for (DataRecord dr : payload) {
            JSONObject record = new JSONObject();
            for (int i = 0; i < dr.getFieldCount(); ++i) {
                record.put((Object)dr.getFormat(i).getName(), JsonEncodingHelper.encodeFieldValueToJSON(dr.getFormat(i), dr.getValue(i), convertLongToString));
            }
            records.add((Object)record);
        }
        return records;
    }

    private static Object encodeFieldValueToJSON(FieldFormat ff, Object value, boolean convertLongToString) {
        switch (ff.getType()) {
            case 'T': {
                return JsonEncodingHelper.encodeToJson((DataTable)value, convertLongToString);
            }
            case 'C': 
            case 'D': {
                return ff.valueToString(value);
            }
            case 'L': {
                return convertLongToString ? ff.valueToString(value) : value;
            }
            case 'A': {
                Data data = (Data)value;
                return data != null ? data.toJsonString() : "";
            }
            case 'S': {
                return value;
            }
        }
        return value;
    }

    public static DataTable tableFromJson(String payload, boolean convertUnequalFieldTypesToString) throws Exception {
        String jsonText = "{\"wrapper\":" + payload + "}";
        JSONParser parser = new JSONParser();
        JSONObject json = (JSONObject)parser.parse(jsonText);
        return JsonEncodingHelper.processJSONObject(json, convertUnequalFieldTypesToString);
    }

    private static DataTable processJSONObject(JSONObject jsonObject, boolean convertUnequalFieldTypesToString) {
        TableFormat tableFormat = JsonEncodingHelper.calculateTableFormat(jsonObject, convertUnequalFieldTypesToString, true, false);
        SimpleDataTable result = new SimpleDataTable(tableFormat);
        JsonEncodingHelper.fillDataTableWithObject(jsonObject, result, true);
        return result;
    }

    public static TableFormat calculateTableFormat(JSONObject jsonObject, boolean convertUnequalFieldTypesToString, boolean innerDataTable, boolean implicitCasting) {
        HashSet<FieldFormat> defaultFieldFormats = new HashSet<FieldFormat>();
        return JsonEncodingHelper.calculateTableFormat(jsonObject, convertUnequalFieldTypesToString, innerDataTable, implicitCasting, defaultFieldFormats);
    }

    public static TableFormat calculateTableFormat(JSONObject jsonObject, boolean convertUnequalFieldTypesToString, boolean innerDataTable, boolean implicitCasting, Collection<FieldFormat> defaultFieldFormats) {
        TableFormat result = new TableFormat(1, 1);
        for (Object keyObject : jsonObject.keySet()) {
            FieldFormat fieldFormat = JsonEncodingHelper.extractFieldFormatFromNode((String)keyObject, jsonObject.get(keyObject), convertUnequalFieldTypesToString, innerDataTable, implicitCasting, defaultFieldFormats);
            result.addField(fieldFormat);
        }
        return result;
    }

    public static void fillDataTableWithObject(JSONObject jsonObject, DataTable dataTable, boolean innerDataTable) {
        DataRecord dataRecord = dataTable.addRecord();
        for (Object keyObject : jsonObject.keySet()) {
            DataTable table;
            String key = (String)keyObject;
            Object value = jsonObject.get((Object)key);
            if (value instanceof JSONObject && dataRecord.getFormat(key) instanceof DataTableFieldFormat) {
                table = dataRecord.getDataTable(key);
                JsonEncodingHelper.fillDataTableWithObject((JSONObject)value, table, innerDataTable);
                dataRecord.setValue(key, (Object)table);
                continue;
            }
            if (value instanceof JSONArray && dataRecord.getFormat(key) instanceof DataTableFieldFormat) {
                table = dataRecord.getDataTable(key);
                JsonEncodingHelper.fillDataTableWithArray((JSONArray)value, table, innerDataTable);
                dataRecord.setValue(key, (Object)table);
                continue;
            }
            if (value instanceof String) {
                Date date = JsonEncodingHelper.getDateIfDateFormat(value);
                if (date != null) {
                    dataRecord.setValue(key, (Object)date);
                    continue;
                }
                dataRecord.setValue(key, value);
                continue;
            }
            dataRecord.setValue(key, value);
        }
    }

    public static void fillDataTableWithArray(JSONArray jsonArray, DataTable dataTable, boolean innerDataTable) {
        for (Object arrayObject : jsonArray) {
            DataRecord dataRecord;
            if (!innerDataTable || dataTable.getFormat(VALUE_FIELD) instanceof DataTableFieldFormat) {
                DataTable table = dataTable;
                if (innerDataTable) {
                    DataRecord dataRecord2 = dataTable.addRecord();
                    table = dataRecord2.getDataTable(VALUE_FIELD);
                    dataRecord2.setValue(VALUE_FIELD, (Object)table);
                }
                if (arrayObject instanceof JSONObject) {
                    JsonEncodingHelper.fillDataTableWithObject((JSONObject)arrayObject, table, innerDataTable);
                    continue;
                }
                if (arrayObject instanceof JSONArray) {
                    JsonEncodingHelper.fillDataTableWithArray((JSONArray)arrayObject, table, innerDataTable);
                    continue;
                }
            }
            if (!(dataRecord = dataTable.addRecord()).hasField(VALUE_FIELD)) continue;
            dataRecord.setValue(VALUE_FIELD, arrayObject);
        }
    }

    private static FieldFormat extractFieldFormatFromNode(String key, Object node, boolean convertUnequalFieldTypesToString, boolean innerDataTable, boolean implicitCasting, Collection<FieldFormat> defaultFieldFormats) {
        FieldFormat result = null;
        if (node instanceof String) {
            Date date = JsonEncodingHelper.getDateIfDateFormat(node);
            result = date != null ? FieldFormat.create(key, 'D') : FieldFormat.create(key, 'S', true);
        } else if (node instanceof Long) {
            result = FieldFormat.create(key, 'L');
        } else if (node instanceof Boolean) {
            result = FieldFormat.create(key, 'B');
        } else if (node instanceof Double) {
            result = FieldFormat.create(key, 'E');
        } else if (node instanceof JSONArray) {
            result = FieldFormat.create(key, 'T');
            JSONArray jSONArray = (JSONArray)node;
            LinkedList<FieldFormat> results = new LinkedList<FieldFormat>();
            for (int i = 0; i < jSONArray.size(); ++i) {
                results.add(JsonEncodingHelper.extractFieldFormatFromNode(VALUE_FIELD, jSONArray.get(i), convertUnequalFieldTypesToString, innerDataTable, implicitCasting, defaultFieldFormats));
            }
            FieldFormat innerField = JsonEncodingHelper.mergeFormats(results, VALUE_FIELD, convertUnequalFieldTypesToString, implicitCasting, defaultFieldFormats);
            TableFormat innerFormat = new TableFormat(innerField);
            SimpleDataTable innerTable = new SimpleDataTable(innerFormat);
            if (innerDataTable) {
                result.setDefault(innerTable);
            } else {
                result.setDefault(innerField.getDefaultValue());
            }
        } else if (node instanceof JSONObject) {
            result = FieldFormat.create(key, 'T');
            TableFormat innerFormat = JsonEncodingHelper.calculateTableFormat((JSONObject)node, convertUnequalFieldTypesToString, innerDataTable, implicitCasting, defaultFieldFormats);
            SimpleDataTable innerTable = new SimpleDataTable(innerFormat);
            result.setDefault(innerTable);
        } else {
            result = JsonEncodingHelper.createDefaultStringFieldFormat(key, defaultFieldFormats);
        }
        result.setNullable(true);
        return result;
    }

    private static Date getDateIfDateFormat(Object node) {
        try {
            return DateFieldFormat.dateFromString(node.toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    static FieldFormat createDefaultStringFieldFormat(String fieldName, Collection<FieldFormat> defaultFieldFormats) {
        FieldFormat<Object> ff = FieldFormat.create(fieldName, 'S').setNullable(true).setDefault(null);
        defaultFieldFormats.add(ff);
        return ff;
    }

    static FieldFormat createDefaultDataTableFieldFormat(String fieldName, Collection<FieldFormat> defaultFieldFormats) {
        FieldFormat ff = FieldFormat.create(fieldName, 'T');
        defaultFieldFormats.add(ff);
        return ff;
    }

    private static FieldFormat mergeFormats(LinkedList<FieldFormat> formats, String fieldName, Boolean convertUnequalFieldTypesToString, boolean implicitCasting, Collection<FieldFormat> defaultFieldFormats) {
        FieldFormat format2;
        if (formats.isEmpty()) {
            return JsonEncodingHelper.createDefaultDataTableFieldFormat(fieldName, defaultFieldFormats);
        }
        if (formats.stream().anyMatch(f -> !(f.getDefaultValue() instanceof DataTable))) {
            return JsonEncodingHelper.chooseFormat(formats, convertUnequalFieldTypesToString, fieldName, defaultFieldFormats);
        }
        FieldFormatDefiner fieldFormatDefiner = new FieldFormatDefiner(convertUnequalFieldTypesToString, implicitCasting, defaultFieldFormats);
        HashMap fieldsMergeMap = new HashMap();
        for (FieldFormat format2 : formats) {
            Object def = format2.getDefaultValue();
            if (!(def instanceof DataTable)) continue;
            TableFormat tableFormat = ((DataTable)def).getFormat();
            for (FieldFormat ff : tableFormat.getFields()) {
                String key = ff.getName();
                if (ff instanceof DataTableFieldFormat) {
                    if (!fieldsMergeMap.containsKey(key)) {
                        fieldsMergeMap.put(key, new LinkedList());
                    }
                    List mergeList = (List)fieldsMergeMap.get(key);
                    mergeList.add(ff);
                    continue;
                }
                fieldFormatDefiner.put(key, ff);
            }
        }
        for (Object key : fieldsMergeMap.keySet()) {
            fieldFormatDefiner.put((String)key, JsonEncodingHelper.mergeFormats((LinkedList)fieldsMergeMap.get(key), (String)key, convertUnequalFieldTypesToString, implicitCasting, defaultFieldFormats));
        }
        TableFormat mergedFormat = new TableFormat();
        for (String key : fieldFormatDefiner.getFieldNames()) {
            mergedFormat.addField(fieldFormatDefiner.get(key));
        }
        format2 = FieldFormat.create(fieldName, 'T');
        format2.setDefault(new SimpleDataTable(mergedFormat));
        format2.setNullable(true);
        return format2;
    }

    private static FieldFormat chooseFormat(List<FieldFormat> fieldFormats, Boolean convertUnequalFieldTypesToString, String fieldName, Collection<FieldFormat> defaultFieldFormat) {
        if (convertUnequalFieldTypesToString.booleanValue() && !JsonEncodingHelper.isEqualFieldTypes(fieldFormats).booleanValue()) {
            FieldFormat ff = FieldFormat.create(fieldName, 'S');
            ff.setNullable(true);
            return ff;
        }
        for (FieldFormat ff : fieldFormats) {
            if (JsonEncodingHelper.isDefaultFieldFormat(ff, defaultFieldFormat)) continue;
            return ff;
        }
        return fieldFormats.get(0);
    }

    private static Boolean isEqualFieldTypes(List<FieldFormat> fieldFormats) {
        char type = fieldFormats.get(0).getType();
        for (FieldFormat ff : fieldFormats) {
            if (ff.getType() == type) continue;
            return false;
        }
        return true;
    }

    static boolean isDefaultFieldFormat(FieldFormat ff, Collection<FieldFormat> defaultFieldFormats) {
        return defaultFieldFormats.contains(ff);
    }

    public static class EscapeJsonWithoutUnicode {
        private static final CharSequenceTranslator ESCAPE_JSON_WITHOUT_UNICODE = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])new String[][]{{"\"", "\\\""}, {"\\", "\\\\"}}), new LookupTranslator((CharSequence[][])EntityArrays.JAVA_CTRL_CHARS_ESCAPE())});

        public static String translate(String input) {
            return ESCAPE_JSON_WITHOUT_UNICODE.translate((CharSequence)input);
        }
    }
}

