/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.encoding;

import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.encoding.JsonEncodingHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

class FieldFormatDefiner {
    private final boolean convertDifferentTypesToString;
    private final boolean implicitCasting;
    private final Collection<FieldFormat> defaultFieldFormats;
    private Map<String, LinkedHashSet<FieldFormat>> fieldFormatsByName = new HashMap<String, LinkedHashSet<FieldFormat>>();

    FieldFormatDefiner(boolean convertDifferentTypesToString, boolean implicitCasting, Collection<FieldFormat> defaultFieldFormats) {
        this.convertDifferentTypesToString = convertDifferentTypesToString;
        this.implicitCasting = implicitCasting;
        this.defaultFieldFormats = defaultFieldFormats;
    }

    void put(String fieldName, FieldFormat ff) {
        FieldFormat currentFieldFormat;
        LinkedHashSet fieldFormats = this.fieldFormatsByName.computeIfAbsent(fieldName, k -> new LinkedHashSet());
        if (fieldFormats.size() > 0 && JsonEncodingHelper.isDefaultFieldFormat(ff, this.defaultFieldFormats)) {
            return;
        }
        if (fieldFormats.size() == 1 && JsonEncodingHelper.isDefaultFieldFormat(currentFieldFormat = (FieldFormat)fieldFormats.iterator().next(), this.defaultFieldFormats)) {
            fieldFormats.clear();
        }
        fieldFormats.add(ff);
    }

    Set<String> getFieldNames() {
        return this.fieldFormatsByName.keySet();
    }

    FieldFormat get(String fieldName) {
        LinkedHashSet<FieldFormat> fieldFormats = this.fieldFormatsByName.get(fieldName);
        if (fieldFormats == null || fieldFormats.isEmpty()) {
            return JsonEncodingHelper.createDefaultStringFieldFormat(fieldName, this.defaultFieldFormats);
        }
        int numFieldFormats = fieldFormats.size();
        if (numFieldFormats == 1) {
            return (FieldFormat)fieldFormats.iterator().next();
        }
        if (this.implicitCasting && this.isAllNumberFormats(fieldFormats)) {
            return this.chooseNumberFormat(fieldFormats);
        }
        if (!this.convertDifferentTypesToString) {
            return (FieldFormat)fieldFormats.iterator().next();
        }
        return JsonEncodingHelper.createDefaultStringFieldFormat(fieldName, this.defaultFieldFormats);
    }

    private FieldFormat chooseNumberFormat(LinkedHashSet<FieldFormat> fieldFormats) {
        FieldFormat result = (FieldFormat)fieldFormats.iterator().next();
        for (FieldFormat ff : fieldFormats) {
            if (ff.getType() == 'E') {
                result = ff;
                break;
            }
            if (ff.getType() == 'F' && result.getType() != 'E') {
                result = ff;
            }
            if (ff.getType() != 'L' || result.getType() != 'I') continue;
            result = ff;
        }
        return result;
    }

    private boolean isAllNumberFormats(LinkedHashSet<FieldFormat> fieldFormats) {
        for (FieldFormat ff : fieldFormats) {
            if (ff.getType() == 'I' || ff.getType() == 'L' || ff.getType() == 'F' || ff.getType() == 'E') continue;
            return false;
        }
        return true;
    }
}

