/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.encoding;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.encoding.FormatCache;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AbstractFormatCache
implements FormatCache {
    protected final Map<Integer, TableFormat> cache = new HashMap<Integer, TableFormat>(100, 0.75f);
    protected final Map<TableFormat, Integer> reverse = new HashMap<TableFormat, Integer>(100, 0.75f);
    protected final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final String name;

    public AbstractFormatCache(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.cache.size();
    }

    @Override
    public TableFormat get(int id) {
        TableFormat result;
        this.cacheLock.readLock().lock();
        try {
            result = this.cache.get(id);
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        return result;
    }

    protected TableFormat addImpl(TableFormat format, int id) {
        if (format.isImmutable()) {
            format.setId(id);
        }
        format.setFormatCacheIdentityHashCode(System.identityHashCode(this));
        TableFormat previous = this.cache.put(id, format);
        if (previous != null) {
            Integer previousId = this.reverse.get(previous);
            if (id != previousId) {
                this.cache.remove(previousId);
                this.reverse.remove(previous);
            } else {
                previous = null;
            }
        }
        this.reverse.put(format, id);
        return previous;
    }

    @Override
    public Integer addIfNotExists(TableFormat format) {
        Integer formatId = this.obtainId(format);
        if (formatId == null) {
            this.cacheLock.writeLock().lock();
            try {
                formatId = this.obtainId(format);
                if (formatId == null) {
                    formatId = this.add(format);
                }
            }
            finally {
                this.cacheLock.writeLock().unlock();
            }
        }
        return formatId;
    }

    protected abstract Integer add(TableFormat var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer obtainId(TableFormat format) {
        Integer idFromFormat;
        Integer idFromCache;
        this.cacheLock.readLock().lock();
        try {
            idFromCache = this.reverse.get(format);
            idFromFormat = format.getId();
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        if (Objects.equals(idFromFormat, idFromCache)) {
            return idFromFormat;
        }
        if (idFromFormat == null && idFromCache != null) {
            return idFromCache;
        }
        boolean attachedToAnotherCache = format.isAttachedToAnotherCache(this);
        if (attachedToAnotherCache) {
            return idFromFormat;
        }
        throw new IllegalStateException(String.format("The following table format must be stored in current cache (%s, identityHashCode=%d) with ID=%d but was not actually: %s", this.getClass().getSimpleName(), System.identityHashCode(this), idFromFormat, format));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableFormat getCachedVersion(TableFormat format) {
        if (format == null) {
            return null;
        }
        this.cacheLock.readLock().lock();
        try {
            Integer id = this.obtainId(format);
            TableFormat tableFormat = id != null && !format.isAttachedToAnotherCache(this) ? this.cache.get(id) : format;
            return tableFormat;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.cacheLock.writeLock().lock();
        try {
            this.cache.clear();
            this.reverse.clear();
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(int id, TableFormat format) {
        this.cacheLock.writeLock().lock();
        try {
            if (format == null) {
                throw new IllegalArgumentException("Format is NULL");
            }
            TableFormat tableFormat = this.addImpl(format, id);
            if (Log.PROTOCOL_CACHING.isDebugEnabled() && tableFormat != null) {
                Log.PROTOCOL_CACHING.debug((Object)("Cache '" + this.getName() + "' override format as #" + id + ": " + format));
            }
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }
}

