/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.converter.editor;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableException;
import com.tibbo.aggregate.common.datatable.DataTableUtils;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.converter.editor.AbstractEditorOptionsConverter;
import com.tibbo.aggregate.common.expression.EvaluationException;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.expression.Expression;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.expression.function.DefaultFunctions;
import com.tibbo.aggregate.common.util.SyntaxErrorException;

public class ReferenceConverter
extends AbstractEditorOptionsConverter {
    public static final String FIELD_APPEARANCE = "appearance";
    public static final String FIELD_REFERENCE_TYPE = "referenceType";
    public static final String FIELD_CONTEXT_TYPE = "contextType";
    public static final String FIELD_CONTEXT = "context";
    public static final String FIELD_CONTEXT_EXPRESSION = "contextExpression";
    public static final String FIELD_ENTITY_TYPE = "entityType";
    public static final String FIELD_ENTITY = "entity";
    public static final String FIELD_ENTITY_EXPRESSION = "entityExpression";
    public static final String FIELD_ENTITY_PARAMETERS = "entityParameters";
    public static final String FIELD_ICON = "icon";
    public static final String FIELD_ENTITY_PARAMETERS_VALUE = "value";
    public static final String STATIC = "static";
    public static final String DYNAMIC = "dynamic";
    public static final String FIELD_COLUMNS_NAME = "name";
    public static final String FIELD_COLUMNS_VISIBLE = "visible";
    public static final TableFormat VFT_ENTITY_PARAMETERS = new TableFormat(0, Integer.MAX_VALUE);
    public static final TableFormat FORMAT;

    public ReferenceConverter() {
        this.editors.add("reference");
        this.types.add(String.valueOf('S'));
    }

    @Override
    public String convertToString(DataTable options) {
        return options.encode();
    }

    public static Reference createReference(Object value, FieldFormat ff, ContextManager cm, CallerController cc) {
        return ReferenceConverter.createReference(value, ff, cm, cc, null);
    }

    public static Reference createReference(Object value, FieldFormat ff, ContextManager cm, CallerController cc, Context defaultContext) {
        boolean hasEditorOptions;
        boolean bl = hasEditorOptions = ff != null && ff.getEditorOptions() != null;
        if (!hasEditorOptions) {
            if (value != null) {
                return new Reference(value.toString());
            }
            return new Reference();
        }
        boolean isTable = DataTableUtils.isEncodedTable(ff.getEditorOptions());
        if (isTable) {
            try {
                return ReferenceConverter.toReference(new SimpleDataTable(ff.getEditorOptions()), cm, cc, defaultContext);
            }
            catch (DataTableException ex) {
                return null;
            }
        }
        return new Reference(ff.getEditorOptions());
    }

    public static Reference toReference(DataTable options, ContextManager cm, CallerController cc) {
        return ReferenceConverter.toReference(options, cm, cc, null);
    }

    public static Reference toReference(DataTable options, ContextManager cm, CallerController cc, Context defaultContext) {
        if (options == null) {
            return new Reference();
        }
        Reference ref = new Reference();
        for (DataRecord rec : options) {
            ref.setSchema("class");
            Evaluator evaluator = new Evaluator(cm, cc);
            evaluator.setDefaultContext(defaultContext);
            if (rec.getString(FIELD_CONTEXT_TYPE).equalsIgnoreCase(STATIC)) {
                ref.setContext(rec.getString(FIELD_CONTEXT));
            } else {
                ref.setContext(ReferenceConverter.evaluate(rec.getString(FIELD_CONTEXT_EXPRESSION), evaluator));
            }
            if (rec.getString(FIELD_ENTITY_TYPE).equalsIgnoreCase(STATIC)) {
                ref.setEntity(rec.getString(FIELD_ENTITY));
            } else {
                ref.setEntity(ReferenceConverter.evaluate(rec.getString(FIELD_ENTITY_EXPRESSION), evaluator));
            }
            ref.setEntityType(rec.getInt(FIELD_REFERENCE_TYPE));
            ref.setAppearance(rec.getInt(FIELD_APPEARANCE));
            if (rec.getDataTable(FIELD_ENTITY_PARAMETERS) != null) {
                for (DataRecord rec2 : rec.getDataTable(FIELD_ENTITY_PARAMETERS)) {
                    ref.addParameter(rec2.getString(FIELD_ENTITY_PARAMETERS_VALUE));
                }
            }
            if (rec.getString(FIELD_ICON) == null) continue;
            ref.setField(rec.getString(FIELD_ICON));
        }
        return ref;
    }

    private static String evaluate(String expression, Evaluator evaluator) {
        try {
            return (String)evaluator.evaluate(new Expression(expression));
        }
        catch (EvaluationException | SyntaxErrorException ex) {
            Log.DATATABLEEDITOR.debug((Object)ex.getMessage(), (Throwable)ex);
            return expression;
        }
    }

    @Override
    public TableFormat getFormat() {
        return FORMAT;
    }

    static {
        VFT_ENTITY_PARAMETERS.addField(FieldFormat.create(FIELD_ENTITY_PARAMETERS_VALUE, 'S', Cres.get().getString(FIELD_ENTITY_PARAMETERS_VALUE)));
        FORMAT = new TableFormat(1, 1);
        FieldFormat ff = FieldFormat.create(FIELD_APPEARANCE, 'I', Cres.get().getString(FIELD_APPEARANCE));
        ff.addSelectionValue(Reference.APPEARANCE_LINK, Cres.get().getString("link"));
        ff.addSelectionValue(Reference.APPEARANCE_BUTTON, Cres.get().getString("wButton"));
        ff.setDefault(Reference.APPEARANCE_LINK);
        FORMAT.addField(ff);
        ff = FieldFormat.create("<referenceType><I><A=8><D=" + Cres.get().getString(FIELD_REFERENCE_TYPE) + ">");
        ff.addSelectionValue(1, Cres.get().getString("variable"));
        ff.addSelectionValue(2, Cres.get().getString("function"));
        ff.addSelectionValue(4, Cres.get().getString("event"));
        ff.addSelectionValue(8, Cres.get().getString("action"));
        ff.setDefault(1);
        FORMAT.addField(ff);
        ff = FieldFormat.create("<contextType><S><D=" + Cres.get().getString(FIELD_CONTEXT_TYPE) + ">");
        ff.addSelectionValue(STATIC, Cres.get().getString(STATIC));
        ff.addSelectionValue(DYNAMIC, Cres.get().getString(DYNAMIC));
        ff.setDefault(STATIC);
        FORMAT.addField(ff);
        FORMAT.addField(FieldFormat.create("<context><S><D=" + Cres.get().getString(FIELD_CONTEXT) + ">").setEditor(FIELD_CONTEXT));
        FORMAT.addField(FieldFormat.create("<contextExpression><S><D=" + Cres.get().getString(FIELD_CONTEXT_EXPRESSION) + ">").setEditor("expression"));
        ff = FieldFormat.create("<entityType><S><D=" + Cres.get().getString(FIELD_ENTITY_TYPE) + ">");
        ff.addSelectionValue(STATIC, Cres.get().getString(STATIC));
        ff.addSelectionValue(DYNAMIC, Cres.get().getString(DYNAMIC));
        ff.setDefault(STATIC);
        FORMAT.addField(ff);
        FORMAT.addField(FieldFormat.create("<entity><S><D=" + Cres.get().getString(FIELD_ENTITY) + ">"));
        FORMAT.addField(FieldFormat.create("<entityExpression><S><D=" + Cres.get().getString(FIELD_ENTITY_EXPRESSION) + ">").setEditor("expression"));
        FORMAT.addField(FieldFormat.create(FIELD_ENTITY_PARAMETERS, 'T', Cres.get().getString(FIELD_ENTITY_PARAMETERS)).setDefault(new SimpleDataTable(VFT_ENTITY_PARAMETERS)));
        FORMAT.addField(FieldFormat.create("<icon><S><F=N><D=" + Cres.get().getString(FIELD_ICON) + ">"));
        FORMAT.addBinding("context#hidden", "{contextType} == 'dynamic'");
        FORMAT.addBinding("contextExpression#hidden", "{contextType} == 'static'");
        FORMAT.addBinding("entity#hidden", "{entityType} == 'dynamic'");
        FORMAT.addBinding("entityExpression#hidden", "{entityType} == 'static'");
        String contextTypeExpression = "({contextType} == 'static' ? {context} : {contextExpression})";
        contextTypeExpression = "{contextType} == 'static' ? {context} : evaluate({contextExpression})";
        String ref = "entity#choices";
        String exp1 = "{referenceType} == 1 ? " + (Object)((Object)DefaultFunctions.CALL_FUNCTION) + "('" + "utilities" + "','" + "variablesByMask" + "'," + contextTypeExpression + "):";
        String exp2 = "({referenceType} == 4 ? " + (Object)((Object)DefaultFunctions.CALL_FUNCTION) + "('" + "utilities" + "','" + "eventsByMask" + "'," + contextTypeExpression + "):";
        String exp3 = "({referenceType} == 8 ? " + (Object)((Object)DefaultFunctions.CALL_FUNCTION) + "('" + "utilities" + "','" + "actionsByMask" + "'," + contextTypeExpression + ",true):";
        String exp4 = "({referenceType} == 2 ? " + (Object)((Object)DefaultFunctions.CALL_FUNCTION) + "('" + "utilities" + "','" + "functionsByMask" + "'," + contextTypeExpression + "):";
        String exp5 = (Object)((Object)DefaultFunctions.CALL_FUNCTION) + "('" + "utilities" + "','" + "variablesByMask" + "'," + contextTypeExpression + "))))";
        StringBuilder sb = new StringBuilder();
        sb.append(exp1).append(exp2).append(exp3).append(exp4).append(exp5);
        FORMAT.addBinding(ref, sb.toString());
    }
}

