/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.converter.editor;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.converter.editor.AbstractEditorOptionsConverter;
import com.tibbo.aggregate.common.datatable.field.StringFieldFormat;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.expression.function.DefaultFunctions;

public class InstanceConverter
extends AbstractEditorOptionsConverter {
    public static final String FIELD_STORAGE_CONTEXT = "storageContext";
    public static final String FIELD_STORAGE_TABLE = "storageTable";
    public static final String FIELD_DASHBOARD = "dashboard";
    public static final String FIELD_ICON = "icon";
    public static final TableFormat FORMAT = new TableFormat(1, 1);
    public static final TableFormat TF_PARAMETERS;

    public InstanceConverter() {
        this.editors.add("instance");
        this.types.add(String.valueOf('I'));
        this.types.add(String.valueOf('F'));
        this.types.add(String.valueOf('E'));
        this.types.add(String.valueOf('L'));
        this.types.add(String.valueOf('S'));
    }

    @Override
    public String convertToString(DataTable options) {
        return options.encode();
    }

    public static Reference toReference(DataTable options) {
        Reference ref = new Reference();
        if (options != null) {
            for (DataRecord rec : options) {
                ref.setSchema("class");
                ref.setContext(rec.getString(FIELD_STORAGE_CONTEXT));
                ref.setEntity(rec.getString(FIELD_STORAGE_TABLE));
                ref.setEntityType(100);
            }
        }
        return ref;
    }

    @Override
    public TableFormat getFormat() {
        return FORMAT;
    }

    static {
        FORMAT.addField(FieldFormat.create("<storageContext><S><F=N><D=" + Cres.get().getString(FIELD_STORAGE_CONTEXT) + ">").setEditor("context"));
        FORMAT.addField(FieldFormat.create("<storageTable><S><F=N><D=" + Cres.get().getString("acClassTable") + ">"));
        FORMAT.addField(FieldFormat.create("<dashboard><S><F=N><D=" + Cres.get().getString(FIELD_DASHBOARD) + ">").setEditor("context").setEditorOptions(StringFieldFormat.encodeMaskEditorOptions(FIELD_DASHBOARD, "dashboards")));
        FORMAT.addField(FieldFormat.create("<icon><S><F=N><D=" + Cres.get().getString(FIELD_ICON) + ">"));
        String ref = "storageTable#choices";
        String tableExp = (Object)((Object)DefaultFunctions.CALL_FUNCTION) + "('\" + {" + FIELD_STORAGE_CONTEXT + "} + \"', '" + "storageTables" + "')";
        String valueExp = "{value}";
        String descriptionExp = "{description}";
        String exp = "({storageContext} != null && length({storageContext}) > 0) ? " + (Object)((Object)DefaultFunctions.CALL_FUNCTION) + "(\"" + "utilities" + "\", \"" + "selectionValues" + "\", \"" + tableExp + "\",  \"" + valueExp + "\",  \"" + descriptionExp + "\") : null";
        FORMAT.addBinding(ref, exp);
        TF_PARAMETERS = new TableFormat(1, 1);
        TF_PARAMETERS.addField(FieldFormat.create("<instance_id><S><F=N>"));
    }
}

