/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.converter.editor;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.converter.editor.AbstractEditorOptionsConverter;
import com.tibbo.aggregate.common.datatable.converter.editor.AggregateConstraintType;
import com.tibbo.aggregate.common.datatable.field.StringFieldFormat;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.expression.function.DefaultFunctions;

public class ForeignInstanceConverter
extends AbstractEditorOptionsConverter {
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_REFERENCE = "reference";
    public static final String FIELD_ICON = "icon";
    public static final String FIELD_STORAGE_CONTEXT = "storageContext";
    public static final String FIELD_STORAGE_VIEW = "storageView";
    public static final String FIELD_STORAGE_QUERY = "storageQuery";
    public static final String FIELD_STORAGE_TABLE = "storageTable";
    public static final String FIELD_STORAGE_DELETE_CONSTRAINT_TYPE = "deleteConstraintType";
    public static final String FIELD_STORAGE_UPDATE_CONSTRAINT_TYPE = "updateConstraintType";
    public static final String FIELD_REFERENCE_FIELD = "referenceField";
    public static final String FIELD_STORAGE_COLUMNS = "storageColumns";
    public static final String FIELD_STORAGE_FILTER = "storageFilter";
    public static final String FIELD_STORAGE_SORTING = "storageSorting";
    public static final String FIELD_DASHBOARD = "dashboard";
    public static final TableFormat FORMAT = new TableFormat(1, 1);
    public static final TableFormat TF_PARAMETERS;

    public ForeignInstanceConverter() {
        this.editors.add("foreignInstance");
        this.types.add(String.valueOf('L'));
        this.types.add(String.valueOf('S'));
    }

    @Override
    public String convertToString(DataTable options) {
        return options.encode();
    }

    public static Reference toReference(DataTable options) {
        if (options == null) {
            return new Reference();
        }
        Reference ref = new Reference();
        for (DataRecord rec : options) {
            ref.setSchema("class");
            ref.setContext(rec.getString(FIELD_STORAGE_CONTEXT));
            ref.setEntity(rec.getString(FIELD_STORAGE_TABLE));
            ref.setEntityType(100);
        }
        return ref;
    }

    @Override
    public TableFormat getFormat() {
        return FORMAT;
    }

    static {
        FORMAT.addField(FieldFormat.create("<storageContext><S><F=N><D=" + Cres.get().getString(FIELD_STORAGE_CONTEXT) + ">").setEditor("context"));
        FORMAT.addField(FieldFormat.create("<storageView><S><D=" + Cres.get().getString("view") + ">"));
        FORMAT.addField(FieldFormat.create("<storageTable><S><F=N><D=" + Cres.get().getString("acClassTable") + ">"));
        FORMAT.addField(FieldFormat.create("<deleteConstraintType><S><F=N><D=" + Cres.get().getString("acDeleteConstraintRule") + ">").setSelectionValues(AggregateConstraintType.class).setDefault(AggregateConstraintType.NO_ACTION));
        FORMAT.addField(FieldFormat.create("<updateConstraintType><S><F=N><D=" + Cres.get().getString("acUpdateConstraintRule") + ">").setSelectionValues(AggregateConstraintType.class).setDefault(AggregateConstraintType.NO_ACTION));
        FORMAT.addField(FieldFormat.create("<referenceField><S><F=AN><D=" + Cres.get().getString("acReferenceField") + ">"));
        FORMAT.addField(FieldFormat.create("<storageColumns><T><D=" + Cres.get().getString("columns") + ">"));
        FORMAT.addField(FieldFormat.create("<storageFilter><T><D=" + Cres.get().getString("filter") + ">"));
        FORMAT.addField(FieldFormat.create("<storageSorting><T><D=" + Cres.get().getString("sorting") + ">"));
        FORMAT.addField(FieldFormat.create("<dashboard><S><F=N><D=" + Cres.get().getString(FIELD_DASHBOARD) + ">").setEditor("context").setEditorOptions(StringFieldFormat.encodeMaskEditorOptions(FIELD_DASHBOARD, "dashboards")));
        FORMAT.addField(FieldFormat.create("<icon><S><F=N><D=" + Cres.get().getString(FIELD_ICON) + ">"));
        String ref = "storageView#choices";
        String tableExp = (Object)((Object)DefaultFunctions.CALL_FUNCTION) + "('\" + {" + FIELD_STORAGE_CONTEXT + "} + \"', '" + "storageViews" + "')";
        String valueExp = "{value}";
        String descriptionExp = "{description}";
        String exp = "({storageContext} != null && length({storageContext}) > 0) ? " + (Object)((Object)DefaultFunctions.CALL_FUNCTION) + "(\"" + "utilities" + "\", \"" + "selectionValues" + "\", \"" + tableExp + "\",  \"" + valueExp + "\",  \"" + descriptionExp + "\") : null";
        FORMAT.addBinding(ref, exp);
        ref = "storageTable#choices";
        tableExp = (Object)((Object)DefaultFunctions.CALL_FUNCTION) + "('\" + {" + FIELD_STORAGE_CONTEXT + "} + \"', '" + "storageTables" + "')";
        valueExp = "{value}";
        descriptionExp = "{description}";
        exp = "({storageContext} != null && length({storageContext}) > 0) ? " + (Object)((Object)DefaultFunctions.CALL_FUNCTION) + "(\"" + "utilities" + "\", \"" + "selectionValues" + "\", \"" + tableExp + "\",  \"" + valueExp + "\",  \"" + descriptionExp + "\") : null";
        FORMAT.addBinding(ref, exp);
        ref = "storageColumns#enabled";
        exp = " {storageContext} != null && length({storageContext}) > 0 && ({storageView} == null || " + (Object)((Object)DefaultFunctions.LENGTH) + "({" + FIELD_STORAGE_VIEW + "}) == 0) && " + (Object)((Object)DefaultFunctions.FUNCTION_AVAILABLE) + "({" + FIELD_STORAGE_CONTEXT + "}, '" + FIELD_STORAGE_COLUMNS + "')";
        FORMAT.addBinding(ref, exp);
        ref = FIELD_STORAGE_COLUMNS;
        exp = "({storageContext} != null && length({storageContext}) > 0 && {storageTable} != null) ? " + (Object)((Object)DefaultFunctions.CALL_FUNCTION) + "({" + FIELD_STORAGE_CONTEXT + "}, '" + FIELD_STORAGE_COLUMNS + "', {" + FIELD_STORAGE_TABLE + "}, {" + FIELD_STORAGE_COLUMNS + "}) : table()";
        FORMAT.addBinding(ref, exp);
        ref = "storageFilter#enabled";
        exp = "{storageContext} != null && length({storageContext}) > 0 && ({storageView} == null || " + (Object)((Object)DefaultFunctions.LENGTH) + "({" + FIELD_STORAGE_VIEW + "}) == 0) && " + (Object)((Object)DefaultFunctions.FUNCTION_AVAILABLE) + "({" + FIELD_STORAGE_CONTEXT + "}, '" + FIELD_STORAGE_FILTER + "')";
        FORMAT.addBinding(ref, exp);
        ref = FIELD_STORAGE_FILTER;
        exp = "({storageContext} != null && length({storageContext}) > 0 && {storageTable} != null) ? " + (Object)((Object)DefaultFunctions.CALL_FUNCTION) + "({" + FIELD_STORAGE_CONTEXT + "}, '" + FIELD_STORAGE_FILTER + "', {" + FIELD_STORAGE_TABLE + "}, {" + FIELD_STORAGE_FILTER + "}) : table()";
        FORMAT.addBinding(ref, exp);
        ref = "storageSorting#enabled";
        exp = "{storageContext} != null && length({storageContext}) > 0 && ({storageView} == null || " + (Object)((Object)DefaultFunctions.LENGTH) + "({" + FIELD_STORAGE_VIEW + "}) == 0) && " + (Object)((Object)DefaultFunctions.FUNCTION_AVAILABLE) + "({" + FIELD_STORAGE_CONTEXT + "}, '" + FIELD_STORAGE_COLUMNS + "')";
        FORMAT.addBinding(ref, exp);
        ref = FIELD_STORAGE_SORTING;
        exp = "({storageContext} != null && length({storageContext}) > 0 && {storageTable} != null) ? " + (Object)((Object)DefaultFunctions.CALL_FUNCTION) + "({" + FIELD_STORAGE_CONTEXT + "}, '" + FIELD_STORAGE_SORTING + "', {" + FIELD_STORAGE_TABLE + "}, {" + FIELD_STORAGE_SORTING + "}) : table()";
        FORMAT.addBinding(ref, exp);
        TF_PARAMETERS = new TableFormat(1, 1);
        TF_PARAMETERS.addField(FieldFormat.create("<instance_id><S><F=N>"));
        TF_PARAMETERS.addField(FieldFormat.create("<relationField><S><F=N>"));
    }
}

