/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.converter.editor;

import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.converter.editor.AbstractEditorOptionsConverter;
import com.tibbo.aggregate.common.datatable.field.StringFieldFormat;
import com.tibbo.aggregate.common.expression.Reference;
import java.util.LinkedHashMap;

public class ExpressionConverter
extends AbstractEditorOptionsConverter {
    public static final String FIELD_DEFAULT_CONTEXT = "context";
    public static final String FIELD_DEFAULT_TABLE = "table";
    public static final String FIELD_REFERENCES = "references";
    public static final String FIELD_ADDITIONAL_REFERENCES_DESCRIPTION = "description";
    public static final String FIELD_ADDITIONAL_REFERENCES_REFERENCE = "reference";
    public static TableFormat FORMAT = StringFieldFormat.EXPRESSION_BUILDER_OPTIONS_FORMAT;
    public static TableFormat REFERENCES_FORMAT = StringFieldFormat.ADDITIONAL_REFERENCES_FORMAT;

    public ExpressionConverter() {
        this.editors.add("expression");
        this.types.add(String.valueOf('S'));
    }

    @Override
    public String convertToString(DataTable options) {
        LinkedHashMap<Reference, String> additionalReferences = new LinkedHashMap<Reference, String>();
        String defaultContext = options.rec().getString(FIELD_DEFAULT_CONTEXT);
        DataTable defaultTable = options.rec().getDataTable(FIELD_DEFAULT_TABLE);
        DataTable references = options.rec().getDataTable(FIELD_REFERENCES);
        if (references != null) {
            for (DataRecord rec : references) {
                additionalReferences.put(new Reference(rec.getString(FIELD_ADDITIONAL_REFERENCES_REFERENCE)), rec.getString(FIELD_ADDITIONAL_REFERENCES_DESCRIPTION));
            }
        }
        return StringFieldFormat.encodeExpressionEditorOptions(defaultContext, defaultTable, additionalReferences);
    }

    @Override
    public TableFormat getFormat() {
        return FORMAT;
    }
}

