/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.converter.editor;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.ContextRuntimeException;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableBuilding;
import com.tibbo.aggregate.common.datatable.DataTableException;
import com.tibbo.aggregate.common.datatable.DataTableReplication;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.converter.editor.AbstractEditorOptionsConverter;
import com.tibbo.aggregate.common.datatable.converter.editor.ContextMaskConverter;
import com.tibbo.aggregate.common.datatable.converter.editor.DateRangeConverter;
import com.tibbo.aggregate.common.datatable.converter.editor.EditorOptionsConverter;
import com.tibbo.aggregate.common.datatable.converter.editor.ExpressionConverter;
import com.tibbo.aggregate.common.datatable.converter.editor.ForeignInstanceConverter;
import com.tibbo.aggregate.common.datatable.converter.editor.FormatValueConverter;
import com.tibbo.aggregate.common.datatable.converter.editor.InstanceConverter;
import com.tibbo.aggregate.common.datatable.converter.editor.ReferenceConverter;
import com.tibbo.aggregate.common.util.StringUtils;
import java.util.LinkedList;

public class EditorOptionsUtils {
    private static LinkedList<AbstractEditorOptionsConverter> CONVERTERS = new LinkedList();

    private static EditorOptionsConverter getConverter(String type, String editor) {
        for (EditorOptionsConverter editorOptionsConverter : CONVERTERS) {
            if (!editorOptionsConverter.isSupportingEditor(editor) || !editorOptionsConverter.isSupportingType(type)) continue;
            return editorOptionsConverter;
        }
        Log.CONVERTER.debug((Object)("Not found converter for editor: " + editor + " and type: " + type));
        return null;
    }

    public static String convertToString(DataRecord fdata) {
        Log.CONVERTER.debug((Object)("Starting convertToString, fdata: " + fdata));
        String type = fdata.getString("type");
        String editor = fdata.getString("editor");
        DataTable options = fdata.getDataTable("editorOptions");
        if (options == null) {
            return null;
        }
        if (options.getRecordCount() == 0) {
            return "";
        }
        EditorOptionsConverter converter = EditorOptionsUtils.getConverter(type, editor);
        if (converter != null) {
            return converter.convertToString(options);
        }
        if (options.rec().hasField("options")) {
            String eo = options.rec().getString("options");
            return StringUtils.isEmpty(eo) ? null : eo;
        }
        return null;
    }

    public static DataTable createEditorOptionsTable(String type, String editor, String editorOptions) {
        Log.CONVERTER.debug((Object)("Starting convertToDataTable, type: " + type + ", editor: " + editor));
        EditorOptionsConverter converter = EditorOptionsUtils.getConverter(type, editor);
        if (converter != null) {
            SimpleDataTable table = new SimpleDataTable(converter.getFormat());
            if (editorOptions != null) {
                try {
                    SimpleDataTable eot = new SimpleDataTable(editorOptions);
                    DataTableReplication.copy(eot, table);
                }
                catch (DataTableException ex) {
                    throw new ContextRuntimeException(ex.getMessage(), ex);
                }
            }
            return table;
        }
        return new SimpleDataTable(DataTableBuilding.EDITOR_OPTIONS_SIMPLE_FORMAT, editorOptions != null ? editorOptions : new String());
    }

    public static DataTable createEditorOptionsTable(String fieldType, String editor) {
        return EditorOptionsUtils.createEditorOptionsTable(fieldType, editor, null);
    }

    public static boolean hasConverter(String type, String editor) {
        return EditorOptionsUtils.getConverter(type, editor) != null;
    }

    static {
        CONVERTERS.add(new ExpressionConverter());
        CONVERTERS.add(new ReferenceConverter());
        CONVERTERS.add(new ContextMaskConverter());
        CONVERTERS.add(new InstanceConverter());
        CONVERTERS.add(new ForeignInstanceConverter());
        CONVERTERS.add(new FormatValueConverter());
        CONVERTERS.add(new DateRangeConverter());
    }
}

