/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.converter.editor;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.datatable.SelectionValue;
import java.sql.SQLException;

public enum AggregateConstraintType implements SelectionValue
{
    NO_ACTION(Cres.get().getString("constraintNoAction")),
    CASCADE(Cres.get().getString("constraintCascade")),
    NULL(Cres.get().getString("constraintNull")),
    DEFAULT(Cres.get().getString("constraintDefault")),
    RESTRICT(Cres.get().getString("constraintRestrict"));

    private final String descr;

    private AggregateConstraintType(String descr) {
        this.descr = descr;
    }

    public static AggregateConstraintType ofSqlRule(Integer rule) throws SQLException {
        switch (rule) {
            case 0: {
                return CASCADE;
            }
            case 1: {
                return RESTRICT;
            }
            case 2: {
                return NULL;
            }
            case 3: {
                return NO_ACTION;
            }
            case 4: {
                return DEFAULT;
            }
        }
        throw new SQLException("Unsupported constraint rule detected: " + rule);
    }

    @Override
    public String getValue() {
        return this.name();
    }

    @Override
    public String getDescription() {
        return this.descr;
    }
}

