/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.converter;

import com.tibbo.aggregate.common.datatable.DataTableConversion;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.converter.SimpleFormatConverter;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class SimplePropertyFormatConverter
extends SimpleFormatConverter<Object> {
    private final PropertyDescriptor propertyDescriptor;

    public SimplePropertyFormatConverter(Class valueClass, String field) {
        super(valueClass);
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(valueClass);
            for (PropertyDescriptor pd : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                if (!field.equals(pd.getName())) continue;
                this.propertyDescriptor = pd;
                return;
            }
            throw new IntrospectionException("Field '" + field + "' not found in class '" + valueClass.getSimpleName() + "'");
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public FieldFormat createFieldFormat(String name) {
        return DataTableConversion.createFieldFormat(name, this.propertyDescriptor.getPropertyType()).setNullable(true);
    }

    @Override
    public Object simpleToBean(Object value) {
        if (value == null) {
            return null;
        }
        try {
            if (this.propertyDescriptor.getWriteMethod() != null) {
                Object bean = this.getValueClass().newInstance();
                this.propertyDescriptor.getWriteMethod().invoke(bean, value);
                return bean;
            }
            Constructor constructor = this.getValueClass().getConstructor(this.propertyDescriptor.getPropertyType());
            return constructor.newInstance(value);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public Object convertToTable(Object value, TableFormat format) {
        if (value == null) {
            return null;
        }
        try {
            return this.propertyDescriptor.getReadMethod().invoke(value, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

