/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.converter;

import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableConversion;
import com.tibbo.aggregate.common.datatable.DataTableException;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.converter.AbstractFormatConverter;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public class DefaultFormatConverter<T>
extends AbstractFormatConverter<T> {
    private final Set<String> constructorArguments = new LinkedHashSet<String>();

    public DefaultFormatConverter(Class valueClass, TableFormat format) {
        super(valueClass, format);
    }

    @Override
    public T convertToBean(Object value, T originalValue) {
        try {
            DataRecord rec = ((DataTable)value).rec();
            if (rec.hasField("isNull") && rec.getBoolean("isNull").booleanValue()) {
                return null;
            }
            if (originalValue != null) {
                T bean = this.clone(originalValue, false);
                if (bean == null) {
                    bean = this.instantiate(rec);
                }
                DataTableConversion.populateBeanFromRecord(bean, rec, this.getFormat(), true, FIELDS_TO_SKIP);
                return bean;
            }
            if (this.constructorArguments.size() == 0) {
                return DataTableConversion.beanFromTable((DataTable)value, this.getValueClass(), this.getFormat(), true);
            }
            T bean = this.instantiate(rec);
            DataTableConversion.populateBeanFromRecord(bean, rec, this.getFormat(), true);
            return bean;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Object convertToTable(T value, TableFormat format) {
        try {
            if (value == null && format.hasField("isNull")) {
                SimpleDataTable dataTable = new SimpleDataTable(format, true);
                dataTable.rec().setValue("isNull", (Object)true);
                return dataTable;
            }
            return DataTableConversion.beanToRecord(value, this.getFormat(), true, false, new LinkedHashSet<String>(Arrays.asList("isNull"))).wrap();
        }
        catch (DataTableException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public FieldFormat createFieldFormat(String name) {
        return null;
    }

    public void addConstructorField(String field) {
        this.constructorArguments.add(field);
    }

    @Override
    public T instantiate(DataRecord source) throws InstantiationException {
        try {
            if (this.constructorArguments.size() == 0) {
                try {
                    Object bean = this.getValueClass().newInstance();
                    DataTableConversion.populateBeanFromRecord(bean, source, this.getFormat(), true);
                    return bean;
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }
            Class[] types = new Class[this.constructorArguments.size()];
            Object[] parameters = new Object[this.constructorArguments.size()];
            int i = 0;
            for (String s : this.constructorArguments) {
                Object fv = source.getValue(s);
                types[i] = fv.getClass();
                parameters[i] = fv;
                ++i;
            }
            Constructor c = this.getValueClass().getConstructor(types);
            Object bean = c.newInstance(parameters);
            DataTableConversion.populateBeanFromRecord(bean, source, this.getFormat(), true, this.constructorArguments);
            return bean;
        }
        catch (InstantiationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }
}

