/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.converter;

import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableException;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.converter.AbstractFormatConverter;
import com.tibbo.aggregate.common.datatable.converter.Choice;
import java.util.LinkedList;
import java.util.List;

public class ChoicesConverter
extends AbstractFormatConverter<Object> {
    private List<Choice> choices = new LinkedList<Choice>();
    private Choice defaultChoice;

    public ChoicesConverter(Class valueClass) {
        super(valueClass);
    }

    @Override
    public FieldFormat createFieldFormat(String name) {
        FieldFormat ff = FieldFormat.create(name, 'S');
        for (Choice c : this.choices) {
            ff.addSelectionValue(c.getName(), c.getDescription());
        }
        if (this.defaultChoice != null) {
            ff.setDefault(this.defaultChoice.getName());
        }
        return ff;
    }

    public FieldFormat createFieldFormat(String name, String description) {
        FieldFormat result = this.createFieldFormat(name);
        result.setDescription(description);
        return result;
    }

    public FieldFormat createFieldFormat(String name, String description, Object defaultValue) {
        FieldFormat result = this.createFieldFormat(name, description);
        result.setDefault(defaultValue);
        return result;
    }

    public void add(Choice c) {
        if (this.choices.size() == 0) {
            this.defaultChoice = c;
        }
        this.choices.add(c);
    }

    public void add(String description, Object object) {
        this.add(new Choice(description, object));
    }

    public void add(String name, String description, Object object) {
        this.add(new Choice(name, description, object));
    }

    public void setDefault(Choice defaultChoice) {
        this.defaultChoice = defaultChoice;
    }

    public void setDefault(String name) {
        for (Choice choice : this.choices) {
            if (!choice.getName().equals(name)) continue;
            this.defaultChoice = choice;
            return;
        }
        throw new IllegalStateException("Can not find choice item with name: " + name);
    }

    public Object convertToBean(Object value) {
        return this.convertToBean(value, (Object)null);
    }

    @Override
    public Object convertToBean(Object value, Object originalValue) {
        if (value instanceof DataTable) {
            value = ((DataTable)value).get();
        }
        for (Choice c : this.choices) {
            if (!c.getName().equals(value)) continue;
            return c.getObject();
        }
        throw new IllegalArgumentException("Unknown value: " + value);
    }

    @Override
    public Object convertToTable(Object value, TableFormat format) {
        for (Choice c : this.choices) {
            if (!c.getObject().equals(value)) continue;
            return c.getName();
        }
        throw new IllegalArgumentException("Unknown value: " + value);
    }

    public DataTable createTable(Object value, TableFormat format) throws DataTableException {
        return new SimpleDataTable(format, this.convertToTable(value));
    }
}

