/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable.converter;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.binding.Binding;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTableConversion;
import com.tibbo.aggregate.common.datatable.DataTableException;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.converter.FormatConverter;
import java.util.Arrays;
import java.util.LinkedHashSet;

public abstract class AbstractFormatConverter<T>
implements FormatConverter<T> {
    public static final String VF_IS_NULL = "isNull";
    public static final LinkedHashSet<String> FIELDS_TO_SKIP = new LinkedHashSet<String>(Arrays.asList("isNull"));
    private Class<T> valueClass;
    private TableFormat format;

    public static TableFormat deriveNullable(TableFormat format) {
        format = format.clone();
        for (FieldFormat fieldFormat : format.getFields()) {
            AbstractFormatConverter.addDisabledBinding(format, fieldFormat);
        }
        format.addField(FieldFormat.create("<isNull><B><D=" + Cres.get().getString("wNullValue") + "><A=0>"), 0);
        return format;
    }

    public static void addFiledToNullableFormat(TableFormat format, FieldFormat field) {
        format.addField(field);
        AbstractFormatConverter.addDisabledBinding(format, field);
    }

    public static void removeFiledFromNullableFormat(TableFormat format, String fieldName) {
        for (Binding binding : format.getBindings()) {
            if (!fieldName.equals(binding.getTarget().getField())) continue;
            format.removeBinding(binding);
        }
        format.removeField(fieldName);
    }

    private static void addDisabledBinding(TableFormat format, FieldFormat field) {
        format.addBinding(field.getName() + "#" + "enabled", "!{isNull}");
    }

    public AbstractFormatConverter(Class valueClass, TableFormat format) {
        this.valueClass = valueClass;
        this.format = format;
    }

    public AbstractFormatConverter(Class valueClass) {
        this.valueClass = valueClass;
    }

    @Override
    public Class<T> getValueClass() {
        return this.valueClass;
    }

    public void setValueClass(Class<T> valueClass) {
        this.valueClass = valueClass;
    }

    @Override
    public TableFormat getFormat() {
        return this.format;
    }

    @Override
    public FieldFormat createFieldFormat(String name) {
        return DataTableConversion.createTableField(name, this.format);
    }

    @Override
    public T instantiate(DataRecord source) throws InstantiationException {
        try {
            return this.convertToBean(source.wrap(), null);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public T clone(T value, boolean useConversion) {
        if (useConversion) {
            Object fieldValue = this.convertToTable(value);
            return this.convertToBean(fieldValue, null);
        }
        return null;
    }

    @Override
    public Object convertToTable(T value) {
        return this.convertToTable(value, null);
    }

    protected static Object simpleToTable(Object value, TableFormat format) {
        try {
            return DataTableConversion.beanToRecord(value, format, true, false, FIELDS_TO_SKIP).wrap();
        }
        catch (DataTableException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

