/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable;

import com.google.common.collect.ImmutableMap;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableException;
import com.tibbo.aggregate.common.datatable.DataTableQuery;
import com.tibbo.aggregate.common.datatable.DataTableSorter;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.ValidationException;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.datatable.encoding.FormatCache;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class TransformableDataTable
implements DataTable {
    private final DataTable origin;

    public TransformableDataTable(DataTable origin) {
        this.origin = origin;
    }

    @Override
    public Integer getRecordCount() {
        return this.origin.getRecordCount();
    }

    @Override
    public int getFieldCount() {
        return this.origin.getFieldCount();
    }

    @Override
    public TableFormat getFormat() {
        return this.origin.getFormat();
    }

    @Override
    public DataTable setFormat(TableFormat format) {
        return this.origin.setFormat(format);
    }

    @Override
    public FieldFormat getFormat(int field) {
        return this.origin.getFormat(field);
    }

    @Override
    public FieldFormat getFormat(String name) {
        return this.origin.getFormat(name);
    }

    @Override
    public boolean applyCachedFormat(Optional<FormatCache> formatCache) {
        return this.origin.applyCachedFormat(formatCache);
    }

    @Override
    public Long getId() {
        return this.origin.getId();
    }

    @Override
    public void setId(Long id) {
        this.origin.setId(id);
    }

    @Override
    public boolean hasField(String field) {
        return this.origin.hasField(field);
    }

    @Override
    public DataTable addRecords(List<DataRecord> records) {
        return this.origin.addRecords(records);
    }

    @Override
    public DataTable addRecord(DataRecord record) {
        return this.origin.addRecord(record);
    }

    @Override
    public DataRecord addRecord(Object ... fieldValues) {
        return this.origin.addRecord(fieldValues);
    }

    @Override
    public DataTable addRecord(int index, DataRecord record) {
        return this.origin.addRecord(index, record);
    }

    @Override
    public DataRecord addRecord() {
        return this.origin.addRecord();
    }

    @Override
    public void validate(Context context, ContextManager contextManager, CallerController caller) throws DataTableException {
        this.origin.validate(context, contextManager, caller);
    }

    @Override
    public void validateRecord(DataRecord record) throws ValidationException {
        this.origin.validateRecord(record);
    }

    @Override
    public DataTable setRecord(int index, DataRecord record) {
        return this.origin.setRecord(index, record);
    }

    @Override
    public void swapRecords(int index1, int index2) {
        this.origin.swapRecords(index1, index2);
    }

    @Override
    @Deprecated
    public List<DataRecord> getRecords() {
        return this.origin.getRecords();
    }

    @Override
    public boolean isInvalid() {
        return this.origin.isInvalid();
    }

    @Override
    public String getInvalidationMessage() {
        return this.origin.getInvalidationMessage();
    }

    @Override
    public void setInvalidationMessage(String invalidationMessage) {
        this.origin.setInvalidationMessage(invalidationMessage);
    }

    @Override
    public Date getTimestamp() {
        return this.origin.getTimestamp();
    }

    @Override
    public void setTimestamp(Date timestamp) {
        this.origin.setTimestamp(timestamp);
    }

    @Override
    public Integer getQuality() {
        return this.origin.getQuality();
    }

    @Override
    public void setQuality(Integer quality) {
        this.origin.setQuality(quality);
    }

    @Override
    public Object getValue() {
        return this.origin.getValue();
    }

    @Override
    public DataRecord getRecord(int number) {
        return this.origin.getRecord(number);
    }

    @Override
    public DataRecord getRecordById(String id) {
        return this.origin.getRecordById(id);
    }

    @Override
    public DataRecord removeRecord(int index) {
        return this.origin.removeRecord(index);
    }

    @Override
    public void removeRecordsByIds(Collection<String> ids) {
        this.origin.removeRecordsByIds(ids);
    }

    @Override
    public void removeRecords(DataRecord rec) {
        this.origin.removeRecords(rec);
    }

    @Override
    public void reorderRecord(DataRecord record, int index) {
        this.origin.reorderRecord(record, index);
    }

    @Override
    public boolean equals(Object obj) {
        return this.origin.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.origin.hashCode();
    }

    @Override
    public String getEncodedData(ClassicEncodingSettings settings) {
        return this.origin.getEncodedData(settings);
    }

    @Override
    public StringBuilder getEncodedData(StringBuilder finalSB, ClassicEncodingSettings settings, Boolean isTransferEncode, Integer encodeLevel) {
        return this.origin.getEncodedData(finalSB, settings, isTransferEncode, encodeLevel);
    }

    @Override
    public String encode() {
        return this.origin.encode();
    }

    @Override
    public String encode(boolean useVisibleSeparators) {
        return this.origin.encode(useVisibleSeparators);
    }

    @Override
    public String encode(ClassicEncodingSettings settings) {
        return this.origin.encode(settings);
    }

    @Override
    public StringBuilder encode(StringBuilder finalSB, ClassicEncodingSettings settings, Boolean isTransferEncode, Integer encodeLevel) {
        return this.origin.encode(finalSB, settings, isTransferEncode, encodeLevel);
    }

    @Override
    public String toString() {
        return this.origin.toString();
    }

    @Override
    public String getDescription() {
        return this.origin.getDescription();
    }

    @Override
    public String toDefaultString() {
        return this.origin.toDefaultString();
    }

    @Override
    public void fixRecords() {
        this.origin.fixRecords();
    }

    @Override
    public String dataAsString() {
        return this.origin.dataAsString();
    }

    @Override
    public String dataAsString(boolean showFieldNames, boolean showHiddenFields) {
        return this.origin.dataAsString(showFieldNames, showHiddenFields);
    }

    @Override
    public String dataAsString(boolean showFieldNames, boolean showHiddenFields, boolean showPasswords) {
        return this.origin.dataAsString(showFieldNames, showHiddenFields, showPasswords);
    }

    @Override
    public boolean isOneCellTable() {
        return this.origin.isOneCellTable();
    }

    @Override
    public boolean conform(TableFormat rf) {
        return this.origin.conform(rf);
    }

    @Override
    public String conformMessage(TableFormat rf) {
        return this.origin.conformMessage(rf);
    }

    @Override
    public List<DataRecord> selectAll(DataTableQuery query) {
        return this.origin.selectAll(query);
    }

    @Override
    public DataRecord select(DataTableQuery query) {
        return this.origin.select(query);
    }

    @Override
    public DataRecord select(String field, Object value) {
        return this.origin.select(field, value);
    }

    @Override
    public Integer findIndex(DataTableQuery query) {
        return this.origin.findIndex(query);
    }

    @Override
    public Integer findIndex(String field, Object value) {
        return this.origin.findIndex(field, value);
    }

    @Override
    public Integer findIndex(DataRecord record) {
        return this.origin.findIndex(record);
    }

    @Override
    public void sort(String field, boolean ascending) {
        this.origin.sort(field, ascending);
    }

    @Override
    public void sort(DataTableSorter sorter) {
        this.origin.sort(sorter);
    }

    @Override
    public void sort(Comparator<DataRecord> comparator) {
        this.origin.sort(comparator);
    }

    @Override
    public DataRecord rec() {
        return this.origin.rec();
    }

    @Override
    public Object get() {
        return this.origin.get();
    }

    @Override
    public void splitFormat() {
        this.origin.splitFormat();
    }

    @Override
    public void joinFormats() {
        this.origin.joinFormats();
    }

    @Override
    public Iterator<DataRecord> iterator() {
        return this.origin.iterator();
    }

    @Override
    public Iterator<DataRecord> iterator(int index) {
        return this.origin.iterator(index);
    }

    @Override
    public DataTable clone() {
        return this.origin.clone();
    }

    @Override
    public int compareTo(DataTable other) {
        return this.origin.compareTo(other);
    }

    @Override
    public void append(DataTable src) {
        this.origin.append(src);
    }

    @Override
    public DataTable makeImmutable() {
        return this.origin.makeImmutable();
    }

    @Override
    public DataTable cloneIfImmutable() {
        return this.origin.cloneIfImmutable();
    }

    @Override
    public boolean isImmutable() {
        return this.origin.isImmutable();
    }

    @Override
    public boolean isSimple() {
        return this.origin.isSimple();
    }

    @Override
    public void close() {
        this.origin.close();
    }

    @Override
    public Stream<DataRecord> stream() {
        return this.origin.stream();
    }

    @Override
    public void forEach(Consumer<? super DataRecord> action) {
        this.origin.forEach(action);
    }

    @Override
    public Spliterator<DataRecord> spliterator() {
        return this.origin.spliterator();
    }

    public Map<String, DataRecord> asMap(String keyField) {
        if (!this.origin.hasField(keyField)) {
            return ImmutableMap.of();
        }
        HashMap<String, DataRecord> result = new HashMap<String, DataRecord>();
        for (DataRecord record : this.origin) {
            result.put(record.getValueAsString(keyField), record);
        }
        return result;
    }

    public DataRecord removeRecordsByKey(String keyField, String value) {
        if (!this.origin.hasField(keyField)) {
            return null;
        }
        Integer index = this.origin.findIndex(keyField, value);
        if (index == null) {
            return null;
        }
        return this.origin.removeRecord(index);
    }

    public void processDataTableRecursively(Processor processor) {
        this.processDataTableRecursively(this.origin, processor);
    }

    private void processDataTableRecursively(DataTable table, Processor processor) {
        for (DataRecord rec : table) {
            for (FieldFormat ff : rec.getFormat()) {
                if (ff.getType() == 'T') {
                    DataTable nestedTable = rec.getDataTable(ff.getName());
                    if (nestedTable == null) continue;
                    this.processDataTableRecursively(nestedTable, processor);
                    continue;
                }
                processor.process(rec, ff);
            }
        }
    }

    public static interface Processor {
        public void process(DataRecord var1, FieldFormat var2);
    }
}

