/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.binding.Binding;
import com.tibbo.aggregate.common.context.ContextRuntimeException;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableException;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.datatable.encoding.FormatCache;
import com.tibbo.aggregate.common.datatable.validator.KeyFieldsValidator;
import com.tibbo.aggregate.common.datatable.validator.RecordValidator;
import com.tibbo.aggregate.common.datatable.validator.TableExpressionValidator;
import com.tibbo.aggregate.common.datatable.validator.TableKeyFieldsValidator;
import com.tibbo.aggregate.common.datatable.validator.TableValidator;
import com.tibbo.aggregate.common.expression.Expression;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.util.CloneUtils;
import com.tibbo.aggregate.common.util.Element;
import com.tibbo.aggregate.common.util.ElementList;
import com.tibbo.aggregate.common.util.PublicCloneable;
import com.tibbo.aggregate.common.util.StringEncodable;
import com.tibbo.aggregate.common.util.StringUtils;
import com.tibbo.aggregate.common.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public final class TableFormat
implements Iterable<FieldFormat>,
Cloneable,
PublicCloneable,
StringEncodable {
    public static final TableFormat EMPTY_FORMAT = new TableFormat(0, 0);
    public static final int DEFAULT_MIN_RECORDS = 0;
    public static final int DEFAULT_MAX_RECORDS = Integer.MAX_VALUE;
    private static final String ELEMENT_FLAGS = "F";
    private static final String ELEMENT_TABLE_VALIDATORS = "V";
    private static final String ELEMENT_RECORD_VALIDATORS = "R";
    private static final String ELEMENT_BINDINGS = "B";
    private static final String ELEMENT_MIN_RECORDS = "M";
    private static final String ELEMENT_MAX_RECORDS = "X";
    private static final String ELEMENT_NAMING = "N";
    public static final char TABLE_VALIDATOR_KEY_FIELDS = 'K';
    public static final char TABLE_VALIDATOR_EXPRESSION = 'E';
    public static final char RECORD_VALIDATOR_KEY_FIELDS = 'K';
    private static final char REORDERABLE_FLAG = 'R';
    private static final char UNRESIZEBLE_FLAG = 'U';
    private static final char BINDINGS_EDITABLE_FLAG = 'B';
    private List<FieldFormat> fields = new ArrayList<FieldFormat>(4);
    private transient Map<String, Integer> fieldLookup = new HashMap<String, Integer>(4);
    private int minRecords = 0;
    private int maxRecords = Integer.MAX_VALUE;
    private boolean reorderable;
    private boolean unresizable;
    private boolean bindingsEditable;
    private List<RecordValidator> recordValidators = new LinkedList<RecordValidator>();
    private List<TableValidator> tableValidators = new LinkedList<TableValidator>();
    private List<Binding> bindings = new LinkedList<Binding>();
    private Expression namingExpression;
    private transient boolean immutable;
    private transient Integer immutabilizerIdentityHashCode;
    private Integer id;
    private volatile Integer formatCacheIdentityHashCode;

    public TableFormat() {
    }

    public TableFormat(boolean reorderable) {
        this();
        this.setReorderable(reorderable);
    }

    public TableFormat(int minRecords, int maxRecords) {
        this();
        this.setMinRecords(minRecords);
        this.setMaxRecords(maxRecords);
    }

    public TableFormat(FieldFormat ff) {
        this();
        this.addField(ff);
    }

    public TableFormat(String format, ClassicEncodingSettings settings) {
        this(format, settings, true);
    }

    public TableFormat(String format, ClassicEncodingSettings settings, boolean validate) {
        this();
        if (format == null) {
            return;
        }
        ElementList els = StringUtils.elements(format, settings.isUseVisibleSeparators());
        for (Element el : els) {
            if (el.getName() == null) {
                this.addField(FieldFormat.create(el.getValue(), settings, validate));
                continue;
            }
            if (el.getName().equals(ELEMENT_FLAGS)) {
                String flags = el.getValue();
                this.setReorderable(flags.indexOf(82) != -1);
                this.setUnresizable(flags.indexOf(85) != -1);
                this.setBindingsEditable(flags.indexOf(66) != -1);
                continue;
            }
            if (el.getName().equals(ELEMENT_MIN_RECORDS)) {
                this.minRecords = Integer.parseInt(el.getValue());
                continue;
            }
            if (el.getName().equals(ELEMENT_MAX_RECORDS)) {
                this.maxRecords = Integer.parseInt(el.getValue());
                continue;
            }
            if (el.getName().equals(ELEMENT_TABLE_VALIDATORS)) {
                this.createTableValidators(el.getValue(), settings);
                continue;
            }
            if (el.getName().equals(ELEMENT_RECORD_VALIDATORS)) {
                this.createRecordValidators(el.getValue(), settings);
                continue;
            }
            if (el.getName().equals(ELEMENT_BINDINGS)) {
                this.createBindings(el.getValue(), settings);
                continue;
            }
            if (!el.getName().equals(ELEMENT_NAMING)) continue;
            this.createNaming(el.getValue());
        }
    }

    public TableFormat(int minRecords, int maxRecords, String fieldFormat) {
        this(minRecords, maxRecords);
        this.addField(fieldFormat);
    }

    public TableFormat(int minRecords, int maxRecords, FieldFormat fieldFormat) {
        this(minRecords, maxRecords);
        this.addField(fieldFormat);
    }

    public TableFormat addFields(FieldFormat[] fieldFormats) {
        for (FieldFormat each : fieldFormats) {
            this.addField(each);
        }
        return this;
    }

    public TableFormat addFields(List<FieldFormat> fieldFormats) {
        for (FieldFormat each : fieldFormats) {
            this.addField(each);
        }
        return this;
    }

    public TableFormat addField(FieldFormat ff) {
        return this.addField(ff, this.fields.size());
    }

    public TableFormat addField(String encodedFormat) {
        return this.addField(FieldFormat.create(encodedFormat));
    }

    public void addField(char type, String name) throws DataTableException {
        this.addField(type, name, this.fields.size());
    }

    public TableFormat addField(char type, String name, String description) {
        this.addField(FieldFormat.create(name, type, description));
        return this;
    }

    public TableFormat addField(char type, String name, String description, Object defaultValue) {
        this.addField(FieldFormat.create(name, type, description, defaultValue));
        return this;
    }

    public TableFormat addField(char type, String name, String description, Object defaultValue, String group) {
        this.addField(FieldFormat.create(name, type, description, defaultValue, group));
        return this;
    }

    public TableFormat addField(char type, String name, String description, Object defaultValue, boolean nullable) {
        this.addField(FieldFormat.create(name, type, description, defaultValue, nullable));
        return this;
    }

    public TableFormat addField(char type, String name, String description, Object defaultValue, boolean nullable, String group) {
        this.addField(FieldFormat.create(name, type, description, defaultValue, nullable, group));
        return this;
    }

    public TableFormat addField(FieldFormat ff, int index) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        FieldFormat existing = this.getField(ff.getName());
        if (existing != null) {
            if (!ff.extend(existing)) {
                throw new IllegalArgumentException("Field '" + ff.getName() + "' already exists in format");
            }
            return this;
        }
        for (int i = index; i < this.fields.size(); ++i) {
            String fn = this.fields.get(i).getName();
            Integer previousIndex = this.getFieldLookup().get(fn);
            if (previousIndex == null) {
                throw new IllegalStateException("Null lookup index for field " + i + " (" + fn + ")");
            }
            this.getFieldLookup().put(fn, previousIndex + 1);
        }
        this.fields.add(index, ff);
        this.getFieldLookup().put(ff.getName(), index);
        return this;
    }

    public TableFormat addField(char type, String name, int index) throws DataTableException {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        return this.addField(FieldFormat.create(name, type), index);
    }

    public TableFormat removeField(String name) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        Integer index = this.getFieldLookup().remove(name);
        if (index != null) {
            this.fields.remove(index);
            for (int i = index.intValue(); i < this.fields.size(); ++i) {
                String fn = this.fields.get(i).getName();
                this.getFieldLookup().put(fn, this.getFieldLookup().get(fn) - 1);
            }
        }
        return this;
    }

    public TableFormat renameField(String oldName, String newName) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        FieldFormat ff = this.getField(oldName);
        if (ff == null) {
            return this;
        }
        ff.setName(newName);
        Integer index = this.getFieldLookup().remove(oldName);
        if (index != null) {
            this.getFieldLookup().put(newName, index);
        }
        return this;
    }

    public char getFieldType(int index) {
        return this.fields.get(index).getType();
    }

    public String getFieldName(int index) {
        return this.fields.get(index).getName();
    }

    public int getFieldIndex(String name) {
        Integer index = this.getFieldLookup().get(name);
        return index != null ? index : -1;
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public List<FieldFormat> getFields() {
        return this.immutable ? Collections.unmodifiableList(this.fields) : this.fields;
    }

    public List<RecordValidator> getRecordValidators() {
        return this.immutable ? Collections.unmodifiableList(this.recordValidators) : this.recordValidators;
    }

    public List<TableValidator> getTableValidators() {
        return this.immutable ? Collections.unmodifiableList(this.tableValidators) : this.tableValidators;
    }

    public int getMaxRecords() {
        return this.maxRecords;
    }

    public int getMinRecords() {
        return this.minRecords;
    }

    public boolean isReorderable() {
        return this.reorderable;
    }

    public boolean isUnresizable() {
        return this.unresizable;
    }

    public void setUnresizable(boolean unresizable) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.unresizable = unresizable;
    }

    public boolean isBindingsEditable() {
        return this.bindingsEditable;
    }

    public void setBindingsEditable(boolean bindingsEditable) {
        this.bindingsEditable = bindingsEditable;
    }

    public List<Binding> getBindings() {
        return this.immutable ? Collections.unmodifiableList(this.bindings) : this.bindings;
    }

    public void addBinding(Binding binding) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.bindings.add(binding);
    }

    public void addBinding(Reference target, Expression expression) {
        this.addBinding(new Binding(target, expression));
    }

    public void addBinding(String target, String expression) {
        this.addBinding(new Binding(new Reference(target), new Expression(expression)));
    }

    public void removeBinding(Binding binding) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.bindings.remove(binding);
    }

    public void setBindings(List<Binding> in_bindings) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.bindings = in_bindings;
    }

    public Expression getNamingExpression() {
        return this.namingExpression;
    }

    public String encode(boolean useVisibleSeparators) {
        return this.encode(new ClassicEncodingSettings(useVisibleSeparators));
    }

    public String encode(ClassicEncodingSettings settings) {
        return this.encode(settings, false, 0);
    }

    public String encode(ClassicEncodingSettings settings, Boolean isTransferEncode, Integer encodeLevel) {
        StringBuilder formatString = new StringBuilder(this.getFieldCount() * 7);
        this.encode(formatString, settings, isTransferEncode, encodeLevel);
        return formatString.toString();
    }

    @Override
    public StringBuilder encode(StringBuilder builder, ClassicEncodingSettings settings, Boolean isTransferEncode, Integer encodeLevel) {
        for (int i = 0; i < this.fields.size(); ++i) {
            new Element(null, this.getField(i).encode(settings)).encode(builder, settings, isTransferEncode, encodeLevel);
        }
        if (this.minRecords != 0) {
            new Element(ELEMENT_MIN_RECORDS, String.valueOf(this.minRecords)).encode(builder, settings, isTransferEncode, encodeLevel);
        }
        if (this.maxRecords != Integer.MAX_VALUE) {
            new Element(ELEMENT_MAX_RECORDS, String.valueOf(this.maxRecords)).encode(builder, settings, isTransferEncode, encodeLevel);
        }
        if (this.tableValidators.size() > 0) {
            new Element(ELEMENT_TABLE_VALIDATORS, this.getEncodedTableValidators(settings)).encode(builder, settings, isTransferEncode, encodeLevel);
        }
        if (this.recordValidators.size() > 0) {
            new Element(ELEMENT_RECORD_VALIDATORS, this.getEncodedRecordValidators(settings)).encode(builder, settings, isTransferEncode, encodeLevel);
        }
        if (this.bindings.size() > 0) {
            new Element(ELEMENT_BINDINGS, this.getEncodedBindings(settings)).encode(builder, settings, isTransferEncode, encodeLevel);
        }
        if (this.namingExpression != null) {
            new Element(ELEMENT_NAMING, this.namingExpression.getText()).encode(builder, settings, isTransferEncode, encodeLevel);
        }
        TableFormat.encAppend(builder, ELEMENT_FLAGS, this.getEncodedFlags(), settings);
        return builder;
    }

    private static void encAppend(StringBuilder buffer, String name, String value, ClassicEncodingSettings settings) {
        if (value != null && value.length() > 0) {
            buffer.append(new Element(name, value).encode(settings));
        }
    }

    public Map<String, Integer> getFieldLookup() {
        if (this.fieldLookup == null) {
            this.fieldLookup = new HashMap<String, Integer>(this.getFieldCount());
            for (int i = 0; i < this.fields.size(); ++i) {
                FieldFormat field = this.fields.get(i);
                this.fieldLookup.put(field.getName(), i);
            }
        }
        return this.fieldLookup;
    }

    private String getEncodedFlags() {
        StringBuilder buf = new StringBuilder();
        if (this.isReorderable()) {
            buf.append('R');
        }
        if (this.isUnresizable()) {
            buf.append('U');
        }
        if (this.isBindingsEditable()) {
            buf.append('B');
        }
        return buf.toString();
    }

    public String getEncodedTableValidators(ClassicEncodingSettings settings) {
        StringBuilder enc = new StringBuilder();
        for (TableValidator tv : this.tableValidators) {
            if (tv.getType() == null) continue;
            enc.append(new Element(String.valueOf(tv.getType()), tv.encode()).encode(settings));
        }
        return enc.toString();
    }

    private String getEncodedRecordValidators(ClassicEncodingSettings settings) {
        StringBuilder enc = new StringBuilder();
        for (RecordValidator rv : this.recordValidators) {
            if (rv.getType() == null) continue;
            enc.append(new Element(String.valueOf(rv.getType()), rv.encode()).encode(settings));
        }
        return enc.toString();
    }

    private String getEncodedBindings(ClassicEncodingSettings settings) {
        StringBuilder enc = new StringBuilder();
        for (Binding bin : this.bindings) {
            enc.append(new Element(bin.getTarget().getImage(), bin.getExpression().getText()).encode(settings));
        }
        return enc.toString();
    }

    public String toString() {
        return this.encode(new ClassicEncodingSettings(true));
    }

    public FieldFormat getField(int index) {
        return this.fields.get(index);
    }

    public FieldFormat getField(String fieldName) {
        int index = this.getFieldIndex(fieldName);
        if (index != -1) {
            return this.getField(index);
        }
        return null;
    }

    public boolean hasField(String name) {
        return this.getFieldIndex(name) != -1;
    }

    public boolean hasFields(char type) {
        for (FieldFormat ff : this) {
            if (ff.getType() != type) continue;
            return true;
        }
        return false;
    }

    public boolean hasReadOnlyFields() {
        for (FieldFormat ff : this) {
            if (!ff.isReadonly()) continue;
            return true;
        }
        return false;
    }

    public List<String> getKeyFields() {
        LinkedList<String> keyFields = new LinkedList<String>();
        for (FieldFormat ff : this) {
            if (!ff.isKeyField()) continue;
            keyFields.add(ff.getName());
        }
        return keyFields;
    }

    public boolean extend(TableFormat other) {
        return this.extendMessage(other) == null;
    }

    public String extendMessage(TableFormat other) {
        if (this == other) {
            return null;
        }
        if (this.equals(other)) {
            return null;
        }
        if (!this.isReorderable() && other.isReorderable()) {
            return "Different reorderable flags: need " + this.isReorderable() + ", found " + other.isReorderable();
        }
        if (!this.isUnresizable() && other.isUnresizable()) {
            return "Different unresizable flags: need " + this.isUnresizable() + ", found " + other.isUnresizable();
        }
        if (!Util.equals(this.getNamingExpression(), other.getNamingExpression())) {
            return "Different naming expressions: need " + this.getNamingExpression() + ", found " + other.getNamingExpression();
        }
        for (Binding otherBinding : other.getBindings()) {
            if (this.getBindings().contains(otherBinding)) continue;
            return "Different bindings: need " + this.getBindings() + ", found " + other.getBindings();
        }
        for (FieldFormat otherFormat : other) {
            FieldFormat ownFormat = this.getField(otherFormat.getName());
            if (ownFormat == null) {
                if (otherFormat.isOptional()) continue;
                return "Required field doesn't exist: " + otherFormat.getName();
            }
            String fieldExtendMessage = ownFormat.extendMessage(otherFormat);
            if (fieldExtendMessage == null) continue;
            return "Incorrect format of field '" + otherFormat.getName() + "': " + fieldExtendMessage;
        }
        return null;
    }

    public void addTableValidator(TableValidator tv) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.tableValidators.add(tv);
    }

    public void addRecordValidator(RecordValidator rv) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.recordValidators.add(rv);
    }

    public void createTableValidators(String source, ClassicEncodingSettings settings) {
        if (source == null || source.length() == 0) {
            return;
        }
        ElementList validatorsData = StringUtils.elements(source, settings.isUseVisibleSeparators());
        for (Element el : validatorsData) {
            char validatorType = el.getName().charAt(0);
            String validatorParams = el.getValue();
            switch (validatorType) {
                case 'K': {
                    this.addTableValidator(new TableKeyFieldsValidator(validatorParams));
                    break;
                }
                case 'E': {
                    this.addTableValidator(new TableExpressionValidator(validatorParams));
                }
            }
        }
    }

    private void createRecordValidators(String source, ClassicEncodingSettings settings) {
        if (source == null || source.length() == 0) {
            return;
        }
        ElementList validatorsData = StringUtils.elements(source, settings.isUseVisibleSeparators());
        for (Element el : validatorsData) {
            char validatorType = el.getName().charAt(0);
            String validatorParams = el.getValue();
            if (validatorType != 'K') continue;
            this.addRecordValidator(new KeyFieldsValidator(validatorParams));
        }
    }

    private void createBindings(String source, ClassicEncodingSettings settings) {
        if (source == null || source.length() == 0) {
            return;
        }
        ElementList bindingsData = StringUtils.elements(source, settings.isUseVisibleSeparators());
        for (Element el : bindingsData) {
            this.bindings.add(new Binding(new Reference(el.getName()), new Expression(el.getValue())));
        }
    }

    private void createNaming(String source) {
        if (source == null || source.length() == 0) {
            return;
        }
        this.namingExpression = new Expression(source);
    }

    @Override
    public Iterator<FieldFormat> iterator() {
        return this.fields.iterator();
    }

    public boolean isReplicated() {
        for (FieldFormat ff : this) {
            if (ff.isNotReplicated()) continue;
            return true;
        }
        return false;
    }

    public boolean isReadonly() {
        for (FieldFormat ff : this) {
            if (ff.isReadonly()) continue;
            return false;
        }
        return true;
    }

    public boolean isGrouped() {
        for (FieldFormat ff : this) {
            if (ff.getGroup() == null) continue;
            return true;
        }
        return false;
    }

    public boolean isAdvanced() {
        for (FieldFormat ff : this) {
            if (!ff.isAdvanced()) continue;
            return true;
        }
        return false;
    }

    public boolean isSingleRecord() {
        return this.minRecords == 1 && this.maxRecords == 1;
    }

    public boolean isSingleField() {
        return this.getFieldCount() == 1;
    }

    public boolean isSingleCell() {
        return this.isSingleRecord() && this.isSingleField();
    }

    public boolean isEmpty() {
        return this.minRecords == 0 && this.maxRecords == 0 && this.getFieldCount() == 0;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public TableFormat resetAllowedRecords() {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.minRecords = 0;
        this.maxRecords = Integer.MAX_VALUE;
        return this;
    }

    public TableFormat setMaxRecords(int maxRecords) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.maxRecords = maxRecords;
        return this;
    }

    public TableFormat setMinRecords(int minRecords) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.minRecords = minRecords;
        return this;
    }

    void fixRecords(DataTable table) {
        if (this.immutable && !Objects.equals(this.immutabilizerIdentityHashCode, System.identityHashCode(table))) {
            throw new IllegalStateException("Format was not made immutable by this table");
        }
        this.minRecords = table.getRecordCount();
        this.maxRecords = table.getRecordCount();
    }

    public TableFormat setReorderable(boolean reorderable) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.reorderable = reorderable;
        return this;
    }

    public TableFormat setNamingExpression(Expression namingExpression) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.namingExpression = namingExpression;
        return this;
    }

    public TableFormat setNamingExpression(String namingExpression) {
        this.setNamingExpression(new Expression(namingExpression));
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.maxRecords;
        result = 31 * result + this.minRecords;
        result = 31 * result + (this.fields == null ? 0 : this.fields.hashCode());
        result = 31 * result + (this.namingExpression == null ? 0 : this.namingExpression.hashCode());
        result = 31 * result + (this.recordValidators == null ? 0 : this.recordValidators.hashCode());
        result = 31 * result + (this.tableValidators == null ? 0 : this.tableValidators.hashCode());
        result = 31 * result + (this.reorderable ? 1231 : 1237);
        result = 31 * result + (this.unresizable ? 1231 : 1237);
        if ((result = 31 * result + (this.bindings == null ? 0 : this.bindings.hashCode())) < 0) {
            result = Integer.MAX_VALUE + result;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableFormat other = (TableFormat)obj;
        if (this.maxRecords != other.maxRecords) {
            return false;
        }
        if (this.minRecords != other.minRecords) {
            return false;
        }
        if (this.fields == null ? other.fields != null : !this.fields.equals(other.fields)) {
            return false;
        }
        if (this.namingExpression == null ? other.namingExpression != null : !this.namingExpression.equals(other.namingExpression)) {
            return false;
        }
        if (this.recordValidators == null ? other.recordValidators != null : !this.recordValidators.equals(other.recordValidators)) {
            return false;
        }
        if (this.tableValidators == null ? other.tableValidators != null : !this.tableValidators.equals(other.tableValidators)) {
            return false;
        }
        if (this.reorderable != other.reorderable) {
            return false;
        }
        if (this.unresizable != other.unresizable) {
            return false;
        }
        if (this.bindingsEditable != other.bindingsEditable) {
            return false;
        }
        if (this.bindings == null) {
            return other.bindings == null;
        }
        return this.bindings.equals(other.bindings);
    }

    public TableFormat cloneIfImmutable() {
        if (this.isImmutable()) {
            return this.clone();
        }
        return this;
    }

    @Override
    public TableFormat clone() {
        TableFormat cl;
        try {
            cl = (TableFormat)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
        cl.fields = (List)CloneUtils.deepClone(this.fields);
        cl.fieldLookup = (Map)CloneUtils.deepClone(this.getFieldLookup());
        cl.recordValidators = (List)CloneUtils.deepClone(this.recordValidators);
        cl.tableValidators = (List)CloneUtils.deepClone(this.tableValidators);
        cl.bindings = (List)CloneUtils.deepClone(this.bindings);
        cl.id = null;
        cl.immutable = false;
        return cl;
    }

    public void makeImmutable(DataTable immutabilizer) {
        if (this.immutable) {
            return;
        }
        this.immutable = true;
        this.immutabilizerIdentityHashCode = System.identityHashCode(immutabilizer);
        for (FieldFormat ff : this.fields) {
            ff.makeImmutable();
        }
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        if (!this.immutable) {
            throw new ContextRuntimeException("Cannot set ID of non-immutable format");
        }
        if (this.id != null && !this.id.equals(id)) {
            throw new ContextRuntimeException("Format already has ID " + this.id + ", new ID " + id);
        }
        this.id = id;
    }

    public void applyCachedFormat(FormatCache formatCache, Consumer<TableFormat> formatSetter) {
        Integer cachedFormatId;
        if (this.isAttachedToAnotherCache(formatCache)) {
            return;
        }
        try {
            cachedFormatId = formatCache.addIfNotExists(this);
        }
        catch (UnsupportedOperationException e) {
            Log.PROTOCOL_CACHING.debug((Object)("Illegal attempt to add format: '" + this + "' into the cache: '" + formatCache.getName() + "'"));
            return;
        }
        TableFormat cachedFormat = formatCache.get(cachedFormatId);
        if (!cachedFormat.equals(this)) {
            Log.PROTOCOL_CACHING.fatal((Object)("Expected format: '" + this + "' is differ from the cached one. Cached id: '" + cachedFormatId + "' , Cached Format: '" + cachedFormat + "'"));
            return;
        }
        if (cachedFormat != this) {
            formatSetter.accept(cachedFormat);
        }
    }

    public void setFormatCacheIdentityHashCode(int formatCacheIdentityHashCode) {
        this.formatCacheIdentityHashCode = formatCacheIdentityHashCode;
    }

    public boolean isAttachedToAnotherCache(FormatCache formatCache) {
        return this.formatCacheIdentityHashCode != null && this.formatCacheIdentityHashCode != System.identityHashCode(formatCache);
    }

    public boolean isCachedLocally() {
        return this.formatCacheIdentityHashCode != null;
    }

    public boolean containsDataBlocksOrTables() {
        for (FieldFormat field : this.fields) {
            if (field.getType() != 'A' && field.getType() != 'T') continue;
            return true;
        }
        return false;
    }
}

