/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable;

import com.tibbo.aggregate.common.datatable.AbstractUnmodifiableDataTable;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableQuery;
import com.tibbo.aggregate.common.datatable.IndexTableCache;
import com.tibbo.aggregate.common.datatable.QueryCondition;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.util.Element;
import com.tibbo.aggregate.common.util.ImmutablePair;
import com.tibbo.aggregate.common.util.Util;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;

public class SortedCompositeDataTable
extends AbstractUnmodifiableDataTable {
    private final List<DataTable> sources;
    private final String fieldName;
    private final boolean ascending;
    private final IndexTableCache<ImmutablePair<Integer, Integer>> indexTableCache;

    public SortedCompositeDataTable(List<DataTable> sources, String fieldName, boolean ascending) {
        this.assertValidSources(sources, fieldName);
        this.setFormat(sources.get(0).getFormat().clone().setMaxRecords(Integer.MAX_VALUE));
        this.sources = sources;
        this.fieldName = fieldName;
        this.ascending = ascending;
        this.indexTableCache = new IndexTableCache(this);
    }

    private void assertValidSources(List<DataTable> sources, String fieldName) {
        if (Objects.requireNonNull(sources, "List of source data tables must not be null").size() == 0) {
            throw new IllegalArgumentException("There must be at least one source table");
        }
        Iterator<DataTable> itr = sources.iterator();
        TableFormat tableFormat = itr.next().getFormat();
        if (!tableFormat.hasField(Objects.requireNonNull(fieldName, "Field name must not be null"))) {
            throw new IllegalArgumentException("Every source table must have a field named " + fieldName);
        }
        while (itr.hasNext()) {
            if (tableFormat.equals(itr.next().getFormat())) continue;
            throw new IllegalArgumentException("All source tables must have the same format");
        }
    }

    @Override
    void getEncodedRecordsOrTableID(StringBuilder finalSB, ClassicEncodingSettings settings, Boolean isTransferEncode, Integer encodeLevel) {
        if (this.id != null) {
            new Element("C", String.valueOf(this.id)).encode(finalSB, settings, isTransferEncode, encodeLevel);
        }
    }

    @Override
    public DataRecord getRecord(int number) {
        this.indexTableCache.ensureNotDefinitelyInvalid(number);
        List<ImmutablePair<Integer, Integer>> indexTable = this.indexTableCache.getIndexTable();
        if (number < indexTable.size()) {
            ImmutablePair<Integer, Integer> tableNumberAndIndex = indexTable.get(number);
            return this.sources.get(tableNumberAndIndex.getFirst()).getRecord(tableNumberAndIndex.getSecond());
        }
        return this.indexTableCache.iterateThroughSourceUpToNumber(number, indexTable);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SortedCompositeDataTable)) {
            return false;
        }
        SortedCompositeDataTable other = (SortedCompositeDataTable)obj;
        if (!this.fieldName.equals(other.fieldName)) {
            return false;
        }
        if (this.ascending != other.ascending) {
            return false;
        }
        if (!Util.equals(this.quality, other.quality)) {
            return false;
        }
        return new HashSet<DataTable>(this.sources).equals(new HashSet<DataTable>(other.sources));
    }

    @Override
    public int hashCode() {
        return Objects.hash(new HashSet<DataTable>(this.sources), this.fieldName, this.ascending, this.quality);
    }

    @Override
    public String toDefaultString() {
        return "Sorted composite data table with sources: " + this.sources;
    }

    @Override
    public String dataAsString(boolean showFieldNames, boolean showHiddenFields, boolean showPasswords) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    @Override
    public boolean isOneCellTable() {
        return this.indexTableCache.isOneCellTable();
    }

    @Override
    public Integer findIndex(DataTableQuery query) {
        Iterator<DataRecord> itr = this.iterator();
        int i = 0;
        while (itr.hasNext()) {
            boolean meet = true;
            DataRecord rec = itr.next();
            for (QueryCondition cond : query.getConditions()) {
                if (rec.meetToCondition(cond)) continue;
                meet = false;
            }
            if (meet) {
                return i;
            }
            ++i;
        }
        return null;
    }

    @Override
    public Iterator<DataRecord> iterator() {
        return new Iter();
    }

    @Override
    public Iterator<DataRecord> iterator(int index) {
        return new Iter(index);
    }

    private static final class TopRecord {
        private final int tableNumber;
        private final int index;
        private final DataRecord record;

        public TopRecord(int tableNumber, int index, DataRecord record) {
            this.tableNumber = tableNumber;
            this.index = index;
            this.record = record;
        }

        public int getTableNumber() {
            return this.tableNumber;
        }

        public int getIndex() {
            return this.index;
        }

        public DataRecord getRecord() {
            return this.record;
        }
    }

    private static enum Extremum {
        MIN,
        MAX;

    }

    private final class Iter
    implements Iterator<DataRecord> {
        private final List<ImmutablePair<Integer, Integer>> indexTable;
        private final List<Iterator<DataRecord>> sourceIterators;
        private final TopRecords topRecords;
        private DataRecord nextRecord;
        private boolean isNextRecordSet;
        private int cursor;

        Iter() {
            this.indexTable = SortedCompositeDataTable.this.indexTableCache.getIndexTable();
            this.sourceIterators = SortedCompositeDataTable.this.sources.stream().map(DataTable::iterator).collect(Collectors.toList());
            this.topRecords = new TopRecords(this.sourceIterators);
            this.cursor = -1;
        }

        Iter(int index) {
            this.indexTable = SortedCompositeDataTable.this.indexTableCache.getIndexTable();
            this.sourceIterators = SortedCompositeDataTable.this.sources.stream().map(DataTable::iterator).collect(Collectors.toList());
            this.topRecords = new TopRecords(this.sourceIterators);
            if (index > this.indexTable.size()) {
                this.cursor = this.indexTable.size() - 1;
                while (this.hasNext() && this.cursor < index) {
                    this.next();
                }
                if (this.cursor != index) {
                    throw new NoSuchElementException("There is no element with index #" + index + " in this composite data table");
                }
            } else {
                this.cursor = index - 1;
                for (int i = 0; i <= this.cursor; ++i) {
                    this.topRecords.pop();
                }
            }
        }

        @Override
        public boolean hasNext() {
            if (this.cursor + 1 < this.indexTable.size()) {
                return true;
            }
            if (this.isNextRecordSet || this.setNextRecord()) {
                return true;
            }
            SortedCompositeDataTable.this.indexTableCache.setSoftIndexTable(this.indexTable);
            SortedCompositeDataTable.this.setRecordCount(this.cursor + 1);
            return false;
        }

        @Override
        public DataRecord next() {
            if (this.cursor + 1 < this.indexTable.size()) {
                ImmutablePair<Integer, Integer> tableNumberAndIndex = this.indexTable.get(++this.cursor);
                this.topRecords.pop();
                return ((DataTable)SortedCompositeDataTable.this.sources.get(tableNumberAndIndex.getFirst())).getRecord(tableNumberAndIndex.getSecond());
            }
            if (!this.isNextRecordSet && !this.setNextRecord()) {
                throw new NoSuchElementException();
            }
            this.isNextRecordSet = false;
            return this.nextRecord;
        }

        private boolean setNextRecord() {
            TopRecord topRecord = this.topRecords.pop();
            if (topRecord == null) {
                return false;
            }
            this.nextRecord = topRecord.getRecord();
            this.isNextRecordSet = true;
            ++this.cursor;
            this.indexTable.add(new ImmutablePair<Integer, Integer>(topRecord.getTableNumber(), topRecord.getIndex()));
            return true;
        }

        private final class TopRecords {
            private final List<Iterator<DataRecord>> sourceIterators;
            private final int size;
            private final DataRecord[] records;
            private final Object[] values;
            private final Integer[] indexes;

            TopRecords(List<Iterator<DataRecord>> sourceIterators) {
                this.size = SortedCompositeDataTable.this.sources.size();
                this.records = new DataRecord[this.size];
                this.values = new Object[this.size];
                this.indexes = new Integer[this.size];
                this.sourceIterators = sourceIterators;
                this.initializeValuesAndIndexes();
            }

            private void initializeValuesAndIndexes() {
                int tableNumber = 0;
                for (Iterator<DataRecord> itr : this.sourceIterators) {
                    if (!itr.hasNext()) {
                        ++tableNumber;
                        continue;
                    }
                    DataRecord record = itr.next();
                    Object value = record.getValue(SortedCompositeDataTable.this.fieldName);
                    if (!(value instanceof Comparable)) {
                        throw new IllegalArgumentException("The type of field named '" + SortedCompositeDataTable.this.fieldName + "' is not comparable");
                    }
                    this.indexes[tableNumber] = 0;
                    this.records[tableNumber] = record;
                    this.values[tableNumber++] = value;
                }
            }

            TopRecord pop() {
                Integer tableNumber = this.findExtremum(SortedCompositeDataTable.this.ascending ? Extremum.MIN : Extremum.MAX);
                if (tableNumber == null) {
                    return null;
                }
                DataRecord record = this.records[tableNumber];
                int index = this.indexes[tableNumber];
                TopRecord result = new TopRecord(tableNumber, index, record);
                Iterator<DataRecord> itr = this.sourceIterators.get(tableNumber);
                DataRecord newRecord = itr.hasNext() ? itr.next() : null;
                Object newValue = newRecord != null ? newRecord.getValue(SortedCompositeDataTable.this.fieldName) : null;
                Integer newIndex = newValue != null ? Integer.valueOf(index + 1) : null;
                this.records[tableNumber.intValue()] = newRecord;
                this.values[tableNumber.intValue()] = newValue;
                this.indexes[tableNumber.intValue()] = newIndex;
                return result;
            }

            private Integer findExtremum(Extremum extremum) {
                Object value;
                int i;
                Object extremumValue = null;
                int extremumIndex = 0;
                for (i = 0; i < this.values.length; ++i) {
                    value = this.values[i];
                    if (value == null) continue;
                    extremumValue = value;
                    extremumIndex = i;
                    break;
                }
                if (extremumValue == null) {
                    return null;
                }
                for (i = extremumIndex + 1; i < this.values.length; ++i) {
                    boolean condition;
                    value = this.values[i];
                    if (value == null || !(condition = this.getCondition(extremum, extremumValue, (Comparable)value))) continue;
                    extremumValue = value;
                    extremumIndex = i;
                }
                return extremumIndex;
            }

            private boolean getCondition(Extremum extremum, Object extremumValue, Comparable value) {
                boolean condition;
                switch (extremum) {
                    case MAX: {
                        condition = value.compareTo(extremumValue) > 0;
                        break;
                    }
                    case MIN: {
                        condition = value.compareTo(extremumValue) < 0;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown extremum type: " + (Object)((Object)extremum));
                    }
                }
                return condition;
            }
        }
    }
}

