/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.datatable.AbstractDataTable;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableException;
import com.tibbo.aggregate.common.datatable.DataTableQuery;
import com.tibbo.aggregate.common.datatable.DataTableSorter;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.QueryCondition;
import com.tibbo.aggregate.common.datatable.SortOrder;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.ValidationException;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.util.CloneUtils;
import com.tibbo.aggregate.common.util.Element;
import com.tibbo.aggregate.common.util.ElementList;
import com.tibbo.aggregate.common.util.StringUtils;
import com.tibbo.aggregate.common.util.Util;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SimpleDataTable
extends AbstractDataTable
implements Comparable<DataTable>,
Cloneable {
    public static final DataTable EMPTY_TABLE = new SimpleDataTable(TableFormat.EMPTY_FORMAT).makeImmutable();
    private List<DataRecord> records = new ArrayList<DataRecord>();

    public SimpleDataTable() {
    }

    public SimpleDataTable(TableFormat format) {
        this.setFormat(format);
    }

    public SimpleDataTable(TableFormat format, int emptyRecords) {
        this(format);
        for (int i = 0; i < emptyRecords; ++i) {
            this.addRecord();
        }
    }

    public SimpleDataTable(TableFormat format, boolean createEmptyRecords) {
        this(format, createEmptyRecords ? (format != null ? format.getMinRecords() : 0) : 0);
    }

    public SimpleDataTable(DataRecord record) {
        this();
        this.addRecord(record);
    }

    public SimpleDataTable(TableFormat format, String dataString, ClassicEncodingSettings settings) throws DataTableException {
        if (dataString == null) {
            throw new NullPointerException("Data string is null");
        }
        this.setFormat(format);
        LinkedList<String> fieldNames = null;
        ElementList recs = StringUtils.elements(dataString, false);
        for (Element el : recs) {
            if ("N".equals(el.getName())) {
                if (fieldNames == null) {
                    fieldNames = new LinkedList<String>();
                }
                fieldNames.add(el.getValue());
                continue;
            }
            if ("R".equals(el.getName())) {
                this.addRecord(new DataRecord(this.getFormat(), el.getValue(), settings, true, fieldNames));
                continue;
            }
            this.decodeAdvancedElement(el, settings);
        }
    }

    public SimpleDataTable(TableFormat format, Object ... firstRowData) {
        this(format);
        if (firstRowData.length > 0) {
            this.addRecord(new DataRecord(format, firstRowData));
        }
    }

    public SimpleDataTable(String data) throws DataTableException {
        this(data, true);
    }

    public SimpleDataTable(String data, boolean validate) throws DataTableException {
        this(data, new ClassicEncodingSettings(false), validate);
    }

    public SimpleDataTable(String data, ClassicEncodingSettings settings, boolean validate) throws DataTableException {
        this(data != null ? StringUtils.elements(data, settings != null && settings.isUseVisibleSeparators()) : null, settings, validate);
    }

    public SimpleDataTable(ElementList elements, ClassicEncodingSettings settings, boolean validate) throws DataTableException {
        this.accomplishConstruction(elements, settings, validate);
    }

    @Override
    public Integer getRecordCount() {
        return this.records.size();
    }

    private void checkOrSetFormat(DataRecord record) {
        if (this.format.getFieldCount() != 0) {
            String message;
            if (this.format != record.getFormat() && (message = record.getFormat().extendMessage(this.format)) != null) {
                throw new IllegalArgumentException("Format of new record ('" + record.getFormat() + "') differs from format of data table ('" + this.getFormat() + "'): " + message);
            }
        } else {
            this.ensureMutable();
            this.format = record.getFormat();
        }
    }

    @Override
    public void setId(Long id) {
        this.ensureMutable();
        this.id = id;
    }

    @Override
    public DataTable addRecord(DataRecord record) {
        this.checkOrSetFormat(record);
        this.addRecordImpl(null, record);
        return this;
    }

    @Override
    public DataRecord addRecord(Object ... fieldValues) {
        DataRecord rec = this.addRecord();
        for (Object value : fieldValues) {
            rec.addValue(value);
        }
        return rec;
    }

    @Override
    public DataTable addRecord(int index, DataRecord record) {
        this.checkOrSetFormat(record);
        this.addRecordImpl(index, record);
        return this;
    }

    @Override
    public DataRecord addRecord() {
        if (this.getFormat() == null) {
            throw new IllegalStateException("Can't add empty record because format of data table was not set");
        }
        DataRecord record = new DataRecord(this.getFormat());
        this.addRecordImpl(null, record);
        return record;
    }

    private void addRecordImpl(Integer index, DataRecord record) {
        this.ensureMutable();
        if (this.getRecordCount() >= this.format.getMaxRecords()) {
            throw new IllegalStateException(Cres.get().getString("dtCannotAddRecord") + "maximum number of records is reached: " + this.format.getMaxRecords());
        }
        try {
            this.validateRecord(record);
        }
        catch (ValidationException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
        if (index != null) {
            this.records.add(index, record);
        } else {
            this.records.add(record);
        }
        record.setTable(this);
    }

    @Override
    public DataTable setRecord(int index, DataRecord record) {
        this.ensureMutable();
        this.checkOrSetFormat(record);
        this.records.get(index).setTable(null);
        this.records.set(index, record);
        record.setTable(this);
        return this;
    }

    @Override
    public void swapRecords(int index1, int index2) {
        this.ensureMutable();
        DataRecord r1 = this.records.get(index1);
        DataRecord r2 = this.records.get(index2);
        this.records.set(index1, r2);
        this.records.set(index2, r1);
    }

    @Override
    public List<DataRecord> getRecords() {
        return Collections.unmodifiableList(this.records);
    }

    @Override
    public DataRecord getRecord(int number) {
        return this.records.get(number);
    }

    @Override
    protected DataRecord removeRecordImpl(int index) {
        this.ensureMutable();
        if (this.getRecordCount() <= this.format.getMinRecords()) {
            throw new IllegalStateException("Cannot remove record: minimum number of records is reached: " + this.format.getMinRecords());
        }
        return this.records.remove(index);
    }

    @Override
    public void removeRecordsByIds(Collection<String> ids) {
        this.ensureMutable();
        this.records = this.records.stream().filter(it -> !ids.contains(it.getId())).collect(Collectors.toList());
    }

    @Override
    public void removeRecords(DataRecord rec) {
        for (int i = this.records.size() - 1; i >= 0; --i) {
            if (!Util.equals(rec, this.records.get(i))) continue;
            this.removeRecordImpl(i);
        }
    }

    @Override
    public void reorderRecord(DataRecord record, int index) {
        this.ensureMutable();
        int oi = this.records.indexOf(record);
        if (oi == -1) {
            throw new IllegalStateException("Record is not from this table");
        }
        if (this.records.remove(record)) {
            this.records.add(index - (oi < index ? 1 : 0), record);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleDataTable)) {
            return false;
        }
        SimpleDataTable other = (SimpleDataTable)obj;
        if (!this.format.equals(other.getFormat())) {
            return false;
        }
        if (!this.getRecordCount().equals(other.getRecordCount())) {
            return false;
        }
        if (!Util.equals(this.quality, other.quality)) {
            return false;
        }
        for (int i = 0; i < this.getRecordCount(); ++i) {
            if (this.getRecord(i).equals(other.getRecord(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
        result = 31 * result + (this.records == null ? 0 : this.records.hashCode());
        result = 31 * result + (this.quality == null ? 0 : this.quality.hashCode());
        return result;
    }

    @Override
    void getEncodedRecordsOrTableID(StringBuilder finalSB, ClassicEncodingSettings settings, Boolean isTransferEncode, Integer encodeLevel) {
        for (int i = 0; i < this.getRecordCount(); ++i) {
            new Element("R", this.getRecord(i)).encode(finalSB, settings, isTransferEncode, encodeLevel);
        }
    }

    @Override
    int getEstimateDataSize() {
        return this.getFieldCount() * this.getRecordCount() * 3 + this.getFieldCount() * 7;
    }

    @Override
    public String toDefaultString() {
        if (this.getRecordCount() == 1) {
            return this.dataAsString();
        }
        return MessageFormat.format(Cres.get().getString("dtTable"), this.getRecordCount());
    }

    @Override
    public String dataAsString(boolean showFieldNames, boolean showHiddenFields, boolean showPasswords) {
        StringBuffer res = new StringBuffer();
        String recordSeparator = this.getFieldCount() > 1 ? " | " : ", ";
        for (int i = 0; i < this.getRecordCount(); ++i) {
            if (i > 0) {
                res.append(recordSeparator);
            }
            DataRecord rec = this.getRecord(i);
            res.append(rec.dataAsString(showFieldNames, showHiddenFields, showPasswords));
        }
        return res.toString();
    }

    @Override
    public boolean isOneCellTable() {
        return this.getFieldCount() == 1 && this.getRecordCount() == 1;
    }

    @Override
    public String conformMessage(TableFormat rf) {
        if (this.getRecordCount() < rf.getMinRecords()) {
            return "Number of records too small: need " + rf.getMinRecords() + " or more, found " + this.getRecordCount();
        }
        if (this.getRecordCount() > rf.getMaxRecords()) {
            return "Number of records too big: need " + rf.getMaxRecords() + " or less, found " + this.getRecordCount();
        }
        return this.getFormat().extendMessage(rf);
    }

    @Override
    public Integer findIndex(DataTableQuery query) {
        for (int i = 0; i < this.getRecordCount(); ++i) {
            boolean meet = true;
            DataRecord rec = this.getRecord(i);
            for (QueryCondition cond : query.getConditions()) {
                if (rec.meetToCondition(cond)) continue;
                meet = false;
            }
            if (!meet) continue;
            return i;
        }
        return null;
    }

    @Override
    public void sort(DataTableSorter sorter) {
        this.ensureMutable();
        DataTableSorter adjustedSorter = sorter.fitTo(this.getFormat());
        if (adjustedSorter.isEmpty()) {
            return;
        }
        Collections.sort(this.records, (r1, r2) -> {
            for (SortOrder order : adjustedSorter) {
                int res;
                Object v1 = this.getComparableValue((DataRecord)r1, order.getField(), this.format);
                Object v2 = this.getComparableValue((DataRecord)r2, order.getField(), this.format);
                if (v1 == null && v2 != null) {
                    return order.isAscending() ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                }
                if (v2 == null && v1 != null) {
                    return order.isAscending() ? Integer.MAX_VALUE : Integer.MIN_VALUE;
                }
                if (!(v1 instanceof Comparable) || !(v2 instanceof Comparable) || (res = ((Comparable)v1).compareTo(v2)) == 0) continue;
                return order.isAscending() ? res : -res;
            }
            return 0;
        });
    }

    @Override
    public void sort(Comparator<DataRecord> comparator) {
        this.ensureMutable();
        Collections.sort(this.records, comparator);
    }

    @Override
    public Object get() {
        return this.getRecord(0).getValue(0);
    }

    @Override
    public void splitFormat() {
        for (DataRecord rec : this.records) {
            rec.cloneFormatFromTable();
        }
    }

    @Override
    public void joinFormats() {
        for (DataRecord rec : this.records) {
            rec.setFormat(this.getFormat());
        }
    }

    @Override
    public Iterator<DataRecord> iterator() {
        return new Iter();
    }

    @Override
    public Iterator<DataRecord> iterator(int index) {
        return new Iter(index);
    }

    @Override
    public DataTable clone() {
        SimpleDataTable cl = (SimpleDataTable)super.clone();
        cl.records = (List)CloneUtils.deepClone(this.records);
        for (DataRecord rec : cl.records) {
            rec.setTable(cl);
        }
        cl.namingEvaluator = null;
        cl.immutable = false;
        return cl;
    }

    @Override
    public int compareTo(DataTable other) {
        return this.dataAsString().compareTo(other.dataAsString());
    }

    @Override
    public DataTable makeImmutable() {
        if (this.immutable) {
            return this;
        }
        this.immutable = true;
        this.format.makeImmutable(this);
        this.makeSubtablesImmutable();
        return this;
    }

    private void makeSubtablesImmutable() {
        if (this.getRecordCount() == 0) {
            return;
        }
        ArrayList<Integer> dataTableFields = new ArrayList<Integer>();
        for (int i = 0; i < this.format.getFieldCount(); ++i) {
            FieldFormat field = this.format.getField(i);
            if (field.getType() != 'T') continue;
            dataTableFields.add(i);
        }
        if (dataTableFields.isEmpty()) {
            return;
        }
        for (DataRecord record : this.records) {
            for (Integer index : dataTableFields) {
                DataTable dataTable = record.getDataTable(index);
                if (dataTable == null) continue;
                dataTable.makeImmutable();
            }
        }
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public Stream<DataRecord> stream() {
        return this.records.stream();
    }

    private Object getComparableValue(DataRecord record, String fieldName, TableFormat format) {
        Object straightValue = record.getValue(fieldName);
        FieldFormat field = format.getField(fieldName);
        if (!field.hasSelectionValues()) {
            return straightValue;
        }
        String value = field.getSelectionValues().get(straightValue);
        return value != null ? value : (field.isExtendableSelectionValues() ? straightValue.toString() : null);
    }

    private class Iter
    implements Iterator<DataRecord> {
        private final Iterator<DataRecord> recsIter;
        private DataRecord rec;

        Iter() {
            this.recsIter = SimpleDataTable.this.records.iterator();
        }

        Iter(int index) {
            this.recsIter = SimpleDataTable.this.records.listIterator(index);
        }

        @Override
        public boolean hasNext() {
            return this.recsIter.hasNext();
        }

        @Override
        public DataRecord next() {
            this.rec = this.recsIter.next();
            return this.rec;
        }

        @Override
        public void remove() {
            SimpleDataTable.this.ensureMutable();
            this.recsIter.remove();
            if (this.rec != null) {
                this.rec.setTable(null);
            }
        }
    }
}

