/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable;

import com.tibbo.aggregate.common.AggreGateRuntimeException;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.data.Data;
import com.tibbo.aggregate.common.datatable.AbstractBigDataTable;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableException;
import com.tibbo.aggregate.common.datatable.DataTableQuery;
import com.tibbo.aggregate.common.datatable.DataTableSorter;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.QueryCondition;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.ValidationException;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.query.DataTableWrappingUtils;
import com.tibbo.aggregate.common.query.FieldDescriptor;
import com.tibbo.aggregate.common.sql.DataTableSqlHelper;
import com.tibbo.aggregate.common.util.Element;
import com.tibbo.aggregate.common.util.Util;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.rowset.serial.SerialBlob;

public class ResultSetDataTable
extends AbstractBigDataTable {
    private static final String ERROR_WITH_RESULT_SET = "An error occurred while working with result set: ";
    private final ResultSet resultSet;
    private final Map<String, FieldDescriptor> fields;
    private boolean scrollable;
    private boolean ownDeletesAreVisible;
    private boolean ownInsertsAreVisible;
    private boolean ownUpdatesAreVisible;
    private boolean alreadyWarnedAboutDeletes;
    private boolean alreadyWarnedAboutInserts;
    private boolean alreadyWarnedAboutUpdates;

    public ResultSetDataTable(ResultSet resultSet) {
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet must not be null");
        }
        this.resultSet = resultSet;
        try {
            this.fields = DataTableWrappingUtils.extractResultSetFields(resultSet, false);
            this.setFormat(DataTableSqlHelper.createTableFormat(this.fields.values(), null));
        }
        catch (SQLException exc) {
            throw new AggreGateRuntimeException("An error occurred while trying to create table format from result set: ", exc);
        }
        this.setImmutableStatus();
        this.setScrollableStatus();
        try {
            DatabaseMetaData dbMetaData = null;
            if (resultSet.getStatement() != null && resultSet.getStatement().getConnection() != null) {
                dbMetaData = resultSet.getStatement().getConnection().getMetaData();
            }
            this.setOwnChangesAreVisibleStatuses(dbMetaData);
        }
        catch (SQLException exc) {
            Log.DATATABLE.warn((Object)("Could not get the database metadata: " + exc.getMessage()));
        }
    }

    private void setImmutableStatus() {
        this.immutable = true;
        try {
            if (this.resultSet.getConcurrency() == 1008) {
                this.immutable = false;
            }
        }
        catch (SQLException exc) {
            Log.DATATABLE.error((Object)"Could not get the concurrency of result set; immutable is set to true ", (Throwable)exc);
        }
    }

    private void setScrollableStatus() {
        this.scrollable = false;
        try {
            if (this.resultSet.getType() == 1004 || this.resultSet.getType() == 1005) {
                this.scrollable = true;
            }
        }
        catch (SQLException exc) {
            Log.DATATABLE.error((Object)"Could not get the type of result set; scrollable is set to false ", (Throwable)exc);
        }
    }

    private void setOwnChangesAreVisibleStatuses(DatabaseMetaData dbMetaData) {
        if (dbMetaData == null) {
            return;
        }
        this.setOwnDeletesAreVisibleStatus(dbMetaData);
        this.setOwnInsertsAreVisibleStatus(dbMetaData);
        this.setOwnUpdatesAreVisibleStatus(dbMetaData);
    }

    private void setOwnDeletesAreVisibleStatus(DatabaseMetaData dbMetaData) {
        this.ownDeletesAreVisible = false;
        try {
            this.ownDeletesAreVisible = dbMetaData.ownDeletesAreVisible(this.resultSet.getType());
        }
        catch (SQLException exc) {
            Log.DATATABLE.error((Object)"Could not get the type of result set; ownDeletesAreVisible is set to false ", (Throwable)exc);
        }
    }

    private void setOwnInsertsAreVisibleStatus(DatabaseMetaData dbMetaData) {
        this.ownInsertsAreVisible = false;
        try {
            this.ownInsertsAreVisible = dbMetaData.ownInsertsAreVisible(this.resultSet.getType());
        }
        catch (SQLException exc) {
            Log.DATATABLE.error((Object)"Could not get the type of result set; ownInsertsAreVisible is set to false ", (Throwable)exc);
        }
    }

    private void setOwnUpdatesAreVisibleStatus(DatabaseMetaData dbMetaData) {
        this.ownUpdatesAreVisible = false;
        try {
            this.ownUpdatesAreVisible = dbMetaData.ownUpdatesAreVisible(this.resultSet.getType());
        }
        catch (SQLException exc) {
            Log.DATATABLE.error((Object)"Could not get the type of result set; ownUpdatesAreVisible is set to false ", (Throwable)exc);
        }
    }

    @Override
    public DataTable addRecord(DataRecord record) {
        this.ensureMutable();
        this.ensureScrollable();
        this.checkIfOwnInsertsAreVisible();
        try {
            int initialPosition = this.resultSet.getRow();
            this.resultSet.moveToInsertRow();
            this.update(record);
            this.resultSet.insertRow();
            this.commitIfNeeded();
            this.incrementRecordCount();
            this.resultSet.absolute(initialPosition);
        }
        catch (SQLException exc) {
            throw new AggreGateRuntimeException(ERROR_WITH_RESULT_SET, exc);
        }
        return this;
    }

    @Override
    public void splitFormat() {
    }

    @Override
    public DataRecord addRecord(Object ... fieldValues) {
        DataRecord record = new DataRecord(this.format, fieldValues);
        this.addRecord(record);
        return record;
    }

    @Override
    public DataTable addRecord(int index, DataRecord record) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    @Override
    public DataRecord addRecord() {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    private void update(DataRecord record) throws SQLException {
        try {
            this.validateRecord(record);
        }
        catch (ValidationException exc) {
            throw new IllegalStateException(exc.getMessage(), exc);
        }
        for (int fieldIndex = 0; fieldIndex < this.format.getFieldCount(); ++fieldIndex) {
            FieldFormat ff = record.getFormat().getField(fieldIndex);
            this.assertHasField(ff);
            String columnName = this.fields.get(fieldIndex).getColumnName();
            Object value = record.getValue(ff.getName());
            if (value == null) {
                this.resultSet.updateNull(columnName);
                return;
            }
            this.updateDependingOnType(ff.getType(), columnName, value);
        }
    }

    private void updateDependingOnType(char fieldType, String columnName, Object value) throws SQLException {
        switch (fieldType) {
            case 'D': {
                Date date = (Date)value;
                this.resultSet.updateTimestamp(columnName, new Timestamp(date.getTime()));
                break;
            }
            case 'A': {
                byte[] data = ((Data)value).getData();
                if (data != null) {
                    this.resultSet.updateBlob(columnName, (Blob)new SerialBlob(data));
                    break;
                }
                Log.DATATABLE.warn((Object)("The BLOB at field " + columnName + " was not updated because the data object is null"));
                break;
            }
            case 'T': {
                DataTable dataTable = (DataTable)value;
                this.resultSet.updateObject(columnName, (Object)dataTable.encode(false));
                break;
            }
            default: {
                this.resultSet.updateObject(columnName, value);
            }
        }
    }

    private void assertHasField(FieldFormat ff) {
        String fieldName = ff.getName();
        if (!this.format.hasField(fieldName)) {
            throw new IllegalArgumentException("There is no such field in the data table: " + fieldName);
        }
        if (!this.format.getField(fieldName).equals(ff)) {
            throw new IllegalArgumentException("The field format of field " + fieldName + " of the record being added does not match the field format of the field with the same name in the data table");
        }
    }

    @Override
    protected DataRecord removeRecordImpl(int index) {
        this.ensureMutable();
        this.ensureScrollable();
        this.checkIfOwnDeletesAreVisible();
        try {
            int initialPosition = this.resultSet.getRow();
            this.resultSet.absolute(index + 1);
            DataRecord record = this.getCurrentRecord();
            this.resultSet.deleteRow();
            this.commitIfNeeded();
            this.decrementRecordCount();
            this.resultSet.absolute(initialPosition);
            return record;
        }
        catch (SQLException exc) {
            throw new AggreGateRuntimeException(ERROR_WITH_RESULT_SET, exc);
        }
    }

    private void ensureScrollable() {
        if (!this.scrollable) {
            throw new IllegalStateException("The resultSet that this data table is based on is not scrollable; hence, only one iteration is permitted and the cursor cannot be set to an arbitrary index");
        }
    }

    private void checkIfOwnDeletesAreVisible() {
        if (!this.alreadyWarnedAboutDeletes && !this.ownDeletesAreVisible) {
            Log.DATATABLE.warn((Object)"The database meta data indicate that result set own deletes are not visible. Depending on the database engine / JDBC driver used it may mean that this data table will not reflect changes caused by the remove method.");
            this.alreadyWarnedAboutDeletes = true;
        }
    }

    private void checkIfOwnInsertsAreVisible() {
        if (!this.alreadyWarnedAboutInserts && !this.ownInsertsAreVisible) {
            Log.DATATABLE.warn((Object)"The database meta data indicate that result set own inserts are not visible. Depending on the database engine / JDBC driver used it may mean that this data table will not reflect changes caused by the setRecord method.");
            this.alreadyWarnedAboutInserts = true;
        }
    }

    private void checkIfOwnUpdatesAreVisible() {
        if (!this.alreadyWarnedAboutUpdates && !this.ownUpdatesAreVisible) {
            Log.DATATABLE.warn((Object)"The database meta data indicate that result set own updates are not visible. Depending on the database engine / JDBC driver used it may mean that this data table will not reflect changes caused by the addRecord methods.");
            this.alreadyWarnedAboutUpdates = true;
        }
    }

    private void commitIfNeeded() throws SQLException {
        if (this.resultSet.getStatement() == null || this.resultSet.getStatement().getConnection() == null) {
            return;
        }
        if (!this.resultSet.getStatement().getConnection().getAutoCommit()) {
            this.resultSet.getStatement().getConnection().commit();
        }
    }

    @Override
    public void validate(Context context, ContextManager contextManager, CallerController caller) throws DataTableException {
        this.ensureScrollable();
        super.validate(context, contextManager, caller);
    }

    @Override
    public DataTable setRecord(int index, DataRecord record) {
        this.ensureMutable();
        this.ensureScrollable();
        this.checkIfOwnUpdatesAreVisible();
        try {
            int initialPosition = this.resultSet.getRow();
            this.resultSet.absolute(index + 1);
            record.setTable(this);
            this.update(record);
            this.resultSet.updateRow();
            this.commitIfNeeded();
            this.resultSet.absolute(initialPosition);
            return this;
        }
        catch (SQLException exc) {
            throw new AggreGateRuntimeException(ERROR_WITH_RESULT_SET, exc);
        }
    }

    @Override
    public DataRecord getRecord(int number) {
        this.ensureScrollable();
        try {
            int initialPosition = this.resultSet.getRow();
            this.resultSet.absolute(number + 1);
            DataRecord result = this.getCurrentRecord();
            this.resultSet.absolute(initialPosition);
            return result;
        }
        catch (SQLException exc) {
            throw new AggreGateRuntimeException(ERROR_WITH_RESULT_SET, exc);
        }
    }

    @Override
    public void removeRecords(DataRecord rec) {
        this.ensureMutable();
        this.ensureScrollable();
        this.checkIfOwnDeletesAreVisible();
        try {
            int initialPosition = this.resultSet.getRow();
            this.resultSet.beforeFirst();
            while (this.resultSet.next()) {
                DataRecord currentRecord = this.getCurrentRecord();
                if (!currentRecord.equals(rec)) continue;
                this.resultSet.deleteRow();
                this.decrementRecordCount();
            }
            this.commitIfNeeded();
            this.resultSet.absolute(initialPosition);
        }
        catch (SQLException exc) {
            throw new AggreGateRuntimeException(ERROR_WITH_RESULT_SET, exc);
        }
    }

    @Override
    public void reorderRecord(DataRecord record, int index) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ResultSetDataTable)) {
            return false;
        }
        ResultSetDataTable other = (ResultSetDataTable)obj;
        if (!this.resultSet.equals(other.resultSet)) {
            return false;
        }
        return Util.equals(this.quality, other.quality);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.resultSet == null ? 0 : this.resultSet.hashCode());
        result = 31 * result + (this.quality == null ? 0 : this.quality.hashCode());
        return result;
    }

    @Override
    void getEncodedRecordsOrTableID(StringBuilder finalSB, ClassicEncodingSettings settings, Boolean isTransferEncode, Integer encodeLevel) {
        if (this.id != null) {
            new Element("C", String.valueOf(this.id)).encode(finalSB, settings, isTransferEncode, encodeLevel);
        }
    }

    @Override
    public String toDefaultString() {
        return "Result set data table with format: " + this.format.toString();
    }

    @Override
    public String dataAsString(boolean showFieldNames, boolean showHiddenFields, boolean showPasswords) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    @Override
    public boolean isOneCellTable() {
        this.ensureScrollable();
        try {
            int initialPosition = this.resultSet.getRow();
            boolean result = this.getFieldCount() == 1 && this.resultSet.absolute(1) && !this.resultSet.absolute(2);
            this.resultSet.absolute(initialPosition);
            return result;
        }
        catch (SQLException exc) {
            throw new AggreGateRuntimeException("An error occurred while attempting to set the cursor of result set", exc);
        }
    }

    @Override
    public List<DataRecord> selectAll(DataTableQuery query) {
        this.ensureScrollable();
        try {
            int initialPosition = this.resultSet.getRow();
            List<DataRecord> result = super.selectAll(query);
            this.resultSet.absolute(initialPosition);
            return result;
        }
        catch (SQLException exc) {
            throw new AggreGateRuntimeException(ERROR_WITH_RESULT_SET, exc);
        }
    }

    @Override
    public Integer findIndex(DataTableQuery query) {
        this.ensureScrollable();
        try {
            int initialPosition = this.resultSet.getRow();
            int index = 0;
            for (DataRecord record : this) {
                boolean meet = true;
                for (QueryCondition cond : query.getConditions()) {
                    if (record.meetToCondition(cond)) continue;
                    meet = false;
                }
                if (meet) {
                    this.resultSet.absolute(initialPosition);
                    return index;
                }
                ++index;
            }
            this.resultSet.absolute(initialPosition);
            return null;
        }
        catch (SQLException exc) {
            throw new AggreGateRuntimeException(ERROR_WITH_RESULT_SET, exc);
        }
    }

    @Override
    public void sort(DataTableSorter sorter) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    @Override
    public void sort(Comparator<DataRecord> comparator) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    @Override
    public Iterator<DataRecord> iterator() {
        return new Iter();
    }

    @Override
    public Iterator<DataRecord> iterator(int index) {
        return new Iter(index);
    }

    private DataRecord getCurrentRecord() throws SQLException {
        return DataTableSqlHelper.populateRecord(this.resultSet, this.fields.values(), this.format);
    }

    @Override
    public DataTable clone() {
        SimpleDataTable clone;
        try {
            int initialPosition = this.resultSet.getRow();
            if (!this.resultSet.isBeforeFirst()) {
                if (this.scrollable) {
                    this.resultSet.beforeFirst();
                } else {
                    throw new IllegalStateException("The cursor of the result set is in the proper position and the result set is not scrollable which makes it impossible to reset its cursor position");
                }
            }
            clone = this.toSimpleDataTable();
            this.resultSet.absolute(initialPosition);
        }
        catch (SQLException exc) {
            throw new AggreGateRuntimeException(ERROR_WITH_RESULT_SET, exc);
        }
        clone.namingEvaluator = null;
        clone.immutable = false;
        if (Log.DATATABLE.isDebugEnabled()) {
            Log.DATATABLE.debug((Object)("The clone method was called; a SimpleDataTable copy of this ResultSetDataTable was created: " + clone));
        }
        return clone;
    }

    private ResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public void close() {
        if (this.getResultSet() != null) {
            ResultSet resultSet = this.getResultSet();
            try {
                Connection connection;
                Statement stmt = resultSet.getStatement();
                Connection connection2 = connection = stmt != null && !stmt.isClosed() ? stmt.getConnection() : null;
                if (!resultSet.isClosed()) {
                    resultSet.getStatement().close();
                    resultSet.close();
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            catch (SQLException e) {
                Log.DATATABLE.warn((Object)e.getMessage(), (Throwable)e);
                throw new AggreGateRuntimeException("An error occurred while attempting to close the result set");
            }
        }
    }

    private class Iter
    implements Iterator<DataRecord> {
        private DataRecord record;
        private int localCount;

        Iter() {
            try {
                if (ResultSetDataTable.this.scrollable && !ResultSetDataTable.this.resultSet.isBeforeFirst()) {
                    ResultSetDataTable.this.resultSet.beforeFirst();
                }
            }
            catch (SQLException exc) {
                throw new AggreGateRuntimeException(ResultSetDataTable.ERROR_WITH_RESULT_SET, exc);
            }
            this.localCount = 0;
        }

        Iter(int index) {
            ResultSetDataTable.this.ensureScrollable();
            try {
                ResultSetDataTable.this.resultSet.absolute(index);
            }
            catch (SQLException exc) {
                throw new AggreGateRuntimeException("An error occurred while attempting to set the cursor of result set");
            }
            this.localCount = index;
        }

        @Override
        public boolean hasNext() {
            try {
                if (!ResultSetDataTable.this.resultSet.isLast()) {
                    return true;
                }
                ResultSetDataTable.this.setRecordCount(this.localCount);
                return false;
            }
            catch (SQLException exc) {
                throw new AggreGateRuntimeException(ResultSetDataTable.ERROR_WITH_RESULT_SET, exc);
            }
        }

        @Override
        public DataRecord next() {
            try {
                ResultSetDataTable.this.resultSet.next();
                this.record = ResultSetDataTable.this.getCurrentRecord();
                ++this.localCount;
            }
            catch (SQLException exc) {
                throw new AggreGateRuntimeException(ResultSetDataTable.ERROR_WITH_RESULT_SET, exc);
            }
            return this.record;
        }

        @Override
        public void remove() {
            try {
                ResultSetDataTable.this.ensureMutable();
                ResultSetDataTable.this.checkIfOwnDeletesAreVisible();
                ResultSetDataTable.this.resultSet.deleteRow();
                --this.localCount;
            }
            catch (SQLException exc) {
                throw new AggreGateRuntimeException("An error occurred when trying to delete a row from result set: ", exc);
            }
            if (this.record != null) {
                this.record.setTable(null);
            }
        }
    }
}

