/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable;

import com.tibbo.aggregate.common.AggreGateRuntimeException;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.datatable.AbstractUnmodifiableDataTable;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableException;
import com.tibbo.aggregate.common.datatable.DataTableQuery;
import com.tibbo.aggregate.common.datatable.QueryCondition;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.protocol.AggreGateDeviceController;
import com.tibbo.aggregate.common.util.ElementList;
import com.tibbo.aggregate.common.util.Util;
import com.tibbo.aggregate.common.view.StorageHelper;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class ProxyDataTable
extends AbstractUnmodifiableDataTable {
    private static final int DEFAULT_BATCH_SIZE = 100;
    private final Cache cache;
    private Context functionContext;

    public ProxyDataTable(ElementList elements, ClassicEncodingSettings settings, boolean validate, AggreGateDeviceController controller) throws DataTableException {
        this.accomplishConstruction(elements, settings, validate);
        if (this.id == null) {
            throw new IllegalStateException("Table id must not be null");
        }
        if (controller != null) {
            this.functionContext = controller.getContextManager().getRoot();
            if (this.functionContext == null) {
                throw new IllegalStateException("functionContext must not be null");
            }
        }
        this.cache = new Cache();
        this.makeImmutable();
    }

    @Override
    public void setId(Long id) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    @Override
    public void splitFormat() {
    }

    @Override
    public DataRecord getRecord(int number) {
        DataRecord record = this.cache.get(number);
        return record != null ? record : this.loadRecord(number);
    }

    private DataRecord loadRecord(int number) {
        DataTable result;
        SimpleDataTable parameters = new SimpleDataTable(StorageHelper.FIFT_STORAGE_GET, this.id, null, number, 100);
        try {
            result = this.functionContext.callFunction("storageGet", parameters);
        }
        catch (ContextException exc) {
            throw new AggreGateRuntimeException("An error occurred when calling function: ", exc);
        }
        Integer size = result.rec().getInt("size");
        if (size == null) {
            throw new IndexOutOfBoundsException("Record index is out of bounds");
        }
        this.fillCache(number, result.rec().getDataTable("data"));
        return result.rec().getDataTable("data").rec();
    }

    private void fillCache(int fromIndex, DataTable data) {
        int currentIndex = fromIndex;
        for (DataRecord record : data) {
            this.cache.put(currentIndex++, record);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ProxyDataTable)) {
            return false;
        }
        ProxyDataTable other = (ProxyDataTable)obj;
        if (!this.id.equals(other.getId())) {
            return false;
        }
        if (!this.format.equals(other.getFormat())) {
            return false;
        }
        return Util.equals(this.quality, other.quality);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
        result = 31 * result + (this.quality == null ? 0 : this.quality.hashCode());
        return result;
    }

    @Override
    void getEncodedRecordsOrTableID(StringBuilder finalSB, ClassicEncodingSettings settings, Boolean isTransferEncode, Integer encodeLevel) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    @Override
    public String toDefaultString() {
        return "Proxy data table with format: " + this.format.toString();
    }

    @Override
    public String dataAsString(boolean showFieldNames, boolean showHiddenFields, boolean showPasswords) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    @Override
    public boolean isOneCellTable() {
        if (this.getFieldCount() != 1) {
            return false;
        }
        boolean zerothRecordExists = true;
        try {
            this.rec();
        }
        catch (IndexOutOfBoundsException exc) {
            zerothRecordExists = false;
        }
        if (!zerothRecordExists) {
            return false;
        }
        try {
            this.getRecord(1);
        }
        catch (IndexOutOfBoundsException exc) {
            return true;
        }
        return false;
    }

    @Override
    public Integer findIndex(DataTableQuery query) {
        int index = 0;
        for (DataRecord record : this) {
            boolean meet = true;
            for (QueryCondition cond : query.getConditions()) {
                if (record.meetToCondition(cond)) continue;
                meet = false;
            }
            if (meet) {
                return index;
            }
            ++index;
        }
        return null;
    }

    @Override
    public Iterator<DataRecord> iterator() {
        return new Iter();
    }

    @Override
    public Iterator<DataRecord> iterator(int index) {
        return new Iter(index);
    }

    public Context getFunctionContext() {
        return this.functionContext;
    }

    public void setFunctionContext(Context functionContext) {
        this.functionContext = functionContext;
    }

    @Override
    public void close() {
        try {
            this.functionContext.callFunction("storageClose", new SimpleDataTable(StorageHelper.FIFT_STORAGE_CLOSE, this.id));
        }
        catch (ContextException exc) {
            throw new AggreGateRuntimeException("An error occurred when calling function: ", exc);
        }
    }

    private static class Cache {
        private final Map<Integer, SoftReference<DataRecord>> map = new HashMap<Integer, SoftReference<DataRecord>>(100);

        private Cache() {
        }

        private DataRecord get(Integer key) {
            SoftReference<DataRecord> softRef = this.map.get(key);
            if (softRef == null) {
                return null;
            }
            return softRef.get();
        }

        private DataRecord put(Integer key, DataRecord value) {
            SoftReference<DataRecord> softRef = this.map.put(key, new SoftReference<DataRecord>(value));
            if (softRef == null) {
                return null;
            }
            DataRecord oldValue = softRef.get();
            softRef.clear();
            return oldValue;
        }

        private DataRecord remove(Integer key) {
            SoftReference<DataRecord> softRef = this.map.remove(key);
            if (softRef == null) {
                return null;
            }
            DataRecord oldValue = softRef.get();
            softRef.clear();
            return oldValue;
        }
    }

    private class Iter
    implements Iterator<DataRecord> {
        private int index;
        private DataRecord nextRecord;
        private boolean isNextRecordSet;

        Iter() {
            this.index = 0;
        }

        Iter(int index) {
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            if (this.isNextRecordSet || this.setNextRecord()) {
                return true;
            }
            ProxyDataTable.this.setRecordCount(this.index);
            return false;
        }

        @Override
        public DataRecord next() {
            if (!this.isNextRecordSet && !this.setNextRecord()) {
                throw new NoSuchElementException();
            }
            this.isNextRecordSet = false;
            return this.nextRecord;
        }

        private boolean setNextRecord() {
            try {
                this.nextRecord = ProxyDataTable.this.getRecord(this.index);
                this.isNextRecordSet = true;
                ++this.index;
                return true;
            }
            catch (IndexOutOfBoundsException exc) {
                return false;
            }
        }
    }
}

