/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable;

import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IndexTableCache<T> {
    private SoftReference<List<T>> softIndexTable = new SoftReference(new ArrayList());
    private final DataTable dataTable;

    public IndexTableCache(DataTable dataTable) {
        this.dataTable = dataTable;
    }

    public List<T> getIndexTable() {
        ArrayList indexTable = this.softIndexTable.get();
        return indexTable != null ? indexTable : new ArrayList();
    }

    public void setSoftIndexTable(List<T> indexTable) {
        this.softIndexTable = new SoftReference<List<List<T>>>(indexTable);
    }

    public boolean isIndexTableComplete(List<T> indexTable, Integer recordCount) {
        return recordCount != null && indexTable != null && indexTable.size() == recordCount.intValue();
    }

    public void ensureNotDefinitelyInvalid(int index) {
        Integer recordCount;
        List<T> indexTable = this.softIndexTable.get();
        if (this.isIndexTableComplete(indexTable, recordCount = this.dataTable.getRecordCount()) && index >= recordCount) {
            throw new IndexOutOfBoundsException("The given index: " + index + " exceeds the number of records in this Data Table: " + recordCount);
        }
    }

    public DataRecord iterateThroughSourceUpToNumber(int number, List<T> indexTable) {
        Iterator<DataRecord> iter;
        int currentMaxIndexInThisDataTable = indexTable.size() - 1;
        Iterator<DataRecord> iterator = iter = currentMaxIndexInThisDataTable != -1 ? this.dataTable.iterator(currentMaxIndexInThisDataTable + 1) : this.dataTable.iterator();
        while (iter.hasNext()) {
            DataRecord record = iter.next();
            if (++currentMaxIndexInThisDataTable != number) continue;
            return record;
        }
        throw new IndexOutOfBoundsException("The required index is out of range");
    }

    public boolean isOneCellTable() {
        if (this.dataTable.getFieldCount() != 1) {
            return false;
        }
        Integer recordCount = this.dataTable.getRecordCount();
        if (recordCount != null && recordCount == 1) {
            return true;
        }
        if (recordCount != null) {
            return false;
        }
        List<T> indexTable = this.getIndexTable();
        int currentMaxIndexInThisDataTable = indexTable.size() - 1;
        if (currentMaxIndexInThisDataTable > 0) {
            return false;
        }
        if (currentMaxIndexInThisDataTable == 0) {
            Iterator<DataRecord> iter = this.dataTable.iterator(1);
            return !iter.hasNext();
        }
        Iterator<DataRecord> iter = this.dataTable.iterator();
        if (!iter.hasNext()) {
            return false;
        }
        iter.next();
        return !iter.hasNext();
    }
}

