/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable;

import com.tibbo.aggregate.common.datatable.AbstractUnmodifiableDataTable;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableQuery;
import com.tibbo.aggregate.common.datatable.IndexTableCache;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.expression.DefaultReferenceResolver;
import com.tibbo.aggregate.common.expression.EvaluationEnvironment;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.expression.Expression;
import com.tibbo.aggregate.common.expression.ReferenceResolver;
import com.tibbo.aggregate.common.util.Element;
import com.tibbo.aggregate.common.util.Util;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

public class FilteringDataTable
extends AbstractUnmodifiableDataTable {
    private final DataTable source;
    private final Expression filterExpression;
    private final Evaluator localEvaluator;
    private final EvaluationEnvironment localEnvironment;
    private final IndexTableCache<Integer> indexTableCache;

    public FilteringDataTable(DataTable source, Expression filterExpression, Evaluator evaluator, EvaluationEnvironment environment) {
        this.setFormat(Objects.requireNonNull(source, "Source data table must not be null").getFormat().clone().setMinRecords(0));
        source.makeImmutable();
        this.source = source;
        this.filterExpression = Objects.requireNonNull(filterExpression, "Filter expression must not be null");
        this.makeImmutable();
        if (evaluator == null) {
            DefaultReferenceResolver defaultResolver = new DefaultReferenceResolver();
            defaultResolver.setDefaultTable(source);
            this.localEvaluator = new Evaluator(defaultResolver);
        } else {
            ReferenceResolver resolver = evaluator.getDefaultResolver();
            this.localEvaluator = new Evaluator(resolver.getContextManager(), resolver.getDefaultContext(), resolver.getDefaultTable(), resolver.getCallerController());
            this.localEvaluator.getDefaultResolver().setDefaultTable(source);
        }
        this.indexTableCache = new IndexTableCache(this);
        this.localEnvironment = environment != null ? environment.clone() : null;
    }

    public FilteringDataTable(DataTable source, Expression filterExpression) {
        this(source, filterExpression, null, null);
    }

    public FilteringDataTable(DataTable source, String filterExpression) {
        this(source, new Expression(filterExpression));
    }

    public DataTable getSource() {
        return this.source;
    }

    public Expression getFilterExpression() {
        return this.filterExpression;
    }

    @Override
    public DataRecord getRecord(int number) {
        this.indexTableCache.ensureNotDefinitelyInvalid(number);
        List<Integer> indexes = this.indexTableCache.getIndexTable();
        if (number < indexes.size()) {
            return this.source.getRecord(indexes.get(number));
        }
        return this.indexTableCache.iterateThroughSourceUpToNumber(number, indexes);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FilteringDataTable)) {
            return false;
        }
        FilteringDataTable other = (FilteringDataTable)obj;
        if (!this.filterExpression.equals(other.filterExpression)) {
            return false;
        }
        if (!Util.equals(this.quality, other.quality)) {
            return false;
        }
        return this.source.equals(other.source);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.source, this.filterExpression, this.quality);
    }

    @Override
    void getEncodedRecordsOrTableID(StringBuilder finalSB, ClassicEncodingSettings settings, Boolean isTransferEncode, Integer encodeLevel) {
        if (this.id != null) {
            new Element("C", String.valueOf(this.id)).encode(finalSB, settings, isTransferEncode, encodeLevel);
        }
    }

    @Override
    public String toDefaultString() {
        return "Filtering data table with source: " + this.source + " filtered using filter: " + this.filterExpression;
    }

    @Override
    public String dataAsString(boolean showFieldNames, boolean showHiddenFields, boolean showPasswords) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    @Override
    public boolean isOneCellTable() {
        return this.indexTableCache.isOneCellTable();
    }

    @Override
    public Integer findIndex(DataTableQuery query) {
        Iterator<DataRecord> iter;
        Integer foundIndexInSource = this.source.findIndex(query);
        if (foundIndexInSource == null || !this.passing(foundIndexInSource)) {
            return null;
        }
        List<Integer> indexes = this.indexTableCache.getIndexTable();
        int foundIndexInThisDataTable = indexes.indexOf(foundIndexInSource);
        if (foundIndexInThisDataTable != -1) {
            return foundIndexInThisDataTable;
        }
        if (this.indexTableCache.isIndexTableComplete(indexes, this.getRecordCount())) {
            return null;
        }
        DataRecord recordToFind = this.source.getRecord(foundIndexInSource);
        int currentMaxIndexInThisDataTable = indexes.size() - 1;
        Iterator<DataRecord> iterator = iter = currentMaxIndexInThisDataTable != -1 ? this.iterator(currentMaxIndexInThisDataTable + 1) : this.iterator();
        while (iter.hasNext()) {
            DataRecord record = iter.next();
            ++currentMaxIndexInThisDataTable;
            if (!record.equals(recordToFind)) continue;
            return currentMaxIndexInThisDataTable;
        }
        throw new RuntimeException("This should not have happened");
    }

    @Override
    public Iterator<DataRecord> iterator() {
        return new Iter();
    }

    @Override
    public Iterator<DataRecord> iterator(int index) {
        return new Iter(index);
    }

    private boolean passing(int recordIndex) {
        this.localEvaluator.getDefaultResolver().setDefaultRow(recordIndex);
        try {
            return this.localEvaluator.evaluateToBoolean(this.filterExpression, this.localEnvironment);
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    private final class Iter
    implements Iterator<DataRecord> {
        private final List<Integer> indexes;
        private int nextIndexInSource;
        private final Iterator<DataRecord> recsIter;
        private DataRecord nextRecord;
        private boolean isNextRecordSet;
        private int cursor;

        Iter() {
            this.indexes = FilteringDataTable.this.indexTableCache.getIndexTable();
            this.nextIndexInSource = this.indexes.size() != 0 ? this.indexes.get(this.indexes.size() - 1) + 1 : 0;
            this.recsIter = this.indexes.size() != 0 ? FilteringDataTable.this.source.iterator(this.nextIndexInSource) : FilteringDataTable.this.source.iterator();
            this.cursor = -1;
        }

        Iter(int index) {
            this.indexes = FilteringDataTable.this.indexTableCache.getIndexTable();
            this.nextIndexInSource = this.indexes.size() != 0 ? this.indexes.get(this.indexes.size() - 1) + 1 : 0;
            Iterator<DataRecord> iterator = this.recsIter = this.indexes.size() != 0 ? FilteringDataTable.this.source.iterator(this.nextIndexInSource) : FilteringDataTable.this.source.iterator();
            if (index > this.indexes.size()) {
                this.cursor = this.indexes.size() - 1;
                while (this.hasNext() && this.cursor < index) {
                    this.next();
                }
                if (this.cursor != index) {
                    throw new NoSuchElementException("There is no element with index #" + index + " in this filtering data table");
                }
            } else {
                this.cursor = index - 1;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.cursor + 1 < this.indexes.size()) {
                return true;
            }
            if (this.isNextRecordSet || this.setNextRecord()) {
                return true;
            }
            FilteringDataTable.this.indexTableCache.setSoftIndexTable(this.indexes);
            FilteringDataTable.this.setRecordCount(this.cursor + 1);
            return false;
        }

        @Override
        public DataRecord next() {
            if (this.cursor + 1 < this.indexes.size()) {
                return FilteringDataTable.this.source.getRecord(this.indexes.get(++this.cursor));
            }
            if (!this.isNextRecordSet && !this.setNextRecord()) {
                throw new NoSuchElementException();
            }
            this.isNextRecordSet = false;
            return this.nextRecord;
        }

        private boolean setNextRecord() {
            while (this.recsIter.hasNext()) {
                DataRecord nextRecordInSource = this.recsIter.next();
                if (FilteringDataTable.this.passing(this.nextIndexInSource)) {
                    this.nextRecord = nextRecordInSource;
                    this.isNextRecordSet = true;
                    this.indexes.add(this.nextIndexInSource++);
                    ++this.cursor;
                    return true;
                }
                ++this.nextIndexInSource;
            }
            return false;
        }
    }
}

