/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable;

import com.google.common.collect.ImmutableMap;
import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.data.Data;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableException;
import com.tibbo.aggregate.common.datatable.DataTableUtils;
import com.tibbo.aggregate.common.datatable.SelectionValue;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.ValidationException;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.datatable.encoding.TransferEncodingHelper;
import com.tibbo.aggregate.common.datatable.field.BooleanFieldFormat;
import com.tibbo.aggregate.common.datatable.field.ColorFieldFormat;
import com.tibbo.aggregate.common.datatable.field.DataFieldFormat;
import com.tibbo.aggregate.common.datatable.field.DataTableFieldFormat;
import com.tibbo.aggregate.common.datatable.field.DateFieldFormat;
import com.tibbo.aggregate.common.datatable.field.DoubleFieldFormat;
import com.tibbo.aggregate.common.datatable.field.FloatFieldFormat;
import com.tibbo.aggregate.common.datatable.field.IntFieldFormat;
import com.tibbo.aggregate.common.datatable.field.LongFieldFormat;
import com.tibbo.aggregate.common.datatable.field.StringFieldFormat;
import com.tibbo.aggregate.common.datatable.validator.AbstractFieldValidator;
import com.tibbo.aggregate.common.datatable.validator.ExpressionValidator;
import com.tibbo.aggregate.common.datatable.validator.FieldValidator;
import com.tibbo.aggregate.common.datatable.validator.IdValidator;
import com.tibbo.aggregate.common.datatable.validator.LimitsValidator;
import com.tibbo.aggregate.common.datatable.validator.NonNullValidator;
import com.tibbo.aggregate.common.datatable.validator.RegexValidator;
import com.tibbo.aggregate.common.datatable.validator.ValidatorHelper;
import com.tibbo.aggregate.common.util.CloneUtils;
import com.tibbo.aggregate.common.util.Element;
import com.tibbo.aggregate.common.util.ElementList;
import com.tibbo.aggregate.common.util.PublicCloneable;
import com.tibbo.aggregate.common.util.StringUtils;
import com.tibbo.aggregate.common.util.Util;
import java.awt.Color;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class FieldFormat<T>
implements Cloneable,
PublicCloneable {
    private static final Map<Class, Character> CLASS_TO_TYPE = new ConcurrentHashMap<Class, Character>();
    private static final Map<String, Class<? extends AbstractFieldValidator>> VALIDATOR_TO_TYPE = new LinkedHashMap<String, Class<? extends AbstractFieldValidator>>();
    private static final Map<Object, String> TYPE_SELECTION_VALUES = new LinkedHashMap<Object, String>();
    public static final char INTEGER_FIELD = 'I';
    public static final char STRING_FIELD = 'S';
    public static final char BOOLEAN_FIELD = 'B';
    public static final char LONG_FIELD = 'L';
    public static final char FLOAT_FIELD = 'F';
    public static final char DOUBLE_FIELD = 'E';
    public static final char DATE_FIELD = 'D';
    public static final char DATATABLE_FIELD = 'T';
    public static final char COLOR_FIELD = 'C';
    public static final char DATA_FIELD = 'A';
    private static final String ELEMENT_FLAGS = "F";
    private static final String ELEMENT_DEFAULT_VALUE = "A";
    private static final String ELEMENT_DESCRIPTION = "D";
    private static final String ELEMENT_HELP = "H";
    private static final String ELEMENT_SELECTION_VALUES = "S";
    private static final String ELEMENT_VALIDATORS = "V";
    private static final String ELEMENT_EDITOR = "E";
    private static final String ELEMENT_EDITOR_OPTIONS = "O";
    private static final String ELEMENT_ICON = "I";
    private static final String ELEMENT_GROUP = "G";
    private static final char ADVANCED_FLAG = 'A';
    private static final char NOT_REPLICATED_FLAG = 'C';
    private static final char EXTENDABLE_SELECTION_VALUES_FLAG = 'E';
    private static final char HIDDEN_FLAG = 'H';
    private static final char INLINE_DATA_FLAG = 'I';
    private static final char KEY_FIELD_FLAG = 'K';
    private static final char NULLABLE_FLAG = 'N';
    private static final char OPTIONAL_FLAG = 'O';
    private static final char READ_ONLY_FLAG = 'R';
    private static final char DEFAULT_OVERRIDE = 'D';
    private static final char SHALLOW_FLAG = 'S';
    private static final char ENCRYPTED_FLAG = 'Y';
    public static final char VALIDATOR_LIMITS = 'L';
    public static final char VALIDATOR_REGEX = 'R';
    public static final char VALIDATOR_NON_NULL = 'N';
    public static final char VALIDATOR_ID = 'I';
    public static final char VALIDATOR_EXPRESSION = 'E';
    private String name;
    private boolean nullable;
    private boolean optional;
    private boolean extendableSelectionValues;
    private boolean readonly;
    private boolean notReplicated;
    private boolean hidden;
    private boolean keyField;
    private boolean inlineData;
    private boolean advanced;
    private boolean defaultOverride;
    private boolean shallow;
    private boolean encrypted;
    private T defaultValue;
    private String description;
    private String help;
    private String group;
    private String editor;
    private String editorOptions;
    private Map<T, String> selectionValues;
    private List<FieldValidator> validators = new LinkedList<FieldValidator>();
    private String icon;
    private boolean transferEncode;
    private boolean immutable;
    private String cachedDefaultDescription;
    public static final String EDITOR_LIST = "list";
    public static final String EDITOR_BAR = "bar";
    public static final String EDITOR_BYTES = "bytes";
    public static final String EDITOR_INSTANCE = "instance";
    public static final String EDITOR_FOREIGN_INSTANCE = "foreignInstance";
    public static final String EDITOR_FORMAT_STRING = "formatString";

    public abstract char getType();

    public abstract Class getFieldClass();

    public abstract Class getFieldWrappedClass();

    public abstract T getNotNullDefault();

    public abstract T valueFromString(String var1, ClassicEncodingSettings var2, boolean var3);

    public abstract String valueToString(T var1, ClassicEncodingSettings var2);

    protected FieldFormat(String name) {
        this.name = name;
    }

    public static <S> FieldFormat<S> create(String name, Class valueClass) {
        Character type;
        if (DataTable.class.isAssignableFrom(valueClass)) {
            valueClass = DataTable.class;
        }
        if ((type = CLASS_TO_TYPE.get(valueClass)) == null) {
            throw new IllegalArgumentException("Unknown field class: " + valueClass.getName());
        }
        return FieldFormat.create(name, type.charValue());
    }

    public static FieldFormat create(String name, char type, boolean validate) {
        FieldFormat ff = FieldFormat.create(name, type);
        if (validate) {
            ff.validateName();
        }
        return ff;
    }

    public static FieldFormat create(String name, char type) {
        switch (type) {
            case 'I': {
                return new IntFieldFormat(name);
            }
            case 'S': {
                return new StringFieldFormat(name);
            }
            case 'B': {
                return new BooleanFieldFormat(name);
            }
            case 'L': {
                return new LongFieldFormat(name);
            }
            case 'F': {
                return new FloatFieldFormat(name);
            }
            case 'E': {
                return new DoubleFieldFormat(name);
            }
            case 'D': {
                return new DateFieldFormat(name);
            }
            case 'T': {
                return new DataTableFieldFormat(name);
            }
            case 'C': {
                return new ColorFieldFormat(name);
            }
            case 'A': {
                return new DataFieldFormat(name);
            }
        }
        throw new IllegalArgumentException("Unknown field type: " + type);
    }

    public static <S> FieldFormat<S> create(String name, char type, String description) {
        FieldFormat ff = FieldFormat.create(name, type);
        ff.setDescription(description);
        return ff;
    }

    public static <S> FieldFormat<S> create(String name, char type, String description, S defaultValue) {
        return FieldFormat.create(name, type, description, defaultValue, false, null);
    }

    public static <S> FieldFormat<S> create(String name, char type, String description, S defaultValue, String group) {
        return FieldFormat.create(name, type, description, defaultValue, false, group);
    }

    public static <S> FieldFormat<S> create(String name, char type, String description, S defaultValue, boolean nullable) {
        return FieldFormat.create(name, type, description, defaultValue, nullable, null);
    }

    public static <S> FieldFormat<S> create(String name, char type, String description, S defaultValue, boolean nullable, String group) {
        FieldFormat<S> ff = FieldFormat.create(name, type, description);
        ff.setNullable(nullable);
        ff.setDefault(defaultValue);
        ff.setGroup(group);
        return ff;
    }

    public static <S> FieldFormat<S> create(String format, ClassicEncodingSettings settings) {
        return FieldFormat.create(format, settings, true);
    }

    public static <S> FieldFormat<S> create(String format, ClassicEncodingSettings settings, boolean validate) {
        Element el;
        char type;
        ElementList els = StringUtils.elements(format, settings.isUseVisibleSeparators());
        String name = null;
        try {
            name = ((Element)els.get(0)).getValue();
            type = ((Element)els.get(1)).getValue().charAt(0);
        }
        catch (IndexOutOfBoundsException ex1) {
            throw new IllegalArgumentException(ex1.getMessage() + ", format was '" + format + "'", ex1);
        }
        FieldFormat ff = FieldFormat.create(name, type);
        if (validate) {
            ff.validateName();
        }
        if ((el = els.getElement(ELEMENT_FLAGS)) != null) {
            String flags = el.getValue();
            ff.setNullable(flags.indexOf(78) != -1);
            ff.setOptional(flags.indexOf(79) != -1);
            ff.setExtendableSelectionValues(flags.indexOf(69) != -1);
            ff.setReadonly(flags.indexOf(82) != -1);
            ff.setNotReplicated(flags.indexOf(67) != -1);
            ff.setHidden(flags.indexOf(72) != -1);
            ff.setKeyField(flags.indexOf(75) != -1);
            ff.setInlineData(flags.indexOf(73) != -1);
            ff.setAdvanced(flags.indexOf(65) != -1);
            ff.setDefaultOverride(flags.indexOf(68) != -1);
            ff.setShallow(flags.indexOf(83) != -1);
            ff.setEncrypted(flags.indexOf(89) != -1);
        }
        if ((el = els.getElement(ELEMENT_DEFAULT_VALUE)) != null) {
            ff.setDefaultFromString(el.getValue(), settings, validate);
        }
        if ((el = els.getElement(ELEMENT_DESCRIPTION)) != null) {
            ff.setDescription(DataTableUtils.transferDecode(el.getValue(), settings));
        }
        if ((el = els.getElement(ELEMENT_HELP)) != null) {
            ff.setHelp(DataTableUtils.transferDecode(el.getValue(), settings));
        }
        if ((el = els.getElement(ELEMENT_SELECTION_VALUES)) != null) {
            ff.createSelectionValues(el.getValue(), settings);
        }
        if ((el = els.getElement(ELEMENT_VALIDATORS)) != null) {
            ff.createValidators(el.getValue(), settings);
        }
        if ((el = els.getElement(ELEMENT_EDITOR)) != null) {
            ff.setEditor(DataTableUtils.transferDecode(el.getValue(), settings));
        }
        if ((el = els.getElement(ELEMENT_EDITOR_OPTIONS)) != null) {
            ff.setEditorOptions(DataTableUtils.transferDecode(el.getValue(), settings));
        }
        if ((el = els.getElement(ELEMENT_ICON)) != null) {
            ff.setIcon(DataTableUtils.transferDecode(el.getValue(), settings));
        }
        if ((el = els.getElement(ELEMENT_GROUP)) != null) {
            ff.setGroup(DataTableUtils.transferDecode(el.getValue(), settings));
        }
        return ff;
    }

    private void validateName() {
        try {
            ValidatorHelper.NAME_SYNTAX_VALIDATOR.validate(this.getName());
        }
        catch (ValidationException ve) {
            throw new RuntimeException(MessageFormat.format(Cres.get().getString("dtIllegalFieldValue"), this.getName(), this.toDetailedString()) + ve.getMessage(), ve);
        }
    }

    public static <S> FieldFormat<S> create(String format) {
        return FieldFormat.create(format, new ClassicEncodingSettings(true), true);
    }

    public static boolean isNumericField(FieldFormat ff) {
        return FieldFormat.isNumericField(ff.getType());
    }

    public static boolean isNumericField(char type) {
        return type == 'I' || type == 'L' || type == 'F' || type == 'E';
    }

    private void createSelectionValues(String source, ClassicEncodingSettings settings) {
        if (source.length() == 0) {
            return;
        }
        LinkedHashMap<T, String> values = new LinkedHashMap<T, String>();
        ElementList els = StringUtils.elements(source, settings.isUseVisibleSeparators());
        for (Element el : els) {
            String valueSource = el.getValue();
            T selectionValue = this.valueFromEncodedString(valueSource, settings, true);
            String desc = el.getName() != null ? el.getName() : selectionValue.toString();
            values.put(selectionValue, desc);
        }
        this.setSelectionValues(values.size() > 0 ? values : null);
    }

    public T valueFromEncodedString(String source) {
        return this.valueFromEncodedString(source, new ClassicEncodingSettings(false), true);
    }

    public T valueFromEncodedString(String source, ClassicEncodingSettings settings, boolean validate) {
        String nullElement = settings.isUseVisibleSeparators() ? "<NULL>" : DataTableUtils.DATA_TABLE_NULL;
        boolean sourceIsNull = source.equals(nullElement);
        return sourceIsNull ? null : (T)this.valueFromString(this.isTransferEncode() ? DataTableUtils.transferDecode(source, settings) : source, settings, validate);
    }

    public T valueFromString(String value) {
        return this.valueFromString(value, null, false);
    }

    public String valueToString(T value) {
        return this.valueToString(value, null);
    }

    public String valueToEncodedString(T value, ClassicEncodingSettings settings) {
        return this.valueToEncodedString(value, settings, new StringBuilder(), 1).toString();
    }

    public StringBuilder valueToEncodedString(T value, ClassicEncodingSettings settings, StringBuilder sb, Integer encodeLevel) {
        String strVal = this.valueToString(value, settings);
        if (strVal == null) {
            return settings == null || !settings.isUseVisibleSeparators() ? sb.append(DataTableUtils.DATA_TABLE_NULL) : sb.append("<NULL>");
        }
        if (this.isTransferEncode()) {
            TransferEncodingHelper.encode(strVal, sb, encodeLevel);
        } else {
            sb.append(strVal);
        }
        return sb;
    }

    public void setDefaultFromString(String value) {
        this.setDefaultFromString(value, new ClassicEncodingSettings(false), true);
    }

    public void setDefaultFromString(String value, ClassicEncodingSettings settings, boolean validate) {
        if (value.length() == 0) {
            return;
        }
        this.setDefault(this.valueFromEncodedString(value, settings, false));
    }

    public FieldFormat<T> setDefault(T value) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        try {
            this.defaultValue = this.checkAndConvertValue(value, true);
        }
        catch (ContextException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
        return this;
    }

    private String getEncodedSelectionValues(ClassicEncodingSettings settings) {
        if (this.selectionValues == null) {
            return null;
        }
        StringBuffer enc = new StringBuffer();
        for (T value : this.selectionValues.keySet()) {
            String valueDesc = this.selectionValues.get(value);
            enc.append(new Element(valueDesc, this.valueToEncodedString(value, settings)).encode(settings));
        }
        return enc.toString();
    }

    public String getEncodedValidators(ClassicEncodingSettings settings) {
        if (this.validators.size() == 0) {
            return null;
        }
        StringBuffer enc = new StringBuffer();
        for (FieldValidator fv : this.validators) {
            if (fv.getType() == null) continue;
            enc.append(new Element(String.valueOf(fv.getType()), fv.encode()).encode(settings));
        }
        return enc.length() != 0 ? enc.toString() : null;
    }

    private String getEncodedFlags() {
        StringBuilder buf = new StringBuilder();
        if (this.isNullable()) {
            buf.append('N');
        }
        if (this.isOptional()) {
            buf.append('O');
        }
        if (this.isReadonly()) {
            buf.append('R');
        }
        if (this.isNotReplicated()) {
            buf.append('C');
        }
        if (this.isExtendableSelectionValues()) {
            buf.append('E');
        }
        if (this.isHidden()) {
            buf.append('H');
        }
        if (this.isKeyField()) {
            buf.append('K');
        }
        if (this.isInlineData()) {
            buf.append('I');
        }
        if (this.isAdvanced()) {
            buf.append('A');
        }
        if (this.isDefaultOverride()) {
            buf.append('D');
        }
        if (this.isShallow()) {
            buf.append('S');
        }
        if (this.isEncrypted()) {
            buf.append('Y');
        }
        return buf.toString();
    }

    private static void encAppend(StringBuilder buffer, String name, String value, ClassicEncodingSettings settings) {
        FieldFormat.encAppend(buffer, name, value, settings, false);
    }

    private static void encAppend(StringBuilder buffer, String name, String value, ClassicEncodingSettings settings, boolean allowEmptyString) {
        if (value != null && (allowEmptyString || !value.isEmpty())) {
            new Element(name, value).encode(buffer, settings, false, 0);
        }
    }

    public String encode() {
        return this.encode(true);
    }

    public String encode(boolean useVisibleSeparators) {
        return this.encode(new ClassicEncodingSettings(useVisibleSeparators));
    }

    public String encode(ClassicEncodingSettings settings) {
        StringBuilder data = new StringBuilder();
        new Element(null, this.getName()).encode(data, settings);
        new Element(null, String.valueOf(this.getType())).encode(data, settings);
        FieldFormat.encAppend(data, ELEMENT_FLAGS, this.getEncodedFlags(), settings);
        if (settings.isEncodeDefaultValues()) {
            new Element(ELEMENT_DEFAULT_VALUE, this.valueToEncodedString(this.getDefaultValue(), settings)).encode(data, settings);
        }
        FieldFormat.encAppend(data, ELEMENT_DESCRIPTION, DataTableUtils.transferEncode(this.description), settings);
        FieldFormat.encAppend(data, ELEMENT_HELP, DataTableUtils.transferEncode(this.help), settings);
        FieldFormat.encAppend(data, ELEMENT_SELECTION_VALUES, this.getEncodedSelectionValues(settings), settings);
        FieldFormat.encAppend(data, ELEMENT_VALIDATORS, this.getEncodedValidators(settings), settings);
        FieldFormat.encAppend(data, ELEMENT_EDITOR, DataTableUtils.transferEncode(this.editor), settings);
        FieldFormat.encAppend(data, ELEMENT_EDITOR_OPTIONS, DataTableUtils.transferEncode(this.editorOptions), settings, true);
        FieldFormat.encAppend(data, ELEMENT_ICON, DataTableUtils.transferEncode(this.icon), settings);
        FieldFormat.encAppend(data, ELEMENT_GROUP, DataTableUtils.transferEncode(this.group), settings);
        return new String(data);
    }

    public boolean extend(FieldFormat other) {
        return this.extendMessage(other) == null;
    }

    public String extendMessage(FieldFormat other) {
        if (!this.getName().equals(other.getName())) {
            return "Wrong name: need " + this.getName() + ", found " + other.getName();
        }
        if (other.hasDescription() && !Util.equals(this.getDescription(), other.getDescription())) {
            return "Wrong description: need " + this.getDescription() + ", found " + other.getDescription();
        }
        if (!Util.equals(this.getHelp(), other.getHelp())) {
            return "Wrong help: need " + this.getHelp() + ", found " + other.getHelp();
        }
        if (this.getType() != other.getType()) {
            return "Wrong type: need " + this.getType() + ", found " + other.getType();
        }
        if (!this.isNullable() && other.isNullable()) {
            return "Different nullable flags: need " + this.isNullable() + ", found " + other.isNullable();
        }
        if (this.isReadonly() != other.isReadonly()) {
            return "Different readonly flags: need " + this.isReadonly() + ", found " + other.isReadonly();
        }
        if (this.isHidden() != other.isHidden()) {
            return "Different hidden flags: need " + this.isHidden() + ", found " + other.isHidden();
        }
        if (this.isEncrypted() != other.isEncrypted()) {
            return "Different encrypted flags: need " + this.isEncrypted() + ", found " + other.isEncrypted();
        }
        if (this.isKeyField() != other.isKeyField()) {
            return "Different kay field flags: need " + this.isKeyField() + ", found " + other.isKeyField();
        }
        if (!this.isExtendableSelectionValues() || !other.isExtendableSelectionValues()) {
            boolean selectionValuesOk;
            boolean bl = selectionValuesOk = other.getSelectionValues() == null || Util.equals(this.getSelectionValues(), other.getSelectionValues());
            if (!selectionValuesOk && this.getSelectionValues() != null) {
                boolean foundMissingValues = false;
                for (T value : this.getSelectionValues().keySet()) {
                    if (other.getSelectionValues().containsKey(value)) continue;
                    foundMissingValues = true;
                }
                if (!foundMissingValues) {
                    selectionValuesOk = true;
                }
            }
            if (!selectionValuesOk) {
                return "Different selection values: need " + other.getSelectionValues() + ", found " + this.getSelectionValues();
            }
        }
        if (!Util.equals(this.getEditor(), other.getEditor())) {
            return "Different editor: need " + this.getEditor() + ", found " + other.getEditor();
        }
        if (!Util.equals(this.getEditorOptions(), other.getEditorOptions())) {
            return "Different editor options: need " + this.getEditorOptions() + ", found " + other.getEditorOptions();
        }
        if (!Util.equals(this.getIcon(), other.getIcon())) {
            return "Wrong icon: need " + this.getIcon() + ", found " + other.getIcon();
        }
        if (!Util.equals(this.getGroup(), other.getGroup())) {
            return "Wrong group: need " + this.getGroup() + ", found " + other.getGroup();
        }
        List<FieldValidator> otherValidators = other.getValidators();
        for (FieldValidator otherValidator : otherValidators) {
            if (this.getValidators().contains(otherValidator)) continue;
            return "Different validators: need " + this.getValidators() + ", found " + other.getValidators();
        }
        if (this.getDefaultValue() != null && this.getDefaultValue() instanceof DataTable && other.getDefaultValue() != null && other.getDefaultValue() instanceof DataTable) {
            DataTable my = (DataTable)this.getDefaultValue();
            DataTable another = (DataTable)other.getDefaultValue();
            String msg = my.getFormat().extendMessage(another.getFormat());
            if (msg != null) {
                return "Field format doesn't match: " + msg;
            }
        }
        return null;
    }

    public FieldFormat<T> addValidator(FieldValidator validator) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.validators.add(validator);
        return this;
    }

    public void setValidators(Collection<FieldValidator> validators) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.validators.clear();
        this.validators.addAll(validators);
    }

    public void createValidators(String source, ClassicEncodingSettings settings) {
        if (source == null || source.length() == 0) {
            return;
        }
        ElementList validatorsData = StringUtils.elements(source, settings.isUseVisibleSeparators());
        for (Element el : validatorsData) {
            char validatorType = el.getName().charAt(0);
            String validatorParams = el.getValue();
            switch (validatorType) {
                case 'L': {
                    this.addValidator(new LimitsValidator(this, validatorParams));
                    break;
                }
                case 'R': {
                    this.addValidator(new RegexValidator(validatorParams));
                    break;
                }
                case 'N': {
                    this.addValidator(new NonNullValidator(validatorParams));
                    break;
                }
                case 'I': {
                    this.addValidator(new IdValidator());
                    break;
                }
                case 'E': {
                    this.addValidator(new ExpressionValidator(validatorParams));
                }
            }
        }
    }

    public T checkAndConvertValue(T value, boolean validate) throws ValidationException {
        return this.checkAndConvertValue(null, null, null, value, validate);
    }

    public T checkAndConvertValue(Context context, ContextManager contextManager, CallerController caller, T value, boolean validate) throws ValidationException {
        if (!this.isNullable() && value == null) {
            throw new ValidationException(MessageFormat.format(Cres.get().getString("dtNullsNotPermitted"), this.toString()));
        }
        if ((value = this.convertValue(value)) != null && !this.isExtendableSelectionValues() && this.selectionValues != null && !this.selectionValues.containsKey(value)) {
            if (validate) {
                throw new ValidationException(Cres.get().getString("dtValueNotInSelVals") + value + " (" + value.getClass().getName() + ")");
            }
            value = this.getDefaultValue();
        }
        if (validate) {
            for (FieldValidator fv : this.validators) {
                value = fv.validate(context, contextManager, caller, value);
            }
        }
        return (T)value;
    }

    protected Object convertValue(Object value) throws ValidationException {
        if (value != null) {
            if (this.getFieldClass() == value.getClass() || this.getFieldWrappedClass() == value.getClass() || this.getFieldClass().isAssignableFrom(value.getClass()) || this.getFieldWrappedClass().isAssignableFrom(value.getClass())) {
                return value;
            }
            throw new ValidationException("Invalid class, need '" + this.getFieldWrappedClass().getName() + "', found '" + value.getClass().getName() + "'");
        }
        return value;
    }

    public String getTypeName() {
        return TYPE_SELECTION_VALUES.get(String.valueOf(this.getType()));
    }

    public String getName() {
        return this.name;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isShallow() {
        return this.shallow;
    }

    public T getDefaultValue() {
        if (this.defaultValue == null && !this.isNullable()) {
            this.defaultValue = this.getNotNullDefault();
        }
        return this.defaultValue;
    }

    public T getDefaultValueCopy() {
        T def = this.getDefaultValue();
        return (T)(def == null ? null : CloneUtils.deepClone(def));
    }

    public String getDescription() {
        if (this.description == null) {
            if (this.cachedDefaultDescription == null) {
                this.cachedDefaultDescription = Util.nameToDescription(this.name);
            }
            return this.cachedDefaultDescription;
        }
        return this.description;
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public String getHelp() {
        return this.help;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean hasSelectionValues() {
        return this.selectionValues != null && this.selectionValues.size() > 0;
    }

    public boolean hasSelectionValue(Object value) {
        return this.selectionValues != null && this.selectionValues.containsKey(value);
    }

    public Map<T, String> getSelectionValues() {
        return this.immutable ? (this.selectionValues != null ? Collections.unmodifiableMap(this.selectionValues) : null) : this.selectionValues;
    }

    public FieldFormat<T> addSelectionValue(T value, String description) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        if (StringUtils.isEmpty(description)) {
            throw new IllegalArgumentException("Empty selection value description");
        }
        try {
            value = this.convertValue(value);
        }
        catch (ValidationException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
        if (this.selectionValues == null) {
            this.selectionValues = new LinkedHashMap<T, String>();
        }
        this.selectionValues.put(value, description);
        return this;
    }

    public FieldFormat<T> addSelectionValue(T value) {
        return this.addSelectionValue(value, value.toString());
    }

    public boolean isExtendableSelectionValues() {
        return this.extendableSelectionValues;
    }

    public List<FieldValidator> getValidators() {
        return this.immutable ? Collections.unmodifiableList(this.validators) : this.validators;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public boolean isNotReplicated() {
        return this.notReplicated;
    }

    protected boolean isTransferEncode() {
        return this.transferEncode;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getEditor() {
        return this.editor;
    }

    public static Map<Object, String> getTypeSelectionValues() {
        return TYPE_SELECTION_VALUES;
    }

    public static Character getType(Class valueClass) {
        valueClass = FieldFormat.getSupertypeWhereRequired(valueClass);
        return CLASS_TO_TYPE.get(valueClass);
    }

    public static boolean isFieldClass(Class valueClass) {
        valueClass = FieldFormat.getSupertypeWhereRequired(valueClass);
        return CLASS_TO_TYPE.containsKey(valueClass);
    }

    private static Class getSupertypeWhereRequired(Class valueClass) {
        if (DataTable.class.isAssignableFrom(valueClass)) {
            return DataTable.class;
        }
        return valueClass;
    }

    public static Collection getTypes() {
        return CLASS_TO_TYPE.values();
    }

    public static Map<String, Class<? extends AbstractFieldValidator>> getValidatorToTypeMap() {
        return VALIDATOR_TO_TYPE;
    }

    public boolean isKeyField() {
        return this.keyField;
    }

    public String getEditorOptions() {
        return this.editorOptions;
    }

    public boolean isInlineData() {
        return this.inlineData;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public FieldFormat<T> setAdvanced(boolean advanced) {
        this.advanced = advanced;
        return this;
    }

    public FieldFormat<T> setDescription(String description) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.description = description;
        return this;
    }

    public FieldFormat<T> setHelp(String help) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.help = help;
        return this;
    }

    public FieldFormat<T> setSelectionValues(Map<? extends T, String> selectionValues) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        if (selectionValues == null || selectionValues.size() == 0) {
            this.selectionValues = null;
            return this;
        }
        LinkedHashMap linkedHashMap = this.selectionValues = selectionValues instanceof Cloneable ? selectionValues : new LinkedHashMap(selectionValues);
        if (!selectionValues.containsKey(this.getDefaultValue()) && !this.extendableSelectionValues) {
            this.setDefault(selectionValues.keySet().iterator().next());
        }
        return this;
    }

    public <E extends Enum<E>> FieldFormat<T> setSelectionValues(Class<E> selectionValuesClass) {
        EnumSet<SelectionValue> enumSet = EnumSet.allOf(selectionValuesClass);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (SelectionValue selectionValue : enumSet) {
            builder.put((Object)selectionValue.getValue(), (Object)selectionValue.getDescription());
        }
        return this.setSelectionValues((Map<? extends T, String>)builder.build());
    }

    public FieldFormat<T> setExtendableSelectionValues(boolean extendableSelectionValues) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.extendableSelectionValues = extendableSelectionValues;
        return this;
    }

    public FieldFormat<T> setNullable(boolean nullable) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.nullable = nullable;
        return this;
    }

    public FieldFormat<T> setShallow(boolean shallow) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.shallow = shallow;
        return this;
    }

    public FieldFormat<T> setOptional(boolean optional) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.optional = optional;
        return this;
    }

    public FieldFormat<T> setReadonly(boolean readonly) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.readonly = readonly;
        return this;
    }

    public FieldFormat<T> setNotReplicated(boolean notReplicated) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.notReplicated = notReplicated;
        return this;
    }

    protected FieldFormat<T> setTransferEncode(boolean transferEncode) {
        this.transferEncode = transferEncode;
        return this;
    }

    public FieldFormat<T> setHidden(boolean hidden) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.hidden = hidden;
        return this;
    }

    public FieldFormat<T> setEditor(String editor) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        if (editor != null && !this.getSuitableEditors().contains(editor)) {
            throw new IllegalArgumentException(MessageFormat.format(Cres.get().getString("dtEditorNotSuitable"), this.toString()) + editor);
        }
        this.editor = editor;
        return this;
    }

    public FieldFormat<T> setKeyField(boolean keyField) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.keyField = keyField;
        return this;
    }

    public FieldFormat<T> setName(String name) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.name = name;
        return this;
    }

    public FieldFormat<T> setEditorOptions(String editorOptions) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.editorOptions = editorOptions;
        return this;
    }

    public FieldFormat<T> setInlineData(boolean inlineData) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.inlineData = inlineData;
        return this;
    }

    public void setSelectionValues(String source) throws DataTableException {
        this.createSelectionValues(source, new ClassicEncodingSettings(false));
    }

    public FieldFormat<T> setIcon(String icon) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.icon = icon;
        return this;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getGroup() {
        return this.group;
    }

    public void removeGroup() {
        this.group = null;
    }

    public FieldFormat<T> setGroup(String group) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.group = group;
        return this;
    }

    public boolean isDefaultOverride() {
        return this.defaultOverride;
    }

    public FieldFormat<T> setDefaultOverride(boolean defaultOverride) {
        this.defaultOverride = defaultOverride;
        return this;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public FieldFormat<T> setEncrypted(boolean encrypted) {
        if (this.immutable) {
            throw new IllegalStateException("Immutable");
        }
        this.encrypted = encrypted;
        return this;
    }

    public String toString() {
        return this.description != null ? this.description : this.name;
    }

    public String toDetailedString() {
        return (this.description != null ? this.description + " (" + this.name + ")" : this.name) + ", " + this.getTypeName();
    }

    public List<String> getSuitableEditors() {
        return Arrays.asList(EDITOR_LIST);
    }

    public TableFormat wrap() {
        return new TableFormat(this);
    }

    public TableFormat wrapSimple() {
        return new TableFormat(this).setMinRecords(1).setMaxRecords(1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        T def = this.getDefaultValue();
        result = 31 * result + (def == null ? 0 : def.hashCode());
        result = 31 * result + this.getType();
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.editor == null ? 0 : this.editor.hashCode());
        result = 31 * result + (this.editorOptions == null ? 0 : this.editorOptions.hashCode());
        result = 31 * result + (this.icon == null ? 0 : this.icon.hashCode());
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.extendableSelectionValues ? 1231 : 1237);
        result = 31 * result + (this.help == null ? 0 : this.help.hashCode());
        result = 31 * result + (this.hidden ? 1231 : 1237);
        result = 31 * result + (this.inlineData ? 1231 : 1237);
        result = 31 * result + (this.encrypted ? 1231 : 1237);
        result = 31 * result + (this.keyField ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.notReplicated ? 1231 : 1237);
        result = 31 * result + (this.nullable ? 1231 : 1237);
        result = 31 * result + (this.optional ? 1231 : 1237);
        result = 31 * result + (this.readonly ? 1231 : 1237);
        result = 31 * result + (this.advanced ? 1231 : 1237);
        result = 31 * result + (this.selectionValues == null ? 0 : this.selectionValues.hashCode());
        result = 31 * result + (this.transferEncode ? 1231 : 1237);
        result = 31 * result + (this.validators == null ? 0 : this.validators.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldFormat other = (FieldFormat)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.extendableSelectionValues != other.extendableSelectionValues) {
            return false;
        }
        if (this.hidden != other.hidden) {
            return false;
        }
        if (this.inlineData != other.inlineData) {
            return false;
        }
        if (this.encrypted != other.encrypted) {
            return false;
        }
        if (this.keyField != other.keyField) {
            return false;
        }
        if (this.notReplicated != other.notReplicated) {
            return false;
        }
        if (this.nullable != other.nullable) {
            return false;
        }
        if (this.optional != other.optional) {
            return false;
        }
        if (this.readonly != other.readonly) {
            return false;
        }
        if (this.advanced != other.advanced) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        T def = this.getDefaultValue();
        T odef = other.getDefaultValue();
        if (def == null ? odef != null : !def.equals(odef)) {
            return false;
        }
        if (this.help == null ? other.help != null : !this.help.equals(other.help)) {
            return false;
        }
        if (this.editor == null ? other.editor != null : !this.editor.equals(other.editor)) {
            return false;
        }
        if (this.editorOptions == null ? other.editorOptions != null : !this.editorOptions.equals(other.editorOptions)) {
            return false;
        }
        if (this.icon == null ? other.icon != null : !this.icon.equals(other.icon)) {
            return false;
        }
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        if (this.selectionValues == null ? other.selectionValues != null : !this.selectionValues.equals(other.selectionValues)) {
            return false;
        }
        if (this.transferEncode != other.transferEncode) {
            return false;
        }
        return !(this.validators == null ? other.validators != null : !this.validators.equals(other.validators));
    }

    @Override
    public FieldFormat<T> clone() {
        FieldFormat cl;
        try {
            cl = (FieldFormat)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
        cl.defaultValue = CloneUtils.genericClone(this.getDefaultValue());
        cl.selectionValues = (Map)CloneUtils.deepClone(this.selectionValues);
        cl.validators = (List)CloneUtils.deepClone(this.validators);
        cl.immutable = false;
        return cl;
    }

    public FieldFormat<T> cloneIfImmutable() {
        if (this.immutable) {
            return this.clone();
        }
        return this;
    }

    protected void makeImmutable() {
        this.immutable = true;
    }

    static {
        CLASS_TO_TYPE.put(Integer.class, Character.valueOf('I'));
        CLASS_TO_TYPE.put(String.class, Character.valueOf('S'));
        CLASS_TO_TYPE.put(Boolean.class, Character.valueOf('B'));
        CLASS_TO_TYPE.put(Long.class, Character.valueOf('L'));
        CLASS_TO_TYPE.put(Float.class, Character.valueOf('F'));
        CLASS_TO_TYPE.put(Double.class, Character.valueOf('E'));
        CLASS_TO_TYPE.put(Date.class, Character.valueOf('D'));
        CLASS_TO_TYPE.put(DataTable.class, Character.valueOf('T'));
        CLASS_TO_TYPE.put(Color.class, Character.valueOf('C'));
        CLASS_TO_TYPE.put(Data.class, Character.valueOf('A'));
        VALIDATOR_TO_TYPE.put(String.valueOf('L'), LimitsValidator.class);
        VALIDATOR_TO_TYPE.put(String.valueOf('R'), RegexValidator.class);
        VALIDATOR_TO_TYPE.put(String.valueOf('N'), NonNullValidator.class);
        VALIDATOR_TO_TYPE.put(String.valueOf('I'), IdValidator.class);
        VALIDATOR_TO_TYPE.put(String.valueOf('E'), ExpressionValidator.class);
        TYPE_SELECTION_VALUES.put(String.valueOf('I'), Cres.get().getString("dtInteger"));
        TYPE_SELECTION_VALUES.put(String.valueOf('S'), Cres.get().getString("dtString"));
        TYPE_SELECTION_VALUES.put(String.valueOf('B'), Cres.get().getString("dtBoolean"));
        TYPE_SELECTION_VALUES.put(String.valueOf('L'), Cres.get().getString("dtLong"));
        TYPE_SELECTION_VALUES.put(String.valueOf('F'), Cres.get().getString("dtFloat"));
        TYPE_SELECTION_VALUES.put(String.valueOf('E'), Cres.get().getString("dtDouble"));
        TYPE_SELECTION_VALUES.put(String.valueOf('D'), Cres.get().getString("date"));
        TYPE_SELECTION_VALUES.put(String.valueOf('T'), Cres.get().getString("dtDataTable"));
        TYPE_SELECTION_VALUES.put(String.valueOf('C'), Cres.get().getString("color"));
        TYPE_SELECTION_VALUES.put(String.valueOf('A'), Cres.get().getString("dtDataBlock"));
    }
}

