/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.binding.Binding;
import com.tibbo.aggregate.common.binding.DefaultBindingProcessor;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.data.Data;
import com.tibbo.aggregate.common.datatable.DataBlocksPreprocessor;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableBindingProvider;
import com.tibbo.aggregate.common.datatable.DataTableConversion;
import com.tibbo.aggregate.common.datatable.DataTableReplication;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.datatable.encoding.TransferEncodingHelper;
import com.tibbo.aggregate.common.expression.DefaultReferenceResolver;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.util.CloneUtils;
import com.tibbo.aggregate.common.util.ErrorCollector;
import com.tibbo.aggregate.common.util.StringUtils;
import com.tibbo.aggregate.common.util.Util;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DataTableUtils {
    public static final String NAMING_ENVIRONMENT_SHORT_DATA = "short";
    public static final String NAMING_ENVIRONMENT_FULL_DATA = "full";
    public static final char ELEMENT_START = '\u001c';
    public static final char ELEMENT_END = '\u001d';
    public static final char ELEMENT_NAME_VALUE_SEPARATOR = '\u001e';
    public static final char ELEMENT_VISIBLE_START = '<';
    public static final char ELEMENT_VISIBLE_END = '>';
    public static final char ELEMENT_VISIBLE_NAME_VALUE_SEPARATOR = '=';
    public static final String DATA_TABLE_NULL = String.valueOf('\u001a');
    public static final String DATA_TABLE_VISIBLE_NULL = "<NULL>";
    private static final Map<Object, String> EDITOR_SELECTION_VALUES = new LinkedHashMap<Object, String>();
    private static final Map<Object, String> VALIDATOR_SELECTION_VALUES;

    public static String transferDecode(String value, ClassicEncodingSettings settings) {
        try {
            return TransferEncodingHelper.decode(value, settings);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Error decoding string value '" + value + "'", ex);
        }
    }

    public static String transferEncode(String value) {
        return TransferEncodingHelper.encode(value, 1);
    }

    public static void inlineData(DataTable table, ContextManager cm, CallerController cc) throws ContextException {
        new DataBlocksPreprocessor().process(table, cm, cc);
    }

    public static Map<Object, String> getEditorSelectionValues() {
        return EDITOR_SELECTION_VALUES;
    }

    public static Map<Object, String> getValidatorSelectionValues() {
        return VALIDATOR_SELECTION_VALUES;
    }

    public static DataTable wrapToTable(List<Object> values) {
        LinkedHashMap<String, Object> tableSource = new LinkedHashMap<String, Object>();
        for (int i = 0; i < values.size(); ++i) {
            tableSource.put(String.valueOf(i), values.get(i));
        }
        return DataTableUtils.wrapToTable(tableSource);
    }

    public static DataTable wrapToTable(Map<String, Object> values) {
        if (values.isEmpty()) {
            return new SimpleDataTable();
        }
        TableFormat rf = new TableFormat();
        for (String field : values.keySet()) {
            Object value = values.get(field);
            rf.addField(DataTableConversion.createFieldFormat(field, value));
        }
        DataRecord result = new DataRecord(rf);
        for (String field : values.keySet()) {
            result.addValue(values.get(field));
        }
        return result.wrap();
    }

    public static Set<String> findDifferingFields(DataTable first, DataTable second) {
        if (!first.getRecordCount().equals(second.getRecordCount())) {
            return null;
        }
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        for (FieldFormat ff : first.getFormat()) {
            if (!second.getFormat().hasField(ff.getName())) continue;
            for (int i = 0; i < Math.min(first.getRecordCount(), second.getRecordCount()); ++i) {
                if (Util.equals(first.getRecord(i).getValue(ff.getName()), second.getRecord(i).getValue(ff.getName()))) continue;
                fields.add(ff.getName());
            }
        }
        return fields;
    }

    public static DataTable makeSubtable(DataTable table, Collection<String> fields) {
        TableFormat rf = new TableFormat(table.getFormat().getMinRecords(), table.getFormat().getMaxRecords());
        rf.setBindings(DataTableUtils.filterBindings(table.getFormat(), fields));
        for (String field : fields) {
            FieldFormat ff = table.getFormat(field);
            if (ff == null) continue;
            rf.addField(ff);
        }
        SimpleDataTable result = new SimpleDataTable(rf);
        DataTableReplication.copyWithoutKeyFields(table, result, true, true, true, true, true, null);
        return result;
    }

    public static List<Binding> filterBindings(TableFormat tableFormat, Collection<String> fields) {
        List formats = tableFormat.getFields().stream().filter(fieldFormat -> !fields.contains(fieldFormat.getName())).collect(Collectors.toList());
        List<Binding> result = (List<Binding>)CloneUtils.deepClone(new ArrayList<Binding>(tableFormat.getBindings()));
        result = result.stream().filter(binding -> {
            Optional<FieldFormat> res = formats.stream().filter(fieldFormat -> DataTableUtils.bindingContainsField(binding, fieldFormat.getName())).findAny();
            return !res.isPresent();
        }).collect(Collectors.toList());
        return result;
    }

    private static boolean bindingContainsField(Binding binding, String field) {
        return binding.getTarget().getImage().contains(field) || binding.getExpression().getText().contains(field);
    }

    public static Evaluator createEvaluator(DataTable dataTable, ContextManager contextManager, Context context) {
        DefaultReferenceResolver resolver = new DefaultReferenceResolver();
        resolver.setDefaultTable(dataTable);
        resolver.setContextManager(contextManager);
        resolver.setDefaultContext(context);
        return new Evaluator(resolver);
    }

    public static String fieldValueToString(FieldFormat ff, Object value) {
        if (ff.hasSelectionValues()) {
            return value.toString();
        }
        if (value instanceof Data) {
            Data data = (Data)value;
            if (data.getData() == null) {
                return null;
            }
            Long id = data.getId();
            data.setId(null);
            String res = ff.valueToString(value);
            data.setId(id);
            return res;
        }
        return ff.valueToEncodedString(value, new ClassicEncodingSettings(false, true));
    }

    public static Charset detectCharset(byte[] data) {
        return StringUtils.UTF8_CHARSET;
    }

    public static String createRecordKeyString(DataRecord record, Integer rowNumber, String keyField) {
        List<Object> keyFields = Collections.emptyList();
        if (record != null) {
            boolean autoKeyFields = keyField == null;
            List<String> list = keyFields = autoKeyFields ? record.getFormat().getKeyFields() : Collections.singletonList(keyField);
        }
        if (keyFields.isEmpty()) {
            return Integer.toString(rowNumber);
        }
        return record.getValueAsString((String)keyFields.get(0));
    }

    public static DataTable processBindings(DataTable table, Evaluator evaluator) {
        return DataTableUtils.processBindings(table, evaluator, null, false);
    }

    public static DataTable processBindings(DataTable table, Evaluator evaluator, ErrorCollector errorCollector) {
        return DataTableUtils.processBindings(table, evaluator, errorCollector, false);
    }

    public static DataTable processBindings(DataTable table, Evaluator evaluator, ErrorCollector errorCollector, boolean split) {
        DataTable result;
        if (table == null) {
            return table;
        }
        if (table.getFormat().getBindings().isEmpty()) {
            return table;
        }
        if (split) {
            result = table.clone();
            result.splitFormat();
        } else {
            result = table;
        }
        evaluator.getDefaultResolver().setDefaultTable(result);
        DefaultBindingProcessor processor = new DefaultBindingProcessor(new DataTableBindingProvider(result, errorCollector), evaluator);
        processor.start();
        return result;
    }

    public static void processBindingsForAllRows(DataTable table, Evaluator evaluator, ErrorCollector errorCollector) {
        for (DataRecord rec : table) {
            DataTableUtils.processBindings(rec.wrap(), evaluator, errorCollector, false);
        }
    }

    public static boolean isEncodedTable(String string) {
        return string != null && !string.isEmpty() && string.charAt(0) == '\u001c';
    }

    public static void removeFieldsWithBindings(TableFormat format, String[] fieldsToRemove) {
        List<Binding> bindings = format.getBindings();
        LinkedList<Binding> bindingsToRemove = new LinkedList<Binding>();
        for (String fieldToRemove : fieldsToRemove) {
            for (Binding binding : bindings) {
                if (!binding.getTarget().getImage().contains(fieldToRemove)) continue;
                bindingsToRemove.add(binding);
            }
            format.removeField(fieldToRemove);
        }
        for (Binding bindingToRemove : bindingsToRemove) {
            format.removeBinding(bindingToRemove);
        }
    }

    public static boolean isOneValueFormat(TableFormat format) {
        if (format == null) {
            return false;
        }
        int maxRec = format.getMaxRecords();
        int minRec = format.getMinRecords();
        int fieldCount = format.getFieldCount();
        if (maxRec == 1 && minRec == 1 && fieldCount == 1) {
            return format.getField(0).getType() != 'T';
        }
        return false;
    }

    public static String prettyPrint(DataTable table) {
        return DataTableUtils.prettyPrint(table, 10);
    }

    public static String prettyPrint(DataTable table, int maxRecords) {
        return DataTableUtils.prettyPrint(table, maxRecords, 15);
    }

    public static String prettyPrint(DataTable table, int maxRecords, int columnWidthChars) {
        if (table.getRecordCount() == 1) {
            return DataTableUtils.transposedTable(table, maxRecords, columnWidthChars);
        }
        StringBuilder sb = new StringBuilder(" ");
        for (FieldFormat fieldFormat : table.getFormat().getFields()) {
            StringBuilder name = DataTableUtils.limit(fieldFormat.getName(), columnWidthChars);
            sb.append((CharSequence)name).append(" | ");
        }
        int headerLength = sb.length();
        sb.append('\n');
        char[] divider = DataTableUtils.fill('-', headerLength - 1);
        sb.append(' ').append(divider).append('\n');
        int recordIndex = 0;
        for (DataRecord record : table) {
            sb.append(' ');
            for (int fieldIndex = 0; fieldIndex < record.getFieldCount(); ++fieldIndex) {
                StringBuilder value = DataTableUtils.limit(record.getValueAsString(fieldIndex), columnWidthChars);
                sb.append((CharSequence)value).append(" | ");
            }
            sb.append('\n');
            if (++recordIndex < maxRecords) continue;
            sb.append(' ').append("\u2026\n");
            break;
        }
        return sb.toString();
    }

    private static String transposedTable(DataTable table, int maxRecords, int columnWidthChars) {
        StringBuilder sb = new StringBuilder(" ").append((CharSequence)DataTableUtils.limit("Name", columnWidthChars)).append(" = ").append((CharSequence)DataTableUtils.limit("Value", columnWidthChars)).append('\n');
        int headerWidth = sb.length() - 1;
        char[] divider = DataTableUtils.fill('-', headerWidth);
        sb.append(' ').append(divider).append('\n');
        TableFormat format = table.getFormat();
        DataRecord firstRecord = table.getRecord(0);
        int rowsLimit = Math.min(maxRecords, format.getFieldCount());
        for (int row = 0; row < rowsLimit; ++row) {
            StringBuilder name = DataTableUtils.limit(format.getField(row).getName(), columnWidthChars);
            sb.append(' ').append((CharSequence)name).append(" = ");
            StringBuilder value = DataTableUtils.limit(firstRecord.getValueAsString(row), columnWidthChars);
            sb.append((CharSequence)value).append('\n');
        }
        if (maxRecords < format.getFieldCount()) {
            sb.append(' ').append("\u2026\n");
        }
        return sb.toString();
    }

    private static StringBuilder limit(String string, int limit) {
        if (string == null) {
            string = "";
        }
        StringBuilder sb = new StringBuilder(string);
        if (string.length() <= limit) {
            int tailLength = limit - string.length();
            char[] tailChars = DataTableUtils.fill(' ', tailLength);
            return sb.append(tailChars);
        }
        return sb.delete(limit - 1, string.length()).append("\u2026");
    }

    private static char[] fill(char filler, int count) {
        char[] fillBuff = new char[count];
        Arrays.fill(fillBuff, filler);
        return fillBuff;
    }

    static {
        EDITOR_SELECTION_VALUES.put(null, Cres.get().getString("default"));
        EDITOR_SELECTION_VALUES.put("list", Cres.get().getString("dtEditorList"));
        EDITOR_SELECTION_VALUES.put("date", Cres.get().getString("date"));
        EDITOR_SELECTION_VALUES.put("time", Cres.get().getString("time"));
        EDITOR_SELECTION_VALUES.put("bar", Cres.get().getString("dtEditorBar"));
        EDITOR_SELECTION_VALUES.put("bytes", Cres.get().getString("dtEditorBytes"));
        EDITOR_SELECTION_VALUES.put("formatString", Cres.get().getString("dtEditorFormatValue"));
        EDITOR_SELECTION_VALUES.put("instance", Cres.get().getString("dtEditorInstance"));
        EDITOR_SELECTION_VALUES.put("period", Cres.get().getString("dtEditorPeriod"));
        EDITOR_SELECTION_VALUES.put("foreignInstance", Cres.get().getString("dtEditorForeignInstance"));
        EDITOR_SELECTION_VALUES.put("expression", Cres.get().getString("expression"));
        EDITOR_SELECTION_VALUES.put("functionselector", Cres.get().getString("functionSelector"));
        EDITOR_SELECTION_VALUES.put("password", Cres.get().getString("password"));
        EDITOR_SELECTION_VALUES.put("text", Cres.get().getString("dtEditorTextEditor"));
        EDITOR_SELECTION_VALUES.put("html", Cres.get().getString("dtEditorHtml"));
        EDITOR_SELECTION_VALUES.put("textarea", Cres.get().getString("dtEditorTextArea"));
        EDITOR_SELECTION_VALUES.put("etextarea", Cres.get().getString("dtEditorEmbeddedTextArea"));
        EDITOR_SELECTION_VALUES.put("context", Cres.get().getString("context"));
        EDITOR_SELECTION_VALUES.put("contextmask", Cres.get().getString("conContextMask"));
        EDITOR_SELECTION_VALUES.put("font", Cres.get().getString("font"));
        EDITOR_SELECTION_VALUES.put("ip", Cres.get().getString("dtEditorIp"));
        EDITOR_SELECTION_VALUES.put("box", Cres.get().getString("dtEditorBox"));
        EDITOR_SELECTION_VALUES.put("image", Cres.get().getString("image"));
        EDITOR_SELECTION_VALUES.put("sound", Cres.get().getString("sound"));
        EDITOR_SELECTION_VALUES.put("hex", Cres.get().getString("dtEditorHex"));
        EDITOR_SELECTION_VALUES.put("reference", Cres.get().getString("dtEditorReference"));
        EDITOR_SELECTION_VALUES.put("activator", Cres.get().getString("activator"));
        EDITOR_SELECTION_VALUES.put("code", Cres.get().getString("dtEditorCodeEditor"));
        EDITOR_SELECTION_VALUES.put("spinner", Cres.get().getString("wSpinner"));
        EDITOR_SELECTION_VALUES.put("eventLevel", Cres.get().getString("efEventLevel"));
        EDITOR_SELECTION_VALUES.put("dateRange", Cres.get().getString("dtEditorDateRange"));
        VALIDATOR_SELECTION_VALUES = new LinkedHashMap<Object, String>();
        VALIDATOR_SELECTION_VALUES.put(null, Cres.get().getString("default"));
        VALIDATOR_SELECTION_VALUES.put(String.valueOf('I'), Cres.get().getString("dtIdValidator"));
        VALIDATOR_SELECTION_VALUES.put(String.valueOf('L'), Cres.get().getString("dtLimitsValidator"));
        VALIDATOR_SELECTION_VALUES.put(String.valueOf('N'), Cres.get().getString("dtNonNullValidator"));
        VALIDATOR_SELECTION_VALUES.put(String.valueOf('R'), Cres.get().getString("dtRegexValidator"));
        VALIDATOR_SELECTION_VALUES.put(String.valueOf('E'), Cres.get().getString("dtExpressionValidator"));
    }

    public static enum FilterMode {
        TEXT,
        REGEXP,
        EXPRESSION;

    }
}

