/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable;

import com.tibbo.aggregate.common.datatable.SortOrder;
import com.tibbo.aggregate.common.datatable.TableFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DataTableSorter
implements Iterable<SortOrder> {
    public static final DataTableSorter EMPTY_SORTER = new DataTableSorter(Collections.emptyList());
    private final List<SortOrder> orders = new LinkedList<SortOrder>();

    public DataTableSorter(SortOrder ... orders) {
        this.orders.addAll(Arrays.asList(orders));
    }

    public DataTableSorter(List<SortOrder> orders) {
        this.orders.addAll(orders);
    }

    public boolean isEmpty() {
        return this.orders.isEmpty();
    }

    public List<SortOrder> getOrders() {
        return this.orders;
    }

    public void addOrder(SortOrder order) {
        this.orders.add(order);
    }

    @Override
    public Iterator<SortOrder> iterator() {
        return this.orders.iterator();
    }

    public DataTableSorter fitTo(TableFormat format) {
        LinkedList<SortOrder> newOrders = null;
        int startIndex = 0;
        int endIndex = 0;
        boolean foundCommonFields = false;
        for (SortOrder order : this.orders) {
            if (format.hasField(order.getField())) {
                ++endIndex;
                foundCommonFields = true;
                continue;
            }
            if (!foundCommonFields) continue;
            if (newOrders == null) {
                newOrders = new LinkedList<SortOrder>();
            }
            newOrders.addAll(this.orders.subList(startIndex, endIndex));
            startIndex = ++endIndex;
        }
        if (newOrders != null) {
            return new DataTableSorter(newOrders);
        }
        return foundCommonFields ? this : EMPTY_SORTER;
    }
}

