/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.datatable.AbstractDataTable;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableQuery;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.QueryCondition;
import com.tibbo.aggregate.common.util.CloneUtils;
import com.tibbo.aggregate.common.util.Util;
import java.awt.Color;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataTableReplication {
    private static final Pattern COLOR_PATTERN = Pattern.compile("#([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})");
    private static final int HEX_RADIX = 16;

    public static Set<String> copy(DataTable source, DataTable target) {
        return DataTableReplication.copy(source, target, false, false, true, true, false, null);
    }

    public static Set<String> copy(DataTable source, DataTable target, boolean copyReadOnlyFields) {
        return DataTableReplication.copy(source, target, copyReadOnlyFields, false, true, true, false, null);
    }

    public static Set<String> copy(DataTable source, DataTable target, boolean copyReadOnlyFields, boolean copyNonReplicatableFields) {
        return DataTableReplication.copy(source, target, copyReadOnlyFields, copyNonReplicatableFields, true, true, false, null);
    }

    public static Set<String> copy(DataTable source, DataTable target, boolean copyReadOnlyFields, boolean copyNonReplicatableFields, boolean removeRecordsFromTarget) {
        return DataTableReplication.copy(source, target, copyReadOnlyFields, copyNonReplicatableFields, removeRecordsFromTarget, true, false, null);
    }

    public static Set<String> copy(DataTable source, DataTable target, boolean copyReadOnlyFields, boolean copyNonReplicatableFields, boolean removeRecordsFromTarget, boolean addRecordsToTarget) {
        return DataTableReplication.copy(source, target, copyReadOnlyFields, copyNonReplicatableFields, removeRecordsFromTarget, addRecordsToTarget, false, null);
    }

    public static Set<String> copy(DataTable source, DataTable target, boolean copyReadOnlyFields, boolean copyNonReplicatableFields, boolean removeRecordsFromTarget, boolean addRecordsToTarget, boolean ignoreUnresizable) {
        return DataTableReplication.copy(source, target, copyReadOnlyFields, copyNonReplicatableFields, removeRecordsFromTarget, addRecordsToTarget, ignoreUnresizable, null);
    }

    public static Set<String> copy(DataTable source, DataTable target, boolean copyReadOnlyFields, boolean copyNonReplicatableFields, boolean removeRecordsFromTarget, boolean addRecordsToTarget, boolean ignoreUnresizable, Collection<String> fields) {
        if (target.getFormat().getKeyFields().size() == 0) {
            return DataTableReplication.copyWithoutKeyFields(source, target, copyReadOnlyFields, copyNonReplicatableFields, removeRecordsFromTarget, addRecordsToTarget, ignoreUnresizable, fields);
        }
        return DataTableReplication.copyWithKeyFields(source, target, copyReadOnlyFields, copyNonReplicatableFields, removeRecordsFromTarget, addRecordsToTarget, ignoreUnresizable, fields);
    }

    public static Set<String> copyWithKeyFields(DataTable source, DataTable target, boolean copyReadOnlyFields, boolean copyNonReplicatableFields, boolean removeRecordsFromTarget, boolean addRecordsToTarget, boolean ignoreUnresizable, Collection<String> fields) {
        DataTableQuery query;
        LinkedHashSet<String> errors = new LinkedHashSet<String>();
        List<String> keyFields = target.getFormat().getKeyFields();
        for (String fieldName : keyFields) {
            if (source.getFormat().hasField(fieldName)) continue;
            return DataTableReplication.copyWithoutKeyFields(source, target, copyReadOnlyFields, copyNonReplicatableFields, removeRecordsFromTarget, addRecordsToTarget, ignoreUnresizable, fields);
        }
        String singleKeyField = null;
        HashMap<Object, DataRecord> sourceLookup = null;
        HashMap<Object, DataRecord> targetLookup = null;
        if (keyFields.size() == 1) {
            singleKeyField = keyFields.get(0);
            sourceLookup = new HashMap<Object, DataRecord>();
            for (DataRecord cur : source) {
                sourceLookup.put(cur.getValue(singleKeyField), cur);
            }
            targetLookup = new HashMap<Object, DataRecord>();
            for (DataRecord cur : target) {
                targetLookup.put(cur.getValue(singleKeyField), cur);
            }
        }
        Iterator<DataRecord> iter = target.iterator();
        while (iter.hasNext()) {
            DataRecord sourceRec;
            DataRecord targetRec = iter.next();
            if (singleKeyField != null) {
                sourceRec = (DataRecord)sourceLookup.get(targetRec.getValue(singleKeyField));
            } else {
                query = new DataTableQuery(new QueryCondition[0]);
                for (String keyField : keyFields) {
                    query.addCondition(new QueryCondition(keyField, targetRec.getValue(keyField)));
                }
                sourceRec = source.select(query);
            }
            if (!removeRecordsFromTarget || sourceRec != null || !ignoreUnresizable && target.getFormat().isUnresizable()) continue;
            if (target.getRecordCount() > target.getFormat().getMinRecords()) {
                iter.remove();
                continue;
            }
            if (source.getFormat().getMinRecords() == source.getFormat().getMaxRecords()) break;
            errors.add(Cres.get().getString("dtTargetTableMinRecordsReached"));
            break;
        }
        for (DataRecord sourceRec : source) {
            DataRecord targetRec;
            if (singleKeyField != null) {
                targetRec = (DataRecord)targetLookup.get(sourceRec.getValue(singleKeyField));
            } else {
                query = new DataTableQuery(new QueryCondition[0]);
                for (String keyField : keyFields) {
                    query.addCondition(new QueryCondition(keyField, sourceRec.getValue(keyField)));
                }
                targetRec = target.select(query);
            }
            if (targetRec == null) {
                if (!addRecordsToTarget || !ignoreUnresizable && target.getFormat().isUnresizable()) continue;
                if (target.getRecordCount() < target.getFormat().getMaxRecords()) {
                    DataRecord newRec = new DataRecord(target.getFormat());
                    errors.addAll(DataTableReplication.copyRecord(sourceRec, newRec, copyReadOnlyFields, copyNonReplicatableFields, removeRecordsFromTarget, addRecordsToTarget, fields));
                    try {
                        target.addRecord(newRec);
                    }
                    catch (Exception ex) {
                        errors.add(Cres.get().getString("dtCannotAddRecord") + (ex.getMessage() != null ? ex.getMessage() : ex.toString()));
                    }
                    continue;
                }
                if (source.getFormat().getMinRecords() == source.getFormat().getMaxRecords()) continue;
                errors.add(Cres.get().getString("dtTargetTableMaxRecordsReached"));
                continue;
            }
            errors.addAll(DataTableReplication.copyRecord(sourceRec, targetRec, copyReadOnlyFields, copyNonReplicatableFields, removeRecordsFromTarget, addRecordsToTarget, fields));
        }
        DataTableReplication.copyTimestampAndQuality(source, target);
        return errors;
    }

    public static Set<String> copyWithoutKeyFields(DataTable source, DataTable target, boolean copyReadOnlyFields, boolean copyNonReplicatableFields, boolean removeRecordsFromTarget, boolean addRecordsToTarget, boolean ignoreUnresizable, Collection<String> fields) {
        int i;
        LinkedHashSet<String> errors = new LinkedHashSet<String>();
        if (removeRecordsFromTarget && (ignoreUnresizable || !target.getFormat().isUnresizable())) {
            while (target.getRecordCount() > source.getRecordCount()) {
                if (target.getRecordCount() > target.getFormat().getMinRecords()) {
                    target.removeRecord(target.getRecordCount() - 1);
                    continue;
                }
                if (source.getFormat().getMinRecords() == source.getFormat().getMaxRecords()) break;
                errors.add(Cres.get().getString("dtTargetTableMinRecordsReached"));
                break;
            }
        }
        for (i = 0; i < Math.min(source.getRecordCount(), target.getRecordCount()); ++i) {
            DataRecord srcRec = source.getRecord(i);
            DataRecord tgtRec = target.getRecord(i);
            errors.addAll(DataTableReplication.copyRecord(srcRec, tgtRec, copyReadOnlyFields, copyNonReplicatableFields, removeRecordsFromTarget, addRecordsToTarget, fields));
        }
        if (addRecordsToTarget && (ignoreUnresizable || !target.getFormat().isUnresizable()) && source.getRecordCount() > target.getRecordCount()) {
            for (i = target.getRecordCount().intValue(); i < Math.min(target.getFormat().getMaxRecords(), source.getRecordCount()); ++i) {
                errors.addAll(DataTableReplication.copyRecord(source.getRecord(i), target.addRecord(), copyReadOnlyFields, copyNonReplicatableFields, removeRecordsFromTarget, addRecordsToTarget, fields));
            }
        }
        if (source.getRecordCount() > target.getFormat().getMaxRecords() && source.getFormat().getMinRecords() != source.getFormat().getMaxRecords()) {
            errors.add(Cres.get().getString("dtTargetTableMaxRecordsReached"));
        }
        DataTableReplication.copyTimestampAndQuality(source, target);
        return errors;
    }

    public static void copyTimestampAndQuality(DataTable source, DataTable target) {
        if (source.getTimestamp() != null) {
            target.setTimestamp(source.getTimestamp());
        }
        if (source.getQuality() != null) {
            target.setQuality(source.getQuality());
        }
    }

    public static Set<String> copyRecord(DataRecord source, DataRecord target) {
        return DataTableReplication.copyRecord(source, target, false, false, true, true, null);
    }

    public static Set<String> copyRecord(DataRecord source, DataRecord target, boolean copyReadOnlyFields, boolean copyNonReplicatableFields) {
        return DataTableReplication.copyRecord(source, target, copyReadOnlyFields, copyNonReplicatableFields, true, true, null);
    }

    public static Set<String> copyRecord(DataRecord source, DataRecord target, boolean copyReadOnlyFields, boolean copyNonReplicatableFields, Collection<String> fields) {
        return DataTableReplication.copyRecord(source, target, copyReadOnlyFields, copyNonReplicatableFields, true, true, fields);
    }

    public static Set<String> copyRecord(DataRecord source, DataRecord target, boolean copyReadOnlyFields, boolean copyNonReplicatableFields, boolean removeRecordsFromTarget, boolean addRecordsToTarget, Collection<String> fields) {
        LinkedHashSet<String> errors = new LinkedHashSet<String>();
        for (FieldFormat tgtFf : target.getFormat()) {
            String fieldName = tgtFf.getName();
            FieldFormat srcFf = null;
            srcFf = source.getFormat().getField(fieldName);
            if (fields != null && !fields.contains(tgtFf.getName()) || srcFf == null || tgtFf.isReadonly() && !copyReadOnlyFields || !copyNonReplicatableFields && (tgtFf.isNotReplicated() || srcFf.isNotReplicated())) continue;
            try {
                if (srcFf.getType() == 'T' && tgtFf.getType() == 'T') {
                    DataTable sourceTable = source.getDataTable(fieldName);
                    DataTable targetTable = target.getDataTable(fieldName);
                    if (sourceTable != null && targetTable != null) {
                        if (Util.equals(targetTable.getFormat(), AbstractDataTable.DEFAULT_FORMAT)) {
                            target.setValue(fieldName, (Object)sourceTable.clone());
                            continue;
                        }
                        errors.addAll(DataTableReplication.copy(sourceTable, targetTable, copyReadOnlyFields, copyNonReplicatableFields, removeRecordsFromTarget, addRecordsToTarget));
                        target.setValue(fieldName, (Object)targetTable);
                        continue;
                    }
                } else if (srcFf.getType() == 'S' && tgtFf.getType() == 'C') {
                    String srcValue = source.getString(fieldName);
                    Color tgtValue = DataTableReplication.getColorFromString(srcValue);
                    if (tgtValue != null) {
                        target.setValue(fieldName, (Object)tgtValue);
                        continue;
                    }
                    target.setValue(fieldName, tgtFf.valueFromString(srcFf.valueToString(source.getValue(fieldName))));
                    continue;
                }
                if (srcFf.getFieldWrappedClass().equals(tgtFf.getFieldWrappedClass())) {
                    target.setValue(fieldName, CloneUtils.genericClone(source.getValue(fieldName)));
                    continue;
                }
                String strValue = srcFf.valueToString(source.getValue(fieldName));
                if (strValue == null) {
                    target.setValue(fieldName, null);
                    continue;
                }
                target.setValue(fieldName, tgtFf.valueFromString(strValue));
            }
            catch (Exception ex2) {
                String msg = MessageFormat.format(Cres.get().getString("dtErrCopyingField"), fieldName);
                Log.DATATABLE.debug((Object)msg, (Throwable)ex2);
                errors.add(msg + ": " + ex2.getMessage());
            }
        }
        return errors;
    }

    private static Color getColorFromString(String colorString) {
        if (colorString == null) {
            return null;
        }
        Matcher matcher = COLOR_PATTERN.matcher(colorString);
        if (matcher.matches()) {
            try {
                int r = Integer.parseInt(matcher.group(1), 16);
                int g = Integer.parseInt(matcher.group(2), 16);
                int b = Integer.parseInt(matcher.group(3), 16);
                return new Color(r, g, b);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }
}

