/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.datatable.DataTable;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DataTableRegistry {
    private long currentId = 0L;
    private final Map<Long, SoftReference<DataTable>> dataTables = new WeakHashMap<Long, SoftReference<DataTable>>(100);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long add(DataTable table) {
        this.lock.writeLock().lock();
        try {
            if (table == null) {
                throw new IllegalArgumentException("Data table is null");
            }
            long id = this.currentId++;
            table.setId(id);
            this.dataTables.put(id, new SoftReference<DataTable>(table));
            if (Log.DATATABLE.isDebugEnabled()) {
                if (!table.isImmutable()) {
                    Log.DATATABLE.debug((Object)("Added mutable table '" + table + "' to the data table registry as #" + id));
                } else {
                    Log.DATATABLE.debug((Object)("Added table '" + table + "' to the data table registry as #" + id));
                }
            }
            long l = id;
            return l;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public DataTable get(Long id) {
        DataTable result;
        this.lock.readLock().lock();
        try {
            result = this.dataTables.get(id).get();
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (result == null) {
            throw new IllegalStateException("No data table with id #" + id + " was found in the data table registry");
        }
        return result;
    }

    public void close(Long id) {
        try {
            this.lock.writeLock().lock();
            this.dataTables.remove(id);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

