/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.binding.Binding;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableUtils;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.converter.editor.EditorOptionsUtils;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.datatable.validator.AbstractFieldValidator;
import com.tibbo.aggregate.common.datatable.validator.LimitsValidator;
import com.tibbo.aggregate.common.datatable.validator.TableExpressionValidator;
import com.tibbo.aggregate.common.datatable.validator.TableKeyFieldsValidator;
import com.tibbo.aggregate.common.datatable.validator.ValidatorHelper;
import com.tibbo.aggregate.common.expression.function.DefaultFunctions;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;

public class DataTableBuilding {
    public static final String FIELD_TABLE_FORMAT_MIN_RECORDS = "minRecords";
    public static final String FIELD_TABLE_FORMAT_MAX_RECORDS = "maxRecords";
    public static final String FIELD_TABLE_FORMAT_FIELDS = "fields";
    public static final String FIELD_TABLE_FORMAT_REORDERABLE = "reorderable";
    public static final String FIELD_TABLE_FORMAT_UNRESIZABLE = "unresizable";
    public static final String FIELD_TABLE_FORMAT_BINDINGS = "bindings";
    public static final String FIELD_TABLE_FORMAT_ENCODED = "encoded";
    public static final String FIELD_TABLE_FORMAT_NAMING_EXPRESSION = "namingExpression";
    public static final String FIELD_FIELDS_FORMAT_OLDNAME = "oldname";
    public static final String FIELD_FIELDS_FORMAT_NAME = "name";
    public static final String FIELD_FIELDS_FORMAT_TYPE = "type";
    public static final String FIELD_FIELDS_FORMAT_DESCRIPTION = "description";
    public static final String FIELD_FIELDS_FORMAT_GROUP = "group";
    public static final String FIELD_FIELDS_FORMAT_DEFAULT_VALUE = "defaultValue";
    public static final String FIELD_FIELDS_FORMAT_HIDDEN = "hidden";
    public static final String FIELD_FIELDS_FORMAT_INLINE = "inline";
    public static final String FIELD_FIELDS_FORMAT_ENCRYPTED = "encrypted";
    public static final String FIELD_FIELDS_FORMAT_READONLY = "readonly";
    public static final String FIELD_FIELDS_FORMAT_NULLABLE = "nullable";
    public static final String FIELD_FIELDS_FORMAT_KEY = "key";
    public static final String FIELD_FIELDS_FORMAT_SELVALS = "selvals";
    public static final String FIELD_FIELDS_FORMAT_EXTSELVALS = "extselvals";
    public static final String FIELD_FIELDS_FORMAT_HELP = "help";
    public static final String FIELD_FIELDS_FORMAT_EDITOR = "editor";
    public static final String FIELD_FIELDS_FORMAT_EDITOR_OPTIONS = "editorOptions";
    public static final String FIELD_FIELDS_FORMAT_VALIDATORS = "validators";
    public static final String FIELD_SELECTION_VALUES_VALUE = "value";
    public static final String FIELD_SELECTION_VALUES_DESCRIPTION = "description";
    public static final String FIELD_BINDINGS_TARGET = "target";
    public static final String FIELD_BINDINGS_EXPRESSION = "expression";
    public static final String FIELD_VALIDATORS_VALIDATOR = "validator";
    public static final String FIELD_VALIDATORS_OPTIONS = "options";
    public static final TableFormat SELECTION_VALUES_FORMAT = new TableFormat(true);
    public static final TableFormat BINDINGS_FORMAT;
    public static final TableFormat VALIDATORS_FORMAT;
    public static final String FIELD_EDITOR_OPTIONS_SIMPLE_FORMAT_OPTIONS = "options";
    public static final TableFormat EDITOR_OPTIONS_SIMPLE_FORMAT;
    public static final TableFormat FIELDS_FORMAT;
    public static final TableFormat TABLE_FORMAT;

    public static TableFormat createTableFormat(DataTable formatTable) throws ContextException {
        return DataTableBuilding.createTableFormat(formatTable, null, false);
    }

    public static TableFormat createTableFormat(DataTable formatTable, ClassicEncodingSettings settings, boolean allowNull) throws ContextException {
        DataRecord rec = formatTable.rec();
        int minRecords = rec.getInt(FIELD_TABLE_FORMAT_MIN_RECORDS);
        int maxRecords = rec.getInt(FIELD_TABLE_FORMAT_MAX_RECORDS);
        DataTable fields = rec.getDataTable(FIELD_TABLE_FORMAT_FIELDS);
        if (allowNull && fields.getRecordCount() == 0) {
            return null;
        }
        boolean reorderable = rec.getBoolean(FIELD_TABLE_FORMAT_REORDERABLE);
        boolean unresizable = rec.getBoolean(FIELD_TABLE_FORMAT_UNRESIZABLE);
        DataTable bindings = rec.getDataTable(FIELD_TABLE_FORMAT_BINDINGS);
        TableFormat format = DataTableBuilding.createTableFormat(minRecords, maxRecords, reorderable, fields, settings);
        format.setUnresizable(unresizable);
        for (DataRecord binding : bindings) {
            format.addBinding(binding.getString(FIELD_BINDINGS_TARGET), binding.getString(FIELD_BINDINGS_EXPRESSION));
        }
        if (rec.getString(FIELD_TABLE_FORMAT_NAMING_EXPRESSION) != null) {
            format.setNamingExpression(rec.getString(FIELD_TABLE_FORMAT_NAMING_EXPRESSION));
        }
        return format;
    }

    public static TableFormat createTableFormat(int minRecords, int maxRecords, boolean reorderable, DataTable fields, ClassicEncodingSettings settings) throws ContextException {
        TableFormat rf = new TableFormat(reorderable);
        rf.setMinRecords(minRecords);
        rf.setMaxRecords(maxRecords);
        boolean hasKeys = false;
        for (DataRecord fdata : fields) {
            DataTable validators;
            FieldFormat ff = FieldFormat.create(fdata.getString(FIELD_FIELDS_FORMAT_NAME), fdata.getString(FIELD_FIELDS_FORMAT_TYPE).charAt(0));
            ff.setDescription(fdata.getString("description"));
            ff.setHelp(fdata.getString(FIELD_FIELDS_FORMAT_HELP));
            String def = fdata.getString(FIELD_FIELDS_FORMAT_DEFAULT_VALUE);
            if (def != null && def.length() > 0) {
                ff.setDefault(ff.valueFromString(def, settings, true));
            }
            ff.setReadonly(fdata.getBoolean(FIELD_FIELDS_FORMAT_READONLY));
            ff.setNullable(fdata.getBoolean(FIELD_FIELDS_FORMAT_NULLABLE));
            if (fdata.hasField(FIELD_FIELDS_FORMAT_HIDDEN)) {
                ff.setHidden(fdata.getBoolean(FIELD_FIELDS_FORMAT_HIDDEN));
            }
            if (fdata.hasField(FIELD_FIELDS_FORMAT_INLINE)) {
                ff.setInlineData(fdata.getBoolean(FIELD_FIELDS_FORMAT_INLINE));
            }
            if (fdata.hasField(FIELD_FIELDS_FORMAT_ENCRYPTED)) {
                ff.setEncrypted(fdata.getBoolean(FIELD_FIELDS_FORMAT_ENCRYPTED));
            }
            if (fdata.hasField("description")) {
                ff.setDescription(fdata.getString("description"));
            }
            if (fdata.hasField(FIELD_FIELDS_FORMAT_GROUP)) {
                ff.setGroup(fdata.getString(FIELD_FIELDS_FORMAT_GROUP));
            }
            boolean key = fdata.getFormat().hasField(FIELD_FIELDS_FORMAT_KEY) ? fdata.getBoolean(FIELD_FIELDS_FORMAT_KEY) : false;
            ff.setKeyField(key);
            if (key) {
                hasKeys = true;
            }
            DataTable selVals = fdata.getDataTable(FIELD_FIELDS_FORMAT_SELVALS);
            ff.setExtendableSelectionValues(fdata.getBoolean(FIELD_FIELDS_FORMAT_EXTSELVALS));
            if (selVals.getRecordCount() > 0) {
                LinkedHashMap sv = new LinkedHashMap();
                for (DataRecord rec : selVals) {
                    String val = rec.getString(FIELD_SELECTION_VALUES_VALUE);
                    sv.put(val != null ? (Object)ff.valueFromString(val) : null, rec.getString("description"));
                }
                if (!(ff.isExtendableSelectionValues() || sv.containsKey(ff.getDefaultValue()) || def == null && !ff.isNullable())) {
                    sv.put(def != null ? (Object)ff.valueFromString(def) : null, def != null ? def.toString() : Cres.get().getString("dtNullCell"));
                }
                ff.setSelectionValues(sv);
            }
            ff.setEditor(fdata.getString(FIELD_FIELDS_FORMAT_EDITOR));
            if (fdata.hasField(FIELD_FIELDS_FORMAT_EDITOR_OPTIONS)) {
                String eo = EditorOptionsUtils.convertToString(fdata);
                ff.setEditorOptions(eo);
            }
            if ((validators = fdata.getDataTable(FIELD_FIELDS_FORMAT_VALIDATORS)) != null) {
                for (DataRecord validator : validators) {
                    try {
                        Constructor<AbstractFieldValidator> contructor;
                        String type = validator.getString(FIELD_VALIDATORS_VALIDATOR);
                        String options = validator.getString("options");
                        if (type == null) continue;
                        if (options != null && !options.isEmpty()) {
                            if (type.equals(String.valueOf('L'))) {
                                contructor = FieldFormat.getValidatorToTypeMap().get(type).getConstructor(FieldFormat.class, String.class);
                                ff.addValidator(contructor.newInstance(ff, options));
                                continue;
                            }
                            contructor = FieldFormat.getValidatorToTypeMap().get(type).getConstructor(String.class);
                            ff.addValidator(contructor.newInstance(options));
                            continue;
                        }
                        contructor = FieldFormat.getValidatorToTypeMap().get(type).getConstructor(new Class[0]);
                        ff.addValidator(contructor.newInstance(new Object[0]));
                    }
                    catch (Exception ex) {
                        Log.DATATABLE.error((Object)"Error validating data table field", (Throwable)ex);
                    }
                }
            }
            rf.addField(ff);
        }
        if (hasKeys) {
            rf.addTableValidator(new TableKeyFieldsValidator());
        }
        return rf;
    }

    public static DataTable formatToFieldsTable(TableFormat tf, boolean readOnly) {
        return DataTableBuilding.formatToFieldsTable(tf, readOnly, null);
    }

    public static DataTable formatToFieldsTable(TableFormat tf, boolean readOnly, ClassicEncodingSettings settings) {
        return DataTableBuilding.formatToFieldsTable(tf, readOnly, settings, true);
    }

    public static DataTable formatToFieldsTable(TableFormat tf, boolean readOnly, ClassicEncodingSettings settings, boolean ignoreHiddenFields) {
        SimpleDataTable res = new SimpleDataTable(FIELDS_FORMAT);
        for (FieldFormat ff : tf) {
            String help;
            if (ignoreHiddenFields && ff.isHidden()) continue;
            SimpleDataTable selVals = new SimpleDataTable(SELECTION_VALUES_FORMAT);
            if (ff.getSelectionValues() != null) {
                for (Object value : ff.getSelectionValues().keySet()) {
                    selVals.addRecord(ff.valueToString(value, settings), ff.getSelectionValues().get(value));
                }
            }
            SimpleDataTable validators = new SimpleDataTable(VALIDATORS_FORMAT);
            if (ff.getValidators() != null) {
                Object value;
                value = ff.getValidators().iterator();
                while (value.hasNext()) {
                    Object validator = value.next();
                    validators.addRecord(((AbstractFieldValidator)validator).getType(), ((AbstractFieldValidator)validator).encode());
                }
            }
            DataRecord rec = res.addRecord();
            String type = String.valueOf(ff.getType());
            String helpTxt = help = ff.getHelp();
            if (help != null) {
                Pattern HelpTxtPattern = Pattern.compile("[\\p{Cntrl}[^\\p{Graph}]]", 256);
                helpTxt = HelpTxtPattern.matcher(helpTxt).replaceAll(" ");
            }
            rec.setValue(FIELD_FIELDS_FORMAT_OLDNAME, (Object)ff.getName());
            rec.setValue(FIELD_FIELDS_FORMAT_NAME, (Object)ff.getName());
            rec.setValue(FIELD_FIELDS_FORMAT_TYPE, (Object)type);
            rec.setValue("description", (Object)ff.getDescription());
            rec.setValue(FIELD_FIELDS_FORMAT_DEFAULT_VALUE, (Object)ff.valueToString(ff.getDefaultValue(), settings));
            rec.setValue(FIELD_FIELDS_FORMAT_READONLY, (Object)(readOnly || ff.isReadonly() ? 1 : 0));
            rec.setValue(FIELD_FIELDS_FORMAT_NULLABLE, (Object)ff.isNullable());
            rec.setValue(FIELD_FIELDS_FORMAT_KEY, (Object)ff.isKeyField());
            rec.setValue(FIELD_FIELDS_FORMAT_SELVALS, (Object)selVals);
            rec.setValue(FIELD_FIELDS_FORMAT_EXTSELVALS, (Object)ff.isExtendableSelectionValues());
            rec.setValue(FIELD_FIELDS_FORMAT_HIDDEN, (Object)ff.isHidden());
            rec.setValue(FIELD_FIELDS_FORMAT_INLINE, (Object)ff.isInlineData());
            rec.setValue(FIELD_FIELDS_FORMAT_ENCRYPTED, (Object)ff.isEncrypted());
            rec.setValue(FIELD_FIELDS_FORMAT_HELP, (Object)helpTxt);
            rec.setValue(FIELD_FIELDS_FORMAT_GROUP, (Object)ff.getGroup());
            rec.setValue(FIELD_FIELDS_FORMAT_VALIDATORS, (Object)validators);
            try {
                String editor = ff.getEditor();
                rec.setValue(FIELD_FIELDS_FORMAT_EDITOR, (Object)editor);
                DataTable optionsTable = EditorOptionsUtils.createEditorOptionsTable(type, editor, ff.getEditorOptions());
                rec.setValue(FIELD_FIELDS_FORMAT_EDITOR_OPTIONS, (Object)optionsTable);
            }
            catch (Exception exception) {}
        }
        return res;
    }

    public static DataTable formatToTable(TableFormat tf, boolean ignoreHiddenFields) {
        return DataTableBuilding.formatToTable(tf, null, ignoreHiddenFields);
    }

    public static DataTable formatToTable(TableFormat tf) {
        return DataTableBuilding.formatToTable(tf, null);
    }

    public static DataTable formatToTable(TableFormat tf, ClassicEncodingSettings settings) {
        return DataTableBuilding.formatToTable(tf, settings, true);
    }

    public static DataTable formatToTable(TableFormat tf, ClassicEncodingSettings settings, boolean ignoreHiddenFields) {
        DataRecord rec = new DataRecord(TABLE_FORMAT);
        rec.addInt(tf.getMinRecords());
        rec.addInt(tf.getMaxRecords());
        rec.addDataTable(DataTableBuilding.formatToFieldsTable(tf, false, settings, ignoreHiddenFields));
        rec.addBoolean(tf.isReorderable());
        rec.addBoolean(tf.isUnresizable());
        SimpleDataTable bindings = new SimpleDataTable(BINDINGS_FORMAT);
        for (Binding binding : tf.getBindings()) {
            try {
                bindings.addRecord().addString(binding.getTarget().getImage()).addString(binding.getExpression().getText());
            }
            catch (Exception ex) {
                Log.DATATABLE.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        rec.addDataTable(bindings);
        rec.addString(tf.encode(settings != null ? settings : new ClassicEncodingSettings(true)));
        if (tf.getNamingExpression() != null) {
            rec.addString(tf.getNamingExpression().getText());
        }
        return rec.wrap();
    }

    static {
        SELECTION_VALUES_FORMAT.addField("<value><S><F=NK><D=" + Cres.get().getString(FIELD_SELECTION_VALUES_VALUE) + ">");
        SELECTION_VALUES_FORMAT.addField("<description><S><D=" + Cres.get().getString("description") + ">");
        SELECTION_VALUES_FORMAT.addTableValidator(new TableKeyFieldsValidator());
        BINDINGS_FORMAT = new TableFormat(true);
        BINDINGS_FORMAT.addField("<target><S><D=" + Cres.get().getString(FIELD_BINDINGS_TARGET) + "><V=<L=1 " + Integer.MAX_VALUE + ">>");
        BINDINGS_FORMAT.addField("<expression><S><D=" + Cres.get().getString(FIELD_BINDINGS_EXPRESSION) + "><E=" + FIELD_BINDINGS_EXPRESSION + "><V=<L=1 " + Integer.MAX_VALUE + ">>");
        VALIDATORS_FORMAT = new TableFormat(true);
        FieldFormat ff = FieldFormat.create("<validator><S><F=N><D=" + Cres.get().getString(FIELD_FIELDS_FORMAT_TYPE) + ">");
        ff.setSelectionValues(DataTableUtils.getValidatorSelectionValues());
        VALIDATORS_FORMAT.addField(ff);
        VALIDATORS_FORMAT.addField("<options><S><D=" + Cres.get().getString("options") + ">");
        EDITOR_OPTIONS_SIMPLE_FORMAT = new TableFormat(1, 1);
        EDITOR_OPTIONS_SIMPLE_FORMAT.addField(FieldFormat.create("options", 'S', Cres.get().getString("dtEditorOptions")));
        FIELDS_FORMAT = new TableFormat(true);
        FIELDS_FORMAT.addTableValidator(new TableKeyFieldsValidator());
        FIELDS_FORMAT.addField(FieldFormat.create("<oldname><S><F=H>"));
        ff = FieldFormat.create("<name><S><F=K><D=" + Cres.get().getString(FIELD_FIELDS_FORMAT_NAME) + ">");
        ff.getValidators().add(ValidatorHelper.NAME_SYNTAX_VALIDATOR);
        FIELDS_FORMAT.addField(ff);
        ff = FieldFormat.create("<type><S><A=I><D=" + Cres.get().getString(FIELD_FIELDS_FORMAT_TYPE) + ">");
        ff.setSelectionValues(FieldFormat.getTypeSelectionValues());
        FIELDS_FORMAT.addField(ff);
        ff = FieldFormat.create("<description><S><F=N><D=" + Cres.get().getString("description") + ">");
        ff.getValidators().add(ValidatorHelper.DESCRIPTION_SYNTAX_VALIDATOR);
        FIELDS_FORMAT.addField(ff);
        FIELDS_FORMAT.addField(FieldFormat.create("<defaultValue><S><F=N><A=><D=" + Cres.get().getString("default") + ">"));
        FIELDS_FORMAT.addField(FieldFormat.create("<readonly><B><D=" + Cres.get().getString("dtReadOnly") + ">"));
        FIELDS_FORMAT.addField(FieldFormat.create("<nullable><B><D=" + Cres.get().getString("dtNullable") + ">"));
        FIELDS_FORMAT.addField(FieldFormat.create("<key><B><D=" + Cres.get().getString("dtKeyField") + ">"));
        ff = FieldFormat.create("<selvals><T><D=" + Cres.get().getString("dtSelectionValues") + ">");
        ff.setDefault(new SimpleDataTable(SELECTION_VALUES_FORMAT));
        FIELDS_FORMAT.addField(ff);
        FIELDS_FORMAT.addField(FieldFormat.create("<extselvals><B><D=" + Cres.get().getString("dtExtendableSelVals") + ">"));
        ff = FieldFormat.create("<hidden><B><D=" + Cres.get().getString(FIELD_FIELDS_FORMAT_HIDDEN) + ">");
        ff.setAdvanced(true);
        FIELDS_FORMAT.addField(ff);
        ff = FieldFormat.create("<inline><B><D=" + Cres.get().getString(FIELD_FIELDS_FORMAT_INLINE) + ">");
        ff.setAdvanced(true);
        FIELDS_FORMAT.addField(ff);
        ff = FieldFormat.create("<encrypted><B><D=" + Cres.get().getString(FIELD_FIELDS_FORMAT_ENCRYPTED) + ">");
        ff.setAdvanced(true);
        FIELDS_FORMAT.addField(ff);
        ff = FieldFormat.create("<help><S><F=N><D=" + Cres.get().getString(FIELD_FIELDS_FORMAT_HELP) + ">");
        ff.getValidators().add(ValidatorHelper.DESCRIPTION_SYNTAX_VALIDATOR);
        ff.setEditor("textarea");
        FIELDS_FORMAT.addField(ff);
        ff = FieldFormat.create("<editor><S><F=N><D=" + Cres.get().getString("dtEditorViewer") + ">");
        ff.setSelectionValues(DataTableUtils.getEditorSelectionValues());
        ff.setExtendableSelectionValues(true);
        FIELDS_FORMAT.addField(ff);
        ff = FieldFormat.create("<editorOptions><T><F=N><D=" + Cres.get().getString("dtEditorOptions") + ">");
        FIELDS_FORMAT.addField(ff);
        String ref = FIELD_FIELDS_FORMAT_EDITOR_OPTIONS;
        String exp = (Object)((Object)DefaultFunctions.CALL_FUNCTION) + "(\"" + "utilities" + "\", \"" + FIELD_FIELDS_FORMAT_EDITOR_OPTIONS + "\", {" + FIELD_FIELDS_FORMAT_TYPE + "}, {" + FIELD_FIELDS_FORMAT_EDITOR + "}, {" + FIELD_FIELDS_FORMAT_EDITOR_OPTIONS + "})";
        FIELDS_FORMAT.addBinding(ref, exp);
        ref = "editor#choices";
        exp = "{utilities:editors('{type}')}";
        FIELDS_FORMAT.addBinding(ref, exp);
        ff = FieldFormat.create("<validators><T><F=N><D=" + Cres.get().getString("dtValidators") + ">");
        ff.setDefault(new SimpleDataTable(VALIDATORS_FORMAT));
        FIELDS_FORMAT.addField(ff);
        ff = FieldFormat.create("<group><S><F=N><D=" + Cres.get().getString(FIELD_FIELDS_FORMAT_GROUP) + ">");
        FIELDS_FORMAT.addField(ff);
        TABLE_FORMAT = new TableFormat(1, 1);
        ff = FieldFormat.create("<minRecords><I><A=0><D=" + Cres.get().getString("dtMinRecords") + ">");
        ff.getValidators().add(new LimitsValidator(Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE)));
        TABLE_FORMAT.addField(ff);
        ff = FieldFormat.create("<maxRecords><I><F=E><A=2147483647><D=" + Cres.get().getString("dtMaxRecords") + "><S=<" + Cres.get().getString("dtNotLimited") + "=" + Integer.MAX_VALUE + ">>");
        ff.getValidators().add(new LimitsValidator(Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE)));
        TABLE_FORMAT.addField(ff);
        ff = FieldFormat.create("<fields><T><D=" + Cres.get().getString(FIELD_TABLE_FORMAT_FIELDS) + ">");
        ff.setDefault(new SimpleDataTable(FIELDS_FORMAT));
        TABLE_FORMAT.addField(ff);
        ff = FieldFormat.create("<reorderable><B><D=" + Cres.get().getString("dtReorderable") + ">");
        TABLE_FORMAT.addField(ff);
        ff = FieldFormat.create("<unresizable><B><D=" + Cres.get().getString("dtUnresizable") + ">");
        TABLE_FORMAT.addField(ff);
        ff = FieldFormat.create("<bindings><T><D=" + Cres.get().getString(FIELD_TABLE_FORMAT_BINDINGS) + ">");
        ff.setDefault(new SimpleDataTable(BINDINGS_FORMAT));
        TABLE_FORMAT.addField(ff);
        ff = FieldFormat.create("<encoded><S><F=R><D=" + Cres.get().getString("dtEncodedFormat") + "><H=" + Cres.get().getString("dtEncodedFormatHelp") + "><E=" + "textarea" + ">");
        TABLE_FORMAT.addField(ff);
        ff = FieldFormat.create("<namingExpression><S><F=N><D=" + Cres.get().getString(FIELD_TABLE_FORMAT_NAMING_EXPRESSION) + "><E=" + FIELD_BINDINGS_EXPRESSION + ">");
        TABLE_FORMAT.addField(ff);
        TABLE_FORMAT.addTableValidator(new TableExpressionValidator("{minRecords} <= {maxRecords} ? null : '" + Cres.get().getString("dtMaxRecsLessThenMin") + "'"));
        TABLE_FORMAT.setNamingExpression((Object)((Object)DefaultFunctions.PRINT) + "({" + FIELD_TABLE_FORMAT_FIELDS + "}, '{" + FIELD_FIELDS_FORMAT_NAME + "}', ', ')");
    }
}

