/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.binding.Binding;
import com.tibbo.aggregate.common.binding.BindingException;
import com.tibbo.aggregate.common.binding.ChangeCache;
import com.tibbo.aggregate.common.binding.EvaluationOptions;
import com.tibbo.aggregate.common.binding.ReferenceListener;
import com.tibbo.aggregate.common.binding.ReferenceWriter;
import com.tibbo.aggregate.common.datatable.AbstractDataTableBindingProvider;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.structure.Pinpoint;
import com.tibbo.aggregate.common.util.ErrorCollector;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DataTableBindingProvider
extends AbstractDataTableBindingProvider {
    public static final String PROPERTY_ENABLED = "enabled";
    public static final String PROPERTY_HIDDEN = "hidden";
    public static final String PROPERTY_CHOICES = "choices";
    public static final String PROPERTY_OPTIONS = "options";
    private final DataTable table;
    private boolean headless;

    public DataTableBindingProvider(DataTable table) {
        this.table = table;
    }

    public DataTableBindingProvider(DataTable table, ErrorCollector errorCollector) {
        super(errorCollector);
        this.headless = true;
        this.table = table;
    }

    @Override
    public Map<Binding, EvaluationOptions> createBindings() {
        LinkedHashMap<Binding, EvaluationOptions> bm = new LinkedHashMap<Binding, EvaluationOptions>();
        for (Binding b : this.table.getFormat().getBindings()) {
            List<Reference> references = null;
            try {
                references = this.getReferences(b);
            }
            catch (BindingException ex) {
                Log.BINDINGS.warn((Object)("Error finding references in expression " + b.getExpression()));
            }
            if (references != null && !references.isEmpty()) {
                bm.put(b, new EvaluationOptions(2));
                continue;
            }
            bm.put(b, new EvaluationOptions(1));
        }
        return bm;
    }

    @Override
    protected void callReferenceChanged(Reference cause, int method, ReferenceListener listener, boolean asynchronousProcessing) {
        try {
            listener.referenceChanged(cause, null, null, asynchronousProcessing);
        }
        catch (BindingException ex) {
            this.processError(listener.getBinding(), method, cause, ex);
        }
    }

    @Override
    protected ReferenceWriter getExternalReferenceWriter() {
        return null;
    }

    @Override
    protected void setCellValue(Object value, int row, String field) {
        this.table.getRecord(row).setValue(field, value);
    }

    @Override
    protected void setEnabled(Object value, int row, String field) {
    }

    @Override
    protected void setHidden(Object value, int row, String field) {
        if (this.headless) {
            return;
        }
        boolean hidden = (Boolean)value;
        try {
            FieldFormat ff = this.getFieldFormat(row, field);
            if (ff != null) {
                ff.setHidden(hidden);
            }
        }
        catch (BindingException ex) {
            Log.BINDINGS.error((Object)("Error hidden status setting field " + field + " in row " + row + " to " + hidden), (Throwable)ex);
        }
    }

    @Override
    protected void setOptions(Object value, int row, String field) {
        try {
            FieldFormat ff = this.getFieldFormat(row, field);
            if (value == null) {
                return;
            }
            if (value instanceof DataTable) {
                DataTable table = (DataTable)value;
                ff.setEditorOptions(table.encode());
            } else {
                ff.setEditorOptions(value.toString());
            }
        }
        catch (BindingException e) {
            Log.BINDINGS.error((Object)("Error selection values setting field " + field + " in row " + row), (Throwable)e);
        }
    }

    @Override
    protected void setSelectionValues(Object value, int row, String field) {
        try {
            FieldFormat ff = this.getFieldFormat(row, field);
            DataTable selVals = (DataTable)value;
            LinkedHashMap selectionValues = new LinkedHashMap();
            for (DataRecord rec : selVals) {
                Object selVal = ff.valueFromString(rec.getString(0));
                selectionValues.put(selVal, rec.getString(1));
            }
            ff.setSelectionValues(selectionValues);
        }
        catch (BindingException e) {
            Log.BINDINGS.error((Object)("Error selection values setting field " + field + " in row " + row), (Throwable)e);
        }
    }

    @Override
    protected void setEditorEnabled(boolean enabled) {
    }

    @Override
    public void start() {
        for (int i = 0; i < this.table.getRecordCount(); ++i) {
            for (FieldFormat ff : this.table.getFormat()) {
                this.processBindings(ff.getName(), i, true, true);
            }
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public void writeReference(int method, Binding binding, Reference cause, Object value, ChangeCache cache, Pinpoint pinpoint) throws BindingException {
        Reference ref = binding.getTarget();
        Integer row = ref.getRow() != null ? ref.getRow() : (cause != null && cause.getRow() != null ? cause.getRow() : null);
        Reference clone = ref.clone();
        clone.setRow(row);
        this.writeReference(clone, value);
    }

    protected FieldFormat getFieldFormat(int row, String field) throws BindingException {
        if (row >= this.table.getRecordCount()) {
            throw new BindingException(Cres.get().getString("dtRecordNotAvail") + row);
        }
        FieldFormat ff = this.table.getRecord(row).getFormat().getField(field);
        if (ff == null) {
            throw new BindingException(Cres.get().getString("dtFieldNotAvail") + field);
        }
        return ff;
    }
}

