/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable;

import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTableException;
import com.tibbo.aggregate.common.datatable.DataTableQuery;
import com.tibbo.aggregate.common.datatable.DataTableSorter;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.ValidationException;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.datatable.encoding.FormatCache;
import com.tibbo.aggregate.common.expression.AttributedObject;
import com.tibbo.aggregate.common.util.StringEncodable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public interface DataTable
extends Iterable<DataRecord>,
AttributedObject,
StringEncodable {
    public Integer getRecordCount();

    public int getFieldCount();

    public TableFormat getFormat();

    public DataTable setFormat(TableFormat var1);

    public FieldFormat getFormat(int var1);

    public FieldFormat getFormat(String var1);

    public boolean applyCachedFormat(Optional<FormatCache> var1);

    public Long getId();

    public void setId(Long var1);

    public boolean hasField(String var1);

    public DataTable addRecords(List<DataRecord> var1);

    public DataTable addRecord(DataRecord var1);

    public DataRecord addRecord(Object ... var1);

    public DataTable addRecord(int var1, DataRecord var2);

    public DataRecord addRecord();

    public void validate(Context var1, ContextManager var2, CallerController var3) throws DataTableException;

    public void validateRecord(DataRecord var1) throws ValidationException;

    public DataTable setRecord(int var1, DataRecord var2);

    public void swapRecords(int var1, int var2);

    @Deprecated
    public List<DataRecord> getRecords();

    public boolean isInvalid();

    public String getInvalidationMessage();

    public void setInvalidationMessage(String var1);

    @Override
    public Date getTimestamp();

    @Override
    public void setTimestamp(Date var1);

    @Override
    public Integer getQuality();

    @Override
    public void setQuality(Integer var1);

    @Override
    public Object getValue();

    public DataRecord getRecord(int var1);

    public DataRecord getRecordById(String var1);

    public DataRecord removeRecord(int var1);

    public void removeRecordsByIds(Collection<String> var1);

    public void removeRecords(DataRecord var1);

    public void reorderRecord(DataRecord var1, int var2);

    public boolean equals(Object var1);

    public int hashCode();

    public String getEncodedData(ClassicEncodingSettings var1);

    public StringBuilder getEncodedData(StringBuilder var1, ClassicEncodingSettings var2, Boolean var3, Integer var4);

    public String encode();

    public String encode(boolean var1);

    public String encode(ClassicEncodingSettings var1);

    @Override
    public StringBuilder encode(StringBuilder var1, ClassicEncodingSettings var2, Boolean var3, Integer var4);

    public String toString();

    public String getDescription();

    public String toDefaultString();

    public void fixRecords();

    public String dataAsString();

    public String dataAsString(boolean var1, boolean var2);

    public String dataAsString(boolean var1, boolean var2, boolean var3);

    public boolean isOneCellTable();

    public boolean conform(TableFormat var1);

    public String conformMessage(TableFormat var1);

    public List<DataRecord> selectAll(DataTableQuery var1);

    public DataRecord select(DataTableQuery var1);

    public DataRecord select(String var1, Object var2);

    public Integer findIndex(DataTableQuery var1);

    public Integer findIndex(String var1, Object var2);

    public Integer findIndex(DataRecord var1);

    public void sort(String var1, boolean var2);

    public void sort(DataTableSorter var1);

    public void sort(Comparator<DataRecord> var1);

    public DataRecord rec();

    public Object get();

    public void splitFormat();

    public void joinFormats();

    @Override
    public Iterator<DataRecord> iterator();

    public Iterator<DataRecord> iterator(int var1);

    public DataTable clone();

    public int compareTo(DataTable var1);

    public void append(DataTable var1);

    public DataTable makeImmutable();

    public DataTable cloneIfImmutable();

    public boolean isImmutable();

    public boolean isSimple();

    public void close();

    public Stream<DataRecord> stream();
}

