/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.data.Data;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableException;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.QueryCondition;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.ValidationException;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.util.CloneUtils;
import com.tibbo.aggregate.common.util.Element;
import com.tibbo.aggregate.common.util.ElementList;
import com.tibbo.aggregate.common.util.PublicCloneable;
import com.tibbo.aggregate.common.util.StringEncodable;
import com.tibbo.aggregate.common.util.StringUtils;
import com.tibbo.aggregate.common.util.Util;
import java.awt.Color;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DataRecord
implements Cloneable,
PublicCloneable,
StringEncodable {
    private static final int INITIAL_DATA_SIZE = 4;
    private static final String ELEMENT_ID = "I";
    private Map<String, Object> data;
    private TableFormat format = new TableFormat();
    private String id = null;
    private transient DataTable table;

    public DataRecord() {
        this.data = new HashMap<String, Object>(4);
    }

    public DataRecord(TableFormat tableFormat) {
        this.data = new HashMap<String, Object>(tableFormat != null ? tableFormat.getFieldCount() : 4);
        if (tableFormat != null) {
            tableFormat.makeImmutable(null);
            this.format = tableFormat;
        }
    }

    public DataRecord(TableFormat tableFormat, Object ... data) {
        this(tableFormat);
        for (Object param : data) {
            this.addValue(param);
        }
    }

    public DataRecord(TableFormat tableFormat, String dataString, ClassicEncodingSettings settings, boolean validate, List<String> fieldNamesInData) throws DataTableException {
        this(tableFormat);
        this.setData(dataString, settings, validate, fieldNamesInData);
    }

    public DataRecord(TableFormat tableFormat, String dataString) throws DataTableException {
        this(tableFormat, dataString, new ClassicEncodingSettings(false), true, null);
    }

    private void setData(String dataString, ClassicEncodingSettings settings, boolean validate, List<String> fieldNamesInData) throws DataTableException {
        ElementList recs = null;
        try {
            recs = StringUtils.elements(dataString, settings.isUseVisibleSeparators());
        }
        catch (Exception | OutOfMemoryError ex) {
            Log.DATATABLE.warn((Object)ex.getMessage());
        }
        if (recs == null) {
            return;
        }
        int i = 0;
        for (Element el : recs) {
            if (el.getName() != null) {
                if (el.getName().equals(ELEMENT_ID)) {
                    this.setId(el.getValue());
                    continue;
                }
                FieldFormat ff = this.format.getField(el.getName());
                if (ff == null) continue;
                this.setValue(el.getName(), ff.valueFromEncodedString(el.getValue(), settings, validate), validate);
                continue;
            }
            if (fieldNamesInData != null && fieldNamesInData.size() > i) {
                String fieldName = fieldNamesInData.get(i);
                if (this.getFormat().hasField(fieldName)) {
                    Object value = this.format.getField(fieldName).valueFromEncodedString(el.getValue(), settings, validate);
                    this.setValue(fieldName, value, validate);
                }
            } else if (i < this.format.getFieldCount()) {
                Object value = this.format.getField(i).valueFromEncodedString(el.getValue(), settings, validate);
                this.setValue(i, value, validate);
            }
            ++i;
        }
    }

    public int getFieldCount() {
        if (this.format == null) {
            return 0;
        }
        return this.format.getFieldCount();
    }

    public TableFormat getFormat() {
        return this.format;
    }

    public FieldFormat getFormat(int index) {
        return this.format.getField(index);
    }

    public FieldFormat getFormat(String name) {
        return this.format.getField(name);
    }

    public String getId() {
        return this.id;
    }

    public DataTable getTable() {
        return this.table;
    }

    public String encode(boolean useVisibleSeparators) {
        return this.encode(new ClassicEncodingSettings(useVisibleSeparators));
    }

    public String encode(ClassicEncodingSettings settings) {
        return this.encode(new StringBuilder(), settings, false, 0).toString();
    }

    @Override
    public StringBuilder encode(StringBuilder sb, ClassicEncodingSettings settings, Boolean isTransferEncode, Integer encodeLevel) {
        if (this.getId() != null) {
            new Element(ELEMENT_ID, this.getId()).encode(sb, settings, isTransferEncode, encodeLevel);
        }
        for (int i = 0; i < this.format.getFieldCount(); ++i) {
            FieldFormat ff = this.format.getField(i);
            Object value = this.getValue(ff);
            new Element(null, ff, value).encode(sb, settings, isTransferEncode, encodeLevel);
        }
        return sb;
    }

    private boolean checkNumberOfDataFieldsSet(Object value) {
        if (this.data.size() >= this.format.getFieldCount()) {
            Log.DATATABLE.warn((Object)("Can't add data to data record since all data fields defined by format are already set: " + value), (Throwable)new Exception());
            return false;
        }
        return true;
    }

    public DataRecord addInt(Integer val) {
        if (!this.checkNumberOfDataFieldsSet(val)) {
            return this;
        }
        return this.setValue(this.data.size(), (Object)val);
    }

    public DataRecord addString(String val) {
        if (!this.checkNumberOfDataFieldsSet(val)) {
            return this;
        }
        return this.setValue(this.data.size(), (Object)val);
    }

    public DataRecord addBoolean(Boolean val) {
        if (!this.checkNumberOfDataFieldsSet(val)) {
            return this;
        }
        return this.setValue(this.data.size(), (Object)val);
    }

    public DataRecord addLong(Long val) {
        if (!this.checkNumberOfDataFieldsSet(val)) {
            return this;
        }
        return this.setValue(this.data.size(), (Object)val);
    }

    public DataRecord addFloat(Float val) {
        if (!this.checkNumberOfDataFieldsSet(val)) {
            return this;
        }
        return this.setValue(this.data.size(), (Object)val);
    }

    public DataRecord addDouble(Double val) {
        if (!this.checkNumberOfDataFieldsSet(val)) {
            return this;
        }
        return this.setValue(this.data.size(), (Object)val);
    }

    public DataRecord addDate(Date val) {
        if (!this.checkNumberOfDataFieldsSet(val)) {
            return this;
        }
        return this.setValue(this.data.size(), (Object)val);
    }

    public DataRecord addDataTable(DataTable val) {
        if (!this.checkNumberOfDataFieldsSet(val)) {
            return this;
        }
        return this.setValue(this.data.size(), (Object)val);
    }

    public DataRecord addColor(Color val) {
        if (!this.checkNumberOfDataFieldsSet(val)) {
            return this;
        }
        return this.setValue(this.data.size(), (Object)val);
    }

    public DataRecord addData(Data val) {
        if (!this.checkNumberOfDataFieldsSet(val)) {
            return this;
        }
        return this.setValue(this.data.size(), (Object)val);
    }

    public DataRecord setValue(int index, Object value) {
        return this.setValue(index, value, true);
    }

    public DataRecord setValue(int index, Object value, boolean validate) {
        boolean isRecursive;
        this.ensureMutable();
        DataTable recordTable = this.getTable();
        boolean bl = isRecursive = value != null && value == recordTable;
        if (isRecursive) {
            value = recordTable.clone();
        }
        FieldFormat ff = this.getFormat().getField(index);
        try {
            value = ff.checkAndConvertValue(value, validate);
        }
        catch (ValidationException ex) {
            throw new IllegalArgumentException(MessageFormat.format(Cres.get().getString("dtIllegalFieldValue"), value, ff.toDetailedString()) + ex.getMessage(), ex);
        }
        Object oldValue = this.data.get(ff.getName());
        try {
            this.data.put(ff.getName(), value);
            if (this.table != null) {
                this.table.validateRecord(this);
            }
        }
        catch (ValidationException ex1) {
            this.data.put(ff.getName(), oldValue);
            throw new IllegalArgumentException(ex1.getMessage(), ex1);
        }
        return this;
    }

    public DataRecord setValue(String name, Object value) {
        return this.setValue(this.findIndex(name), value, true);
    }

    public DataRecord setValue(String name, Object value, boolean validate) {
        return this.setValue(this.findIndex(name), value, validate);
    }

    public DataRecord setValueSmart(int index, Object value) {
        FieldFormat ff = this.getFormat(index);
        return this.setValueSmart(ff.getName(), value);
    }

    public DataRecord setValueSmart(String name, Object value) {
        FieldFormat ff = this.getFormat().getField(name);
        if (ff == null) {
            throw new IllegalArgumentException(MessageFormat.format(Cres.get().getString("dtFieldNotFound"), name) + ": " + this.dataAsString(true, true));
        }
        if (value == null || ff.getFieldClass().isAssignableFrom(value.getClass()) || ff.getFieldWrappedClass().isAssignableFrom(value.getClass())) {
            return this.setValue(ff.getName(), value);
        }
        String stringValue = value.toString();
        try {
            return this.setValue(ff.getName(), ff.valueFromString(stringValue));
        }
        catch (Exception ex) {
            if (ff.getSelectionValues() != null) {
                for (Object sv : ff.getSelectionValues().keySet()) {
                    String svdesc = ff.getSelectionValues().get(sv).toString();
                    if (!stringValue.equals(svdesc)) continue;
                    return this.setValue(ff.getName(), sv);
                }
            }
            throw new IllegalArgumentException(MessageFormat.format(Cres.get().getString("dtIllegalFieldValue"), Util.getObjectDescription(value), ff.toDetailedString()) + ex.getMessage(), ex);
        }
    }

    public DataRecord addValue(Object value) {
        if (!this.checkNumberOfDataFieldsSet(value)) {
            return this;
        }
        return this.setValue(this.data.size(), value);
    }

    private int findIndex(String name) {
        int index = this.format.getFieldIndex(name);
        if (index == -1) {
            LinkedList<String> fields = new LinkedList<String>();
            for (FieldFormat ff : this.getFormat()) {
                fields.add(ff.getName());
            }
            throw new IllegalArgumentException(MessageFormat.format(Cres.get().getString("dtFieldNotFound"), name) + ": " + StringUtils.print(fields));
        }
        return index;
    }

    public String getString(String name) {
        return this.getString(this.findIndex(name));
    }

    public String getString(int index) {
        return (String)this.getValue(index);
    }

    public Integer getInt(String name) {
        return this.getInt(this.findIndex(name));
    }

    public Integer getInt(int index) {
        return (Integer)this.getValue(index);
    }

    public Boolean getBoolean(String name) {
        return this.getBoolean(this.findIndex(name));
    }

    public Boolean getBoolean(int index) {
        return (Boolean)this.getValue(index);
    }

    public Long getLong(String name) {
        return this.getLong(this.findIndex(name));
    }

    public Long getLong(int index) {
        return (Long)this.getValue(index);
    }

    public Float getFloat(String name) {
        return this.getFloat(this.findIndex(name));
    }

    public Float getFloat(int index) {
        return (Float)this.getValue(index);
    }

    public Double getDouble(String name) {
        return this.getDouble(this.findIndex(name));
    }

    public Double getDouble(int index) {
        return (Double)this.getValue(index);
    }

    public Date getDate(String name) {
        return this.getDate(this.findIndex(name));
    }

    public Date getDate(int index) {
        return (Date)this.getValue(index);
    }

    public DataTable getDataTable(String name) {
        return this.getDataTable(this.findIndex(name));
    }

    public DataTable getDataTable(int index) {
        return (DataTable)this.getValue(index);
    }

    public Color getColor(String name) {
        return this.getColor(this.findIndex(name));
    }

    public Color getColor(int index) {
        return (Color)this.getValue(index);
    }

    public Data getData(String name) {
        return this.getData(this.findIndex(name));
    }

    public Data getData(int index) {
        return (Data)this.getValue(index);
    }

    public Object getValue(int index) {
        FieldFormat ff = this.format.getField(index);
        return this.getValue(ff);
    }

    public Object getValue(String name) {
        return this.getValue(this.findIndex(name));
    }

    private Object getValue(FieldFormat ff) {
        if (this.data.containsKey(ff.getName())) {
            return this.data.get(ff.getName());
        }
        if (ff.isDefaultOverride()) {
            return null;
        }
        return this.isTableImmutable() ? ff.getDefaultValue() : ff.getDefaultValueCopy();
    }

    public Object getValueDescription(String name) {
        Object value = this.getValue(name);
        FieldFormat ff = this.getFormat(name);
        Map sv = ff.getSelectionValues();
        String description = sv != null ? sv.get(value) : null;
        return description != null ? description : ff.valueToString(value);
    }

    public String getValueAsString(String name) {
        return this.getValueAsString(this.findIndex(name));
    }

    public String getValueAsString(int index) {
        return this.format.getField(index).valueToString(this.getValue(index));
    }

    public DataRecord setId(String id) {
        this.ensureMutable();
        this.id = id;
        return this;
    }

    protected void setTable(DataTable table) {
        this.table = table;
    }

    void setFormat(TableFormat format) {
        format.makeImmutable(null);
        this.format = format;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DataRecord)) {
            return false;
        }
        DataRecord rec = (DataRecord)obj;
        if (!Util.equals(this.getId(), rec.getId())) {
            return false;
        }
        if (!(this.table != null && this.table == rec.getTable() || this.format.equals(rec.getFormat()))) {
            return false;
        }
        for (int i = 0; i < this.getFieldCount(); ++i) {
            Object field = this.getValue(i);
            Object value = rec.getValue(i);
            if (!(field != null ? !field.equals(value) : value != null)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        for (int i = 0; i < this.getFieldCount(); ++i) {
            Object field = this.getValue(i);
            result = 31 * result + (field != null ? field.hashCode() : 0);
        }
        return result;
    }

    public boolean hasField(String name) {
        return this.getFormat().hasField(name);
    }

    protected boolean meetToCondition(QueryCondition condition) {
        if (this.hasField(condition.getField())) {
            Object recValue = this.getValue(condition.getField());
            Object condValue = condition.getValue();
            int operator = condition.getOperator();
            if (recValue == null || condValue == null) {
                if (operator == 1) {
                    return condValue == recValue;
                }
                if (operator == 8) {
                    return condValue != recValue;
                }
                throw new IllegalArgumentException("Can't compare value to NULL");
            }
            if (operator == 8) {
                return !recValue.equals(condValue);
            }
            if ((operator & 1) > 0) {
                if (recValue.equals(condValue)) {
                    return true;
                }
                if (operator == 1) {
                    return false;
                }
            }
            if (!(recValue instanceof Comparable)) {
                throw new IllegalArgumentException("Value isn't comparable: " + recValue);
            }
            Comparable compRecValue = (Comparable)recValue;
            if ((operator & 2) > 0) {
                return compRecValue.compareTo(condValue) > 0;
            }
            if ((operator & 4) > 0) {
                return compRecValue.compareTo(condValue) < 0;
            }
            throw new IllegalArgumentException("Illegal operator: " + operator);
        }
        return false;
    }

    public void cloneFormatFromTable() {
        this.format = this.table != null ? this.table.getFormat().clone() : this.format.clone();
    }

    public String dataAsString(boolean showFieldNames, boolean showHiddenFields) {
        return this.dataAsString(showFieldNames, showHiddenFields, true);
    }

    public String dataAsString(boolean showFieldNames, boolean showHiddenFields, boolean showPasswords) {
        StringBuffer res = new StringBuffer();
        boolean needSeparator = false;
        for (FieldFormat ff : this.getFormat()) {
            if (ff.isHidden() && !showHiddenFields) continue;
            if (needSeparator) {
                res.append(", ");
            } else {
                needSeparator = true;
            }
            String value = this.valueAsString(ff.getName(), showFieldNames, showHiddenFields, showPasswords);
            if ("password".equals(ff.getEditor()) && !showPasswords) {
                value = StringUtils.createMaskedPasswordString(value.length());
            }
            res.append((showFieldNames ? ff.toString() + "=" : "") + value);
        }
        return res.toString();
    }

    public String valueAsString(String name) {
        return this.valueAsString(name, true, false, true);
    }

    public String valueAsString(String name, boolean showFieldNames, boolean showHiddenFields, boolean showPasswords) {
        String value;
        FieldFormat ff = this.getFormat(name);
        Object val = this.getValue(name);
        String string = val != null ? ('T' == ff.getType() && !((DataTable)val).isSimple() ? ((DataTable)val).dataAsString(showFieldNames, showHiddenFields, showPasswords) : val.toString()) : (value = "NULL");
        if (ff.hasSelectionValues()) {
            String sv = ff.getSelectionValues().get(val);
            value = sv != null ? sv.toString() : value;
        }
        return value;
    }

    public String toString() {
        return this.dataAsString(true, true);
    }

    public DataTable wrap() {
        return new SimpleDataTable(this);
    }

    @Override
    public DataRecord clone() {
        DataRecord cl = null;
        try {
            cl = (DataRecord)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
        cl.data = (Map)CloneUtils.deepClone(this.data);
        return cl;
    }

    private void ensureMutable() {
        if (this.isTableImmutable()) {
            if (Log.DATATABLE.isDebugEnabled()) {
                Log.DATATABLE.warn((Object)"Attempt to change immutable record", (Throwable)new IllegalStateException());
            } else {
                Log.DATATABLE.warn((Object)"Attempt to change immutable record");
            }
            throw new IllegalStateException("Immutable");
        }
    }

    private boolean isTableImmutable() {
        return this.table != null && this.table.isImmutable();
    }
}

