/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.datatable;

import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.data.Data;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import java.util.HashMap;
import java.util.Map;

public class DataBlocksPreprocessor {
    private final Mode mode;
    private Map<Long, Data> dataBlocksCache;

    public DataBlocksPreprocessor() {
        this(Mode.INLINE_BLOCKS_WITHOUT_ID);
    }

    public DataBlocksPreprocessor(Mode mode) {
        this.mode = mode;
        if (this.mode == Mode.CACHE_BLOCKS) {
            this.dataBlocksCache = new HashMap<Long, Data>();
        }
    }

    public Map<Long, Data> getDataBlocks() {
        return this.dataBlocksCache;
    }

    public void process(DataTable table, ContextManager cm, CallerController cc) throws ContextException {
        if (table == null) {
            return;
        }
        for (FieldFormat ff : table.getFormat()) {
            if (ff.getType() == 'A') {
                for (DataRecord rec : table) {
                    Data data = rec.getData(ff.getName());
                    if (data == null || data.getId() == null) continue;
                    if (this.mode == Mode.CACHE_BLOCKS) {
                        if (this.dataBlocksCache.containsKey(data.getId())) {
                            data.releaseData();
                            continue;
                        }
                        data.fetchData(cm, cc);
                        if (data.getData() == null) continue;
                        this.dataBlocksCache.put(data.getId(), data);
                        continue;
                    }
                    data.fetchData(cm, cc);
                    if (this.mode != Mode.INLINE_BLOCKS_WITHOUT_ID) continue;
                    data.setId(null);
                }
            }
            if (ff.getType() != 'T') continue;
            for (DataRecord rec : table) {
                DataTable dt = rec.getDataTable(ff.getName());
                this.process(dt, cm, cc);
            }
        }
    }

    public static enum Mode {
        INLINE_BLOCKS_WITH_ID,
        INLINE_BLOCKS_WITHOUT_ID,
        CACHE_BLOCKS;

    }
}

